/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.FeatureType;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.internal.accessibility.AccessibilityBuilder;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.internal.accessibility.AccessibleNode;
import com.ibm.vis.internal.accessibility.AtLink;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AtTreeBuilder {
    private static final String G0 = "G0";
    private static final String GRAPH = "graph";
    private final AccessibilityBuilder builder = new AccessibilityBuilder();

    public List<AccessibleNode> buildTree(CompositeSceneNode compositeSceneNode) {
        ArrayList<AccessibleNode> arrayList = new ArrayList<AccessibleNode>();
        HashMap<String, Map<FeatureType, ArrayList<SceneNode>>> hashMap = new HashMap<String, Map<FeatureType, ArrayList<SceneNode>>>();
        List<String> list = this.populateFeatureMap(compositeSceneNode, hashMap);
        if (list.size() == 1) {
            Map map = (Map)hashMap.get(list.get(0));
            this.addSceneChildren(arrayList, map);
        } else {
            String string = Internationalization.getString(GRAPH);
            for (String string2 : list) {
                Map map = (Map)hashMap.get(string2);
                int n = SceneIdUtil.getIndexFromID(string2, 'G') + 1;
                String string3 = string + " " + n;
                AccessibleInfo accessibleInfo = new AccessibleInfo();
                accessibleInfo.setStringProperty("label", string3);
                accessibleInfo.setStringProperty("type", string3);
                AccessibleNode accessibleNode = new AccessibleNode(accessibleInfo, null);
                arrayList.add(accessibleNode);
                this.addSceneChildren(accessibleNode.getChildren(), map);
            }
        }
        return arrayList;
    }

    private void fixLinks(ElementGroupSceneNode elementGroupSceneNode, ArrayList<AccessibleNode> arrayList) {
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        if (!list.isEmpty()) {
            AccessibleNode accessibleNode;
            AccessibleInfo accessibleInfo;
            AccessibleInfo accessibleInfo2 = accessibleInfo = elementGroupSceneNode.getA11y() == null ? new AccessibleInfo() : elementGroupSceneNode.getA11y();
            if (accessibleInfo.getStringProperty("linkFrom") != null && (accessibleNode = this.getNodeGroup(elementGroupSceneNode, arrayList)) != null) {
                this.addLinksToNodes(elementGroupSceneNode, accessibleNode);
            }
        }
    }

    private AccessibleNode makeElementGroup(ElementGroupSceneNode elementGroupSceneNode, ArrayList<AccessibleNode> arrayList, int n, int n2) {
        AccessibleInfo accessibleInfo;
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        if (list.isEmpty()) {
            return null;
        }
        AccessibleInfo accessibleInfo2 = accessibleInfo = elementGroupSceneNode.getA11y() == null ? new AccessibleInfo() : elementGroupSceneNode.getA11y();
        if (accessibleInfo.getStringProperty("linkFrom") != null) {
            return null;
        }
        if ("*".equals(elementGroupSceneNode.getLink())) {
            AccessibleNode accessibleNode = new AccessibleNode(accessibleInfo, elementGroupSceneNode.getId());
            HashMap<String, AccessibleNode> hashMap = new HashMap<String, AccessibleNode>();
            ArrayList<SceneNode> arrayList2 = new ArrayList<SceneNode>();
            for (SceneNode sceneNode : list) {
                AccessibleInfo accessibleInfo3 = ((SceneNodeImpl)sceneNode).getA11y();
                if (accessibleInfo3 == null) continue;
                Object object = accessibleInfo3.getProperty("chordFrom");
                Object object2 = accessibleInfo3.getProperty("chordTo");
                if (object == null && object2 == null) continue;
                String string = sceneNode.getId();
                AccessibleNode accessibleNode2 = new AccessibleNode(accessibleInfo3, string);
                hashMap.put(string, accessibleNode2);
                accessibleNode.addChild(accessibleNode2);
                arrayList2.add(sceneNode);
            }
            this.addLinks(elementGroupSceneNode, hashMap, true);
            return accessibleNode.getChildren().isEmpty() ? null : accessibleNode;
        }
        AccessibleNode accessibleNode = new AccessibleNode(accessibleInfo, null);
        if (list.get(0).getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
            for (SceneNode sceneNode : list) {
                AccessibleNode accessibleNode3;
                if (sceneNode.getClassId() != SceneNodeClassId.ELEMENT_GROUP || (accessibleNode3 = this.makeElementGroup((ElementGroupSceneNode)sceneNode, arrayList, 1, 1)) == null) continue;
                accessibleNode.addChild(accessibleNode3);
            }
        } else {
            this.addChildren(accessibleNode, elementGroupSceneNode, accessibleInfo, true, elementGroupSceneNode.hasLabels());
        }
        accessibleInfo.setLabelToBaseIfMissing();
        this.addTypeLabelFromLabel(accessibleInfo, n, n2);
        this.mergeLabelAndGroupSum(accessibleInfo, "stackSum");
        this.mergeLabelAndGroupSum(accessibleInfo, "clusterSum");
        return accessibleNode.getChildren().isEmpty() ? null : accessibleNode;
    }

    private void addTypeLabelFromLabel(AccessibleInfo accessibleInfo, int n, int n2) {
        String string = accessibleInfo.getStringProperty("simpleLabel");
        if (string == null) {
            string = accessibleInfo.getStringProperty("label");
        }
        this.addTypeLabel(accessibleInfo, string, n, n2);
    }

    protected AccessibleNode getNodeGroup(ElementGroupSceneNode elementGroupSceneNode, ArrayList<AccessibleNode> arrayList) {
        int n;
        String string = elementGroupSceneNode.getA11y().getStringProperty("linkFrom");
        for (int i = n = arrayList.size() - 1; i > -1; --i) {
            String string2;
            AccessibleNode accessibleNode = arrayList.get(i);
            ArrayList<String> arrayList2 = accessibleNode.getSceneIds();
            if (arrayList2.isEmpty() || !(string2 = arrayList2.get(0)).startsWith(string)) continue;
            return accessibleNode;
        }
        return null;
    }

    private void addLinksToNodes(ElementGroupSceneNode elementGroupSceneNode, AccessibleNode accessibleNode) {
        HashMap<String, AccessibleNode> hashMap = new HashMap<String, AccessibleNode>();
        this.populateIdMap(hashMap, accessibleNode);
        this.addLinks(elementGroupSceneNode, hashMap, false);
    }

    private void populateIdMap(Map<String, AccessibleNode> map, AccessibleNode accessibleNode) {
        for (AccessibleNode accessibleNode2 : accessibleNode.getChildren()) {
            this.populateIdMap(map, accessibleNode2);
            String string = accessibleNode2.getSceneId();
            if (string == null) continue;
            map.put(string, accessibleNode2);
        }
    }

    private void addLinks(ElementGroupSceneNode elementGroupSceneNode, Map<String, AccessibleNode> map, boolean bl) {
        for (SceneNode sceneNode : elementGroupSceneNode.getChildren()) {
            if (sceneNode.getType() == SceneNodeType.ELEMENT) {
                this.addLinks((ElementGroupSceneNode)sceneNode, map, bl);
                continue;
            }
            AccessibleInfo accessibleInfo = ((SceneNodeImpl)sceneNode).getA11y();
            AccessibleNode accessibleNode = map.get(accessibleInfo.getStringProperty("linkFrom"));
            AccessibleNode accessibleNode2 = map.get(accessibleInfo.getStringProperty("linkTo"));
            if (accessibleNode2 == null || accessibleNode == null) continue;
            AccessibleNode accessibleNode3 = bl ? new AccessibleNode(accessibleInfo, sceneNode.getId()) : null;
            AtLink atLink = new AtLink(accessibleNode, accessibleNode2, sceneNode.getId(), accessibleNode3);
            accessibleNode.addLink(atLink);
            accessibleNode2.addLink(atLink);
        }
    }

    protected void mergeLabelAndGroupSum(AccessibleInfo accessibleInfo, String string) {
        String string2 = accessibleInfo.getStringProperty(string);
        if (string2 != null) {
            String string3 = accessibleInfo.getStringProperty("label");
            String string4 = Internationalization.getString(string) + " " + string2;
            String string5 = string3 == null ? string4 : this.builder.makeLabel(string3, string4);
            accessibleInfo.setStringProperty("label", string5);
            accessibleInfo.getProperties().remove(string);
        }
    }

    private AccessibleNode makeGroupNode(SceneNodeImpl sceneNodeImpl, String string, boolean bl, int n, int n2) {
        AccessibleInfo accessibleInfo = sceneNodeImpl.getA11y() == null ? new AccessibleInfo() : sceneNodeImpl.getA11y();
        String string2 = accessibleInfo.getStringProperty("label");
        if (string2 == null && string != null) {
            String string3 = Internationalization.getString(string);
            accessibleInfo.setStringProperty("label", string3);
        } else if (bl) {
            String string4 = Internationalization.getString(string);
            string2 = string2 == null ? string4 : string2 + " " + string4;
            accessibleInfo.setStringProperty("label", string2);
        }
        this.addTypeLabelFromLabel(accessibleInfo, n, n2);
        return new AccessibleNode(accessibleInfo, null);
    }

    private void addTypeLabel(AccessibleInfo accessibleInfo, String string, int n, int n2) {
        if (n2 == 1) {
            accessibleInfo.setStringProperty("type", string);
        } else {
            String[] stringArray = new String[]{string + " " + (n + 1), String.valueOf(n2)};
            String string2 = AccessibilityBuilder.ParseLocalizationString(Internationalization.getString("of"), string + " " + (n + 1), 1);
            string2 = AccessibilityBuilder.ParseLocalizationString(string2, String.valueOf(n2), 2);
            accessibleInfo.setStringProperty("type", string2);
        }
    }

    private void addFeatures(ArrayList<AccessibleNode> arrayList, FeatureType featureType, ArrayList<SceneNode> arrayList2, boolean bl) {
        SceneNodeImpl sceneNodeImpl;
        int n;
        if (arrayList2 == null) {
            return;
        }
        int n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            Object object;
            Object object2;
            sceneNodeImpl = (SceneNodeImpl)arrayList2.get(n);
            if (featureType == FeatureType.TITLE) {
                object2 = sceneNodeImpl.getA11y();
                object2 = object2 == null ? new AccessibleInfo() : object2;
                object = ((AccessibleInfo)object2).getBooleanProperty("ignore");
                if (object == null || !((Boolean)object).booleanValue()) {
                    this.addTypeLabel((AccessibleInfo)object2, Internationalization.getString(SceneNodeTypeUtil.toString(SceneNodeType.TITLE)), n, n2);
                    arrayList.add(new AccessibleNode((AccessibleInfo)object2, sceneNodeImpl.getId()));
                }
            } else if (featureType == FeatureType.ELEMENT) {
                object2 = this.makeElementGroup((ElementGroupSceneNode)sceneNodeImpl, arrayList, n, n2);
                if (object2 != null) {
                    arrayList.add((AccessibleNode)object2);
                }
            } else if (featureType == FeatureType.LEGEND) {
                this.addLegend(arrayList, sceneNodeImpl, bl, n, n2);
            } else if (featureType == FeatureType.AXIS) {
                this.addAxis(arrayList, sceneNodeImpl, n, n2);
            } else if (featureType == FeatureType.GRIDLINE) {
                if (SceneIdUtil.isGridBandId(SceneIdUtil.getBaseIdForSceneNode(sceneNodeImpl))) continue;
                object2 = sceneNodeImpl;
                object = ((SceneNodeImpl)object2).getA11y() == null ? new AccessibleInfo() : ((SceneNodeImpl)object2).getA11y();
                this.addTypeLabelFromLabel((AccessibleInfo)object, n, n2);
                AccessibleNode accessibleNode = new AccessibleNode((AccessibleInfo)object, null);
                if (this.addChildren(accessibleNode, (SceneNode)object2, (AccessibleInfo)object, false, false)) {
                    ((AccessibleInfo)object).setLabelToBaseIfMissing();
                    arrayList.add(accessibleNode);
                }
            } else if (featureType == FeatureType.FACET) {
                arrayList.add(this.makeFacet(sceneNodeImpl));
            }
            bl = false;
        }
        for (n = 0; n < n2; ++n) {
            if (featureType != FeatureType.ELEMENT) continue;
            sceneNodeImpl = (SceneNodeImpl)arrayList2.get(n);
            this.fixLinks((ElementGroupSceneNode)sceneNodeImpl, arrayList);
        }
    }

    private void addLegend(ArrayList<AccessibleNode> arrayList, SceneNodeImpl sceneNodeImpl, boolean bl, int n, int n2) {
        AccessibleNode accessibleNode = this.makeGroupNode(sceneNodeImpl, "legend", bl, n, n2);
        arrayList.add(accessibleNode);
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            this.addLegendEntryWithText(accessibleNode, sceneNode);
        }
    }

    private void addLegendEntryWithText(AccessibleNode accessibleNode, SceneNode sceneNode) {
        if (sceneNode.getType() != SceneNodeType.LEGEND_ENTRY) {
            return;
        }
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            String string = this.getText(sceneNode2);
            if (string == null) continue;
            AccessibleInfo accessibleInfo = new AccessibleInfo();
            accessibleInfo.setStringProperty("label", string);
            accessibleNode.addChild(new AccessibleNode(accessibleInfo, sceneNode.getId()));
            return;
        }
    }

    private String getText(SceneNode sceneNode) {
        TextInfo textInfo;
        ShapeInfo shapeInfo = sceneNode.getShape();
        if (shapeInfo != null && (textInfo = shapeInfo.getTextInfo()) != null) {
            return textInfo.getText();
        }
        return null;
    }

    private void addSceneChildren(ArrayList<AccessibleNode> arrayList, Map<FeatureType, ArrayList<SceneNode>> map) {
        FeatureType[] featureTypeArray = new FeatureType[]{FeatureType.TITLE, FeatureType.AXIS, FeatureType.LEGEND, FeatureType.ELEMENT, FeatureType.GRIDLINE, FeatureType.FACET};
        boolean bl = true;
        for (int i = 0; i < featureTypeArray.length; ++i) {
            FeatureType featureType = featureTypeArray[i];
            ArrayList<SceneNode> arrayList2 = map.get((Object)featureType);
            if (featureType == FeatureType.AXIS || featureType == FeatureType.LEGEND) {
                bl = this.addFeaturesNeedingSplits(arrayList, bl, featureType, arrayList2);
            } else {
                this.addFeatures(arrayList, featureType, arrayList2, bl);
            }
            if (arrayList2 == null) continue;
            bl = false;
        }
    }

    private boolean addFeaturesNeedingSplits(ArrayList<AccessibleNode> arrayList, boolean bl, FeatureType featureType, ArrayList<SceneNode> arrayList2) {
        ArrayList<ArrayList<SceneNode>> arrayList3 = this.split(arrayList2);
        for (ArrayList<SceneNode> arrayList4 : arrayList3) {
            this.addFeatures(arrayList, featureType, arrayList4, bl);
            bl = false;
        }
        return bl;
    }

    private ArrayList<ArrayList<SceneNode>> split(ArrayList<SceneNode> arrayList) {
        ArrayList<ArrayList<SceneNode>> arrayList2 = new ArrayList<ArrayList<SceneNode>>();
        if (arrayList == null) {
            return arrayList2;
        }
        String string = null;
        ArrayList<SceneNode> arrayList3 = null;
        for (SceneNode sceneNode : arrayList) {
            AccessibleInfo accessibleInfo = ((SceneNodeImpl)sceneNode).getA11y();
            String string2 = accessibleInfo.getStringProperty("label");
            if (string2 != null && string2.equals(string)) {
                arrayList3.add(sceneNode);
                continue;
            }
            string = string2;
            arrayList3 = new ArrayList<SceneNode>();
            arrayList2.add(arrayList3);
            arrayList3.add(sceneNode);
        }
        return arrayList2;
    }

    private List<String> populateFeatureMap(SceneNode sceneNode, Map<String, Map<FeatureType, ArrayList<SceneNode>>> map) {
        List<SceneNode> list = sceneNode.getChildren();
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            ArrayList<SceneNode> arrayList2;
            Map<FeatureType, ArrayList<SceneNode>> map2;
            String string;
            SceneNode sceneNode2 = list.get(i);
            FeatureType featureType = SceneHelper.getFeatureType(sceneNode2);
            if (featureType == null || (string = this.getGraphIndex(sceneNode2, featureType)) == null) continue;
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            if ((map2 = map.get(string)) == null) {
                map2 = new HashMap<FeatureType, ArrayList<SceneNode>>();
                map.put(string, map2);
            }
            if ((arrayList2 = map2.get((Object)featureType)) == null) {
                arrayList2 = new ArrayList();
                map2.put(featureType, arrayList2);
            }
            arrayList2.add(sceneNode2);
        }
        return arrayList;
    }

    private String getGraphIndex(SceneNode sceneNode, FeatureType featureType) {
        if (sceneNode == null) {
            return null;
        }
        String string = sceneNode.getId();
        if (string == null && featureType != FeatureType.ELEMENT && featureType != FeatureType.AXIS && featureType != FeatureType.GRIDLINE && featureType != FeatureType.FACET) {
            return null;
        }
        String string2 = string == null ? this.getGraphIndex(this.getNonNullChild(sceneNode), featureType) : SceneIdUtil.getGraphIndex(string);
        return string2 == null ? G0 : string2;
    }

    private SceneNode getNonNullChild(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        for (SceneNode sceneNode2 : list) {
            if (sceneNode2 == null || sceneNode2.getId() == null && sceneNode2.getChildren().isEmpty()) continue;
            return sceneNode2;
        }
        return null;
    }

    private SceneNode getAxisTitleAndLabels(SceneNode sceneNode, ArrayList<SceneNode> arrayList) {
        SceneNode sceneNode2 = null;
        for (SceneNode sceneNode3 : sceneNode.getChildren()) {
            SceneNodeClassId sceneNodeClassId = sceneNode3.getClassId();
            if (sceneNodeClassId == SceneNodeClassId.SHAPE || sceneNodeClassId == SceneNodeClassId.SCHEMA_SHAPE) {
                if (this.isAxisTitle(sceneNode3)) {
                    sceneNode2 = sceneNode3;
                    continue;
                }
                Shape shape = (Shape)sceneNode3.getShape();
                if (!shape.isPrimaryTextType()) continue;
                arrayList.add(sceneNode3);
                continue;
            }
            if (sceneNodeClassId != SceneNodeClassId.GROUP || SceneNodeType.AXIS_LABEL != sceneNode3.getType()) continue;
            this.getAxisTitleAndLabels(sceneNode3, arrayList);
        }
        return sceneNode2;
    }

    private void addAxis(ArrayList<AccessibleNode> arrayList, SceneNodeImpl sceneNodeImpl, int n, int n2) {
        ArrayList<SceneNode> arrayList2 = new ArrayList<SceneNode>();
        SceneNode sceneNode = this.getAxisTitleAndLabels(sceneNodeImpl, arrayList2);
        int n3 = arrayList2.size();
        if (n3 == 0 && sceneNode != null) {
            return;
        }
        AccessibleNode accessibleNode = this.makeGroupNode(sceneNodeImpl, null, false, n, n2);
        arrayList.add(accessibleNode);
        for (SceneNode sceneNode2 : arrayList2) {
            String string;
            AccessibleInfo accessibleInfo = ((SceneNodeImpl)sceneNode2).getA11y();
            if (accessibleInfo.getStringProperty("label") == null && (string = this.getText(sceneNode2)) != null) {
                accessibleInfo.setStringProperty("label", string);
            }
            accessibleNode.addChild(new AccessibleNode(accessibleInfo, sceneNode2.getId()));
        }
    }

    private boolean isAxisTitle(SceneNode sceneNode) {
        String string = sceneNode.getId();
        return string != null && string.indexOf("Title") != -1;
    }

    private void setTypeFromLabel(AccessibleInfo accessibleInfo) {
        String string = accessibleInfo.getStringProperty("simpleLabel");
        if (string == null) {
            string = accessibleInfo.getStringProperty("label");
        }
        if (string != null) {
            accessibleInfo.setStringProperty("type", string);
        }
    }

    private AccessibleNode makeFacet(SceneNodeImpl sceneNodeImpl) {
        AccessibleInfo accessibleInfo = sceneNodeImpl.getA11y() == null ? new AccessibleInfo() : sceneNodeImpl.getA11y();
        this.setTypeFromLabel(accessibleInfo);
        AccessibleNode accessibleNode = new AccessibleNode(accessibleInfo, null);
        ArrayList<AccessibleNode> arrayList = accessibleNode.getChildren();
        AtTreeBuilder atTreeBuilder = new AtTreeBuilder();
        List<AccessibleNode> list = atTreeBuilder.buildTree((CompositeSceneNode)sceneNodeImpl);
        arrayList.addAll(list);
        return accessibleNode;
    }

    private boolean ignore(AccessibleInfo accessibleInfo) {
        AccessibleInfo accessibleInfo2 = (AccessibleInfo)accessibleInfo.getProperty("base");
        if (accessibleInfo2 == null) {
            return false;
        }
        Boolean bl = accessibleInfo2.getBooleanProperty("ignore");
        return bl != null && bl != false;
    }

    private boolean addChildren(AccessibleNode accessibleNode, SceneNode sceneNode, AccessibleInfo accessibleInfo, boolean bl, boolean bl2) {
        if (this.ignore(accessibleInfo)) {
            return false;
        }
        AccessibleInfo accessibleInfo2 = (AccessibleInfo)accessibleInfo.getProperty("base");
        String string = null;
        if (accessibleInfo2 == null) {
            accessibleInfo2 = new AccessibleInfo();
        } else {
            string = accessibleInfo2.getStringProperty("label");
            accessibleInfo2 = accessibleInfo2.copy();
            accessibleInfo2.setStringProperty("label", null);
        }
        if (bl2) {
            this.mergeElementSymbolsAndLabels(sceneNode, accessibleNode, accessibleInfo2);
        } else {
            String string2 = Internationalization.getString("comma");
            for (SceneNode sceneNode2 : sceneNode.getChildren()) {
                AccessibleInfo accessibleInfo3 = accessibleInfo2.combine(((SceneNodeImpl)sceneNode2).getA11y());
                Boolean bl3 = accessibleInfo3.getBooleanProperty("ignore");
                if (bl3 != null && bl3.booleanValue()) continue;
                this.buildLabel(bl, string, sceneNode2, accessibleInfo3, string2);
                accessibleNode.addChild(new AccessibleNode(accessibleInfo3, sceneNode2.getId()));
            }
        }
        return true;
    }

    protected void buildLabel(boolean bl, String string, SceneNode sceneNode, AccessibleInfo accessibleInfo, String string2) {
        if (accessibleInfo.getStringProperty("label") == null) {
            if (bl) {
                String string3 = this.getText(sceneNode);
                if (string3 == null && string == null) {
                    String string4 = accessibleInfo.getLabelFromSummary(string2);
                    if (string4 != null) {
                        accessibleInfo.setStringProperty("label", string4);
                    }
                } else {
                    String string5 = string == null ? string3 : (string3 == null ? string : this.builder.makeLabel(string3, string));
                    accessibleInfo.setStringProperty("label", string5);
                }
            } else {
                String string6 = this.getText(sceneNode);
                if (string6 != null) {
                    accessibleInfo.setStringProperty("label", string6);
                }
            }
        }
    }

    private void mergeElementSymbolsAndLabels(SceneNode sceneNode, AccessibleNode accessibleNode, AccessibleInfo accessibleInfo) {
        Object object;
        Object object2;
        String string = accessibleInfo.getStringProperty("label");
        String string2 = Internationalization.getString("comma");
        LinkedHashMap<String, ArrayList<AccessibleNode>> linkedHashMap = new LinkedHashMap<String, ArrayList<AccessibleNode>>();
        HashMap<String, SceneNode> hashMap = new HashMap<String, SceneNode>();
        for (SceneNode object3 : sceneNode.getChildren()) {
            String string3;
            String string4;
            object2 = accessibleInfo.combine(((SceneNodeImpl)object3).getA11y());
            object = ((AccessibleInfo)object2).getBooleanProperty("ignore");
            if (object != null && ((Boolean)object).booleanValue() || object3.getId() == null || (string4 = SceneIdUtil.getElementMemberKeyFromId(string3 = object3.getId())) == null) continue;
            this.buildLabel(true, string, object3, (AccessibleInfo)object2, string2);
            ArrayList<AccessibleNode> arrayList = (ArrayList<AccessibleNode>)linkedHashMap.get(string4);
            if (arrayList == null) {
                hashMap.put(string4, object3);
                arrayList = new ArrayList<AccessibleNode>();
                linkedHashMap.put(string4, arrayList);
            }
            arrayList.add(new AccessibleNode((AccessibleInfo)object2, string3));
        }
        for (String string5 : linkedHashMap.keySet()) {
            object2 = (List)linkedHashMap.get(string5);
            object = (AccessibleNode)object2.get(0);
            accessibleNode.addChild((AccessibleNode)object);
            int n = object2.size();
            for (int i = n - 1; i > 0; --i) {
                ((AccessibleNode)object).mergeLabel((AccessibleNode)object2.get(i), string2);
            }
        }
    }
}

