/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.label.TooltipProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.internal.accessibility.AccessibilityBuilder;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ChordChartModifier {
    private final AccessibilityBuilder builder;
    private final SceneHelper helper;

    ChordChartModifier(AccessibilityBuilder accessibilityBuilder, SceneHelper sceneHelper) {
        this.builder = accessibilityBuilder;
        this.helper = sceneHelper;
    }

    void addChordAccessibility(ElementGroupSceneNode elementGroupSceneNode) {
        Object object;
        HashMap<Double, SceneNode> hashMap = new HashMap<Double, SceneNode>();
        HashMap<Double, SceneNode> hashMap2 = new HashMap<Double, SceneNode>();
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        for (SceneNode object22 : elementGroupSceneNode.getChildren()) {
            object = ((SceneNodeImpl)object22).getA11y();
            if (object != null) {
                if (!this.addToGroupMap(hashMap, object22, "chordFrom", (AccessibleInfo)object) && !this.addToGroupMap(hashMap2, object22, "chordTo", (AccessibleInfo)object) && SceneHelper.isElementSymbol(object22.getId())) {
                    arrayList.add(object22);
                }
                ((AccessibleInfo)object).setProperty("fieldSummary", null);
                continue;
            }
            if (!SceneHelper.isElementSymbol(object22.getId())) continue;
            arrayList.add(object22);
        }
        String string = SceneIdUtil.getBaseIdForSceneNode(elementGroupSceneNode);
        Field field = this.helper.getToField(string);
        object = this.helper.getFromField(string);
        Field field2 = this.helper.getSizeField(string);
        TooltipProducer tooltipProducer = this.helper.getTooltipProducer(string, field);
        HashMap<String, SceneNode> hashMap3 = this.mapToCategory((Field)object, hashMap);
        HashMap<String, SceneNode> hashMap4 = this.mapToCategory(field, hashMap2);
        this.populateCombinedCategories(field, hashMap3, hashMap4);
        this.populateCombinedCategories((Field)object, hashMap4, hashMap3);
        for (SceneNode sceneNode : arrayList) {
            Shape shape = (Shape)sceneNode.getShape();
            int[] nArray = shape.getRows();
            SceneNode sceneNode2 = this.getGroup(hashMap2, hashMap4, field, nArray[0]);
            SceneNode sceneNode3 = this.getGroup(hashMap, hashMap3, (Field)object, nArray[0]);
            AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
            accessibleInfo.setStringProperty("linkFrom", sceneNode3.getId());
            accessibleInfo.setStringProperty("linkTo", sceneNode2.getId());
            accessibleInfo.setStringProperty("label", this.builder.makeChordLabel((Field)object, field, field2, shape, tooltipProducer));
        }
        this.addChordCategoryLabels(hashMap, (Field)object, "chordFrom");
        this.addChordCategoryLabels(hashMap2, field, "chordTo");
    }

    private boolean addToGroupMap(HashMap<Double, SceneNode> hashMap, SceneNode sceneNode, String string, AccessibleInfo accessibleInfo) {
        Object object = accessibleInfo.getProperty(string);
        if (object == null) {
            return false;
        }
        hashMap.put((Double)object, sceneNode);
        return true;
    }

    private void addChordCategoryLabels(HashMap<Double, SceneNode> hashMap, Field field, String string) {
        for (SceneNode sceneNode : hashMap.values()) {
            AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
            Number number = (Number)accessibleInfo.getProperty(string);
            String string2 = field.getFormattedStringValue(number.doubleValue(), 0, null);
            if (string2 == null) continue;
            accessibleInfo.setStringProperty("label", string2);
        }
    }

    private SceneNode getGroup(HashMap<Double, SceneNode> hashMap, HashMap<String, SceneNode> hashMap2, Field field, int n) {
        double d = field.getRowValue(n);
        SceneNode sceneNode = hashMap.get(d);
        return sceneNode == null ? hashMap2.get(this.toCat(field, d)) : sceneNode;
    }

    private String toCat(Field field, double d) {
        int n = (int)Math.round(d);
        return field.categories[n];
    }

    private void populateCombinedCategories(Field field, HashMap<String, SceneNode> hashMap, HashMap<String, SceneNode> hashMap2) {
        for (String string : field.categories) {
            SceneNode sceneNode = hashMap2.get(string);
            if (sceneNode != null || (sceneNode = hashMap.get(string)) == null) continue;
            hashMap2.put(string, sceneNode);
        }
    }

    private HashMap<String, SceneNode> mapToCategory(Field field, HashMap<Double, SceneNode> hashMap) {
        HashMap<String, SceneNode> hashMap2 = new HashMap<String, SceneNode>();
        for (Double d : hashMap.keySet()) {
            int n = (int)Math.round(d);
            hashMap2.put(field.categories[n], hashMap.get(d));
        }
        return hashMap2;
    }
}

