/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.configuration.ContrastParameters;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.internal.accessibility.ContrastTool;
import com.ibm.vis.internal.accessibility.DarkBackgroundContrastTool;
import com.ibm.vis.internal.accessibility.LayoutStyleInfo;
import com.ibm.vis.internal.accessibility.LightBackgroundContrastTool;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.DerivedGroupSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FacetFieldSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.SizeSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TargetedStyleSpec;
import com.ibm.vis.spec.internal.TitleSpec;
import com.ibm.vis.spec.internal.TooltipSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ContrastConverter {
    private static final String CALLOUT = "callout";
    private ContrastTool hcTool;
    private ContrastParameters params;
    private boolean leaderLinesOk;
    private DataSpec[] dataSpecs;
    private Map<String, Boolean> fieldMap;
    private double minFontSize;

    public ContrastConverter(ContrastParameters contrastParameters, double d) {
        this.minFontSize = d;
        this.setParameters(contrastParameters);
    }

    public void setParameters(ContrastParameters contrastParameters) {
        this.params = contrastParameters.copy();
        if (this.params.getDefaultFontSize() < this.minFontSize) {
            this.params.setDefaultFontSize(this.minFontSize);
        }
        this.hcTool = this.makeContrastTool();
    }

    protected ContrastTool makeContrastTool() {
        String string = this.params.getBackgroundColor();
        double d = ContrastTool.getLuminance(ColorUtil.createColorFromString(string).getRGBA());
        String string2 = this.params.getTextColor();
        double d2 = ContrastTool.getLuminance(ColorUtil.createColorFromString(string2).getRGBA());
        if (d > 0.2446178304415757) {
            if (d / d2 < ContrastTool.contrastThreshold) {
                string2 = "black";
                d2 = 0.05;
            }
            return new LightBackgroundContrastTool(this.params.getDefaultFontSize(), this.params.getFontMagnification(), this.params.isBoldText(), string2, d2, string, d);
        }
        if (d2 / d < ContrastTool.contrastThreshold) {
            string2 = "white";
            d2 = 1.05;
        }
        return new DarkBackgroundContrastTool(this.params.getDefaultFontSize(), this.params.getFontMagnification(), this.params.isBoldText(), string2, d2, string, d);
    }

    private boolean isCategorical(FieldValueRefSpec fieldValueRefSpec) {
        Boolean bl;
        if (fieldValueRefSpec == null || fieldValueRefSpec.$ref == null) {
            return false;
        }
        if (this.fieldMap == null) {
            this.fieldMap = this.makeFieldMap();
        }
        return (bl = this.fieldMap.get(fieldValueRefSpec.$ref)) == null ? false : bl;
    }

    private Map<String, Boolean> makeFieldMap() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (this.dataSpecs != null) {
            for (DataSpec dataSpec : this.dataSpecs) {
                if (dataSpec.fields != null) {
                    for (MappedJSONObject mappedJSONObject : dataSpec.fields) {
                        boolean bl = ((FieldSpec)mappedJSONObject).categories != null || "categorical".equals(((FieldSpec)mappedJSONObject).unit);
                        hashMap.put(((FieldSpec)mappedJSONObject).id, bl);
                    }
                }
                if (dataSpec.group == null) continue;
                for (MappedJSONObject mappedJSONObject : dataSpec.group) {
                    if (((DerivedGroupSpec)mappedJSONObject).output == null) continue;
                    hashMap.put(((DerivedGroupSpec)mappedJSONObject).output.id, true);
                }
            }
        }
        return hashMap;
    }

    protected void expandBoundsSpec(BoundsSpec boundsSpec) {
        if (boundsSpec == null || !this.params.isMayExpandChart() || this.params.getFontMagnification() <= 1.0) {
            return;
        }
        if (boundsSpec.left == null && boundsSpec.right == null) {
            boundsSpec.width = this.expandSize(boundsSpec.width);
        }
        if (boundsSpec.top == null && boundsSpec.bottom == null) {
            boundsSpec.height = this.expandSize(boundsSpec.height);
        }
    }

    protected void expandSizeSpec(SizeSpec sizeSpec) {
        if (sizeSpec == null || !this.params.isMayExpandChart() || this.params.getFontMagnification() <= 1.0) {
            return;
        }
        sizeSpec.width = this.expandSize(sizeSpec.width);
        sizeSpec.height = this.expandSize(sizeSpec.height);
    }

    private Object expandSize(Object object) {
        return object != null && BasicFactory.isNumber(object) ? Double.valueOf(((Number)object).doubleValue() * this.params.getFontMagnification()) : object;
    }

    private void convertGrammars(GrammarSpec[] grammarSpecArray) {
        if (grammarSpecArray == null) {
            return;
        }
        List<String> list = this.getFacetTargets(grammarSpecArray);
        for (GrammarSpec grammarSpec : grammarSpecArray) {
            this.convertGrammar(grammarSpec, list);
        }
    }

    private List<String> getFacetTargets(GrammarSpec[] grammarSpecArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GrammarSpec grammarSpec : grammarSpecArray) {
            this.addFacetTargets(grammarSpec, arrayList);
        }
        return arrayList;
    }

    protected void addFacetTargets(GrammarSpec grammarSpec, List<String> list) {
        if (grammarSpec.facet == null || grammarSpec.facet.targetElement == null || grammarSpec.facet.targetElement.$ref == null) {
            return;
        }
        list.add(grammarSpec.facet.targetElement.$ref);
    }

    private void convertGrammar(GrammarSpec grammarSpec, List<String> list) {
        MappedJSONObject[] mappedJSONObjectArray;
        if (grammarSpec.coordinates != null && grammarSpec.coordinates.dimensions != null) {
            mappedJSONObjectArray = grammarSpec.coordinates.dimensions;
            for (DimensionSpec mappedJSONObject : mappedJSONObjectArray) {
                this.convertDimensionAxes(mappedJSONObject.axis);
            }
        }
        boolean bl = this.leaderLinesOk = !this.isPolar(grammarSpec.coordinates);
        if (grammarSpec.coordinates != null) {
            grammarSpec.coordinates.style = this.hcTool.adjustBackground(grammarSpec.coordinates.style, false);
        }
        if (grammarSpec.labelCollisionMethod == null) {
            grammarSpec.labelCollisionMethod = "full";
        }
        if ((mappedJSONObjectArray = grammarSpec.elements) != null) {
            for (MappedJSONObject mappedJSONObject : mappedJSONObjectArray) {
                this.convertElement((ElementsSpec)mappedJSONObject, list);
            }
        }
        if (grammarSpec.style != null) {
            grammarSpec.style = this.hcTool.adjustBackground(grammarSpec.style, true);
        }
        this.expandBoundsSpec(grammarSpec.bounds);
        if (grammarSpec.facet != null && grammarSpec.facet.fields != null) {
            for (MappedJSONObject mappedJSONObject : grammarSpec.facet.fields) {
                if (mappedJSONObject == null || ((FacetFieldSpec)mappedJSONObject).axis == null) continue;
                this.convertAxis(((FacetFieldSpec)mappedJSONObject).axis);
            }
        }
    }

    private boolean isPolar(CoordinatesSpec coordinatesSpec) {
        if (coordinatesSpec == null || coordinatesSpec.transforms == null) {
            return false;
        }
        for (TransformSpec transformSpec : coordinatesSpec.transforms) {
            if (!"polar".equals(transformSpec.type)) continue;
            return true;
        }
        return false;
    }

    protected void convertElement(ElementsSpec elementsSpec, List<String> list) {
        if ("text".equals(elementsSpec.type)) {
            this.convertTextElement(elementsSpec);
        } else if ("area".equals(elementsSpec.type) || "polygon".equals(elementsSpec.type)) {
            this.convertGenericElement(elementsSpec, list);
        } else if ("edge".equals(elementsSpec.type) || "path".equals(elementsSpec.type) || "line".equals(elementsSpec.type)) {
            this.convertLineElement(elementsSpec);
        } else {
            this.convertGenericElement(elementsSpec, list);
        }
        this.convertElementStyles(elementsSpec);
    }

    private void convertElementStyles(ElementsSpec elementsSpec) {
        if (elementsSpec.positioning == null) {
            return;
        }
        LayoutStyleInfo[] layoutStyleInfoArray = LayoutStyleInfo.getTargetedStyles(elementsSpec.positioning.method);
        if (layoutStyleInfoArray == null) {
            return;
        }
        TargetedStyleSpec[] targetedStyleSpecArray = new TargetedStyleSpec[layoutStyleInfoArray.length];
        for (int i = 0; i < layoutStyleInfoArray.length; ++i) {
            targetedStyleSpecArray[i] = layoutStyleInfoArray[i].getSpec(elementsSpec.styles);
            this.convertTargetedStyle(targetedStyleSpecArray[i], layoutStyleInfoArray[i]);
        }
        elementsSpec.styles = targetedStyleSpecArray;
    }

    private void convertTargetedStyle(TargetedStyleSpec targetedStyleSpec, LayoutStyleInfo layoutStyleInfo) {
        targetedStyleSpec.style = layoutStyleInfo.isTextStyle() ? this.hcTool.adjustText(targetedStyleSpec.style, true) : (layoutStyleInfo.isLineLike() ? this.hcTool.adjustColorTowardText(targetedStyleSpec.style, true) : this.hcTool.adjustElementAwayFromText(targetedStyleSpec.style));
        if (this.params.isAlwaysHaveBorders() && targetedStyleSpec.style != null) {
            targetedStyleSpec.style.outline = this.hcTool.showOutline(targetedStyleSpec.style.outline);
        }
    }

    private void convertGenericElement(ElementsSpec elementsSpec, List<String> list) {
        ElementLabelSpec[] elementLabelSpecArray;
        this.modifyForColor(elementsSpec, false);
        elementsSpec.style = list.contains(elementsSpec.id) ? this.hcTool.adjustFacetElementFillTowardBackground(elementsSpec.style) : this.hcTool.adjustElementAwayFromText(elementsSpec.style);
        if (this.params.isAlwaysHaveBorders() && elementsSpec.style != null) {
            elementsSpec.style.outline = this.hcTool.showOutline(elementsSpec.style.outline);
        }
        if ((elementLabelSpecArray = elementsSpec.label) != null) {
            for (MappedJSONObject mappedJSONObject : elementLabelSpecArray) {
                if (((ElementLabelSpec)mappedJSONObject).color != null) {
                    boolean bl = this.isCategorical(((ElementLabelSpec)mappedJSONObject).color.field);
                    this.hcTool.adjustColorAestheticTowardForeground(((ElementLabelSpec)mappedJSONObject).color, bl);
                }
                ((ElementLabelSpec)mappedJSONObject).style = this.hcTool.adjustText(((ElementLabelSpec)mappedJSONObject).style, true);
                if (((ElementLabelSpec)mappedJSONObject).lineMinSize == null) continue;
                ((ElementLabelSpec)mappedJSONObject).lineStyle = this.hcTool.adjustForegroundGuide(((ElementLabelSpec)mappedJSONObject).lineStyle, true);
            }
        }
        if (elementsSpec.styleBy != null) {
            for (MappedJSONObject mappedJSONObject : elementsSpec.styleBy) {
                if (((AestheticSpec)mappedJSONObject).field == null) continue;
                this.hcTool.adjustStyleByAestheticTowardBackground((AestheticSpec)mappedJSONObject);
            }
        }
        if (elementsSpec.styles != null) {
            for (MappedJSONObject mappedJSONObject : elementsSpec.styles) {
                ((TargetedStyleSpec)mappedJSONObject).style = this.hcTool.adjustElementAwayFromText(((TargetedStyleSpec)mappedJSONObject).style);
            }
        }
    }

    private void modifyForColor(ElementsSpec elementsSpec, boolean bl) {
        Object object;
        MappedJSONObject[] mappedJSONObjectArray;
        if (elementsSpec.label != null) {
            mappedJSONObjectArray = elementsSpec.label;
            int n = mappedJSONObjectArray.length;
            for (int i = 0; i < n; ++i) {
                object = mappedJSONObjectArray[i];
                ((ElementLabelSpec)object).style = this.hcTool.adjustColorText(((ElementLabelSpec)object).style, true);
                ((ElementLabelSpec)object).backgroundStyle = this.hcTool.adjustBackground(((ElementLabelSpec)object).backgroundStyle, false);
            }
        }
        if ((mappedJSONObjectArray = elementsSpec.color) != null && (this.params.isUseTextForColor() || this.params.isUseTooltipsForColor())) {
            ArrayList<FieldValueRefSpec> arrayList = new ArrayList<FieldValueRefSpec>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (MappedJSONObject mappedJSONObject : mappedJSONObjectArray) {
                if (((AestheticSpec)mappedJSONObject).field != null) {
                    arrayList.add(((AestheticSpec)mappedJSONObject).field);
                    hashMap.put(((AestheticSpec)mappedJSONObject).field.$ref, ((AestheticSpec)mappedJSONObject).field.$ref);
                }
                if (!this.params.isAlwaysHaveBorders() || !"both".equals(((AestheticSpec)mappedJSONObject).modifies)) continue;
                ((AestheticSpec)mappedJSONObject).modifies = null;
            }
            this.removeFields(elementsSpec.font, hashMap);
            this.removeFields(elementsSpec.dashing, hashMap);
            this.removeFields(elementsSpec.size, hashMap);
            this.removeFields(elementsSpec.symbol, hashMap);
            if (!hashMap.isEmpty() && this.params.isUseTextForColor()) {
                object = new ArrayList();
                for (FieldValueRefSpec fieldValueRefSpec : arrayList) {
                    if (hashMap.get(fieldValueRefSpec.$ref) == null) continue;
                    object.add(fieldValueRefSpec);
                }
                this.addLabelAesthetic(elementsSpec, (List<FieldValueRefSpec>)object);
            }
            if (this.params.isUseTooltipsForColor()) {
                this.addTooltips(elementsSpec, arrayList);
            }
            if (elementsSpec.label != null || bl) {
                for (MappedJSONObject mappedJSONObject : mappedJSONObjectArray) {
                    if (((AestheticSpec)mappedJSONObject).field == null) continue;
                    boolean bl2 = this.isCategorical(((AestheticSpec)mappedJSONObject).field);
                    if (bl) {
                        this.hcTool.adjustColorAestheticTowardForeground((AestheticSpec)mappedJSONObject, bl2);
                        continue;
                    }
                    this.hcTool.adjustColorAestheticTowardBackground((AestheticSpec)mappedJSONObject, bl2);
                }
            }
        }
    }

    private void removeFields(AestheticSpec[] aestheticSpecArray, Map<String, String> map) {
        if (aestheticSpecArray == null) {
            return;
        }
        for (AestheticSpec aestheticSpec : aestheticSpecArray) {
            if (aestheticSpec.field == null || aestheticSpec.field.$ref == null) continue;
            map.remove(aestheticSpec.field.$ref);
        }
    }

    protected void convertLineElement(ElementsSpec elementsSpec) {
        this.modifyForColor(elementsSpec, true);
        ElementLabelSpec[] elementLabelSpecArray = elementsSpec.label;
        elementsSpec.style = this.hcTool.adjustColorTowardText(elementsSpec.style, true);
        if (elementLabelSpecArray != null) {
            for (MappedJSONObject mappedJSONObject : elementLabelSpecArray) {
                if (((ElementLabelSpec)mappedJSONObject).color != null) {
                    this.hcTool.adjustColorAestheticTowardForeground(((ElementLabelSpec)mappedJSONObject).color, true);
                }
                ((ElementLabelSpec)mappedJSONObject).style = this.hcTool.adjustColorTowardText(((ElementLabelSpec)mappedJSONObject).style, true);
            }
        }
        if (elementsSpec.styleBy != null) {
            for (MappedJSONObject mappedJSONObject : elementsSpec.styleBy) {
                if (((AestheticSpec)mappedJSONObject).field == null) continue;
                this.hcTool.adjustStyleByAestheticTowardForeground((AestheticSpec)mappedJSONObject);
            }
        }
    }

    protected void addLabelAesthetic(ElementsSpec elementsSpec, List<FieldValueRefSpec> list) {
        if (list.isEmpty()) {
            return;
        }
        if (elementsSpec.label == null || elementsSpec.label[0].content == null) {
            ElementLabelSpec elementLabelSpec = new ElementLabelSpec();
            ArrayList arrayList = new ArrayList();
            elementLabelSpec.content = this.addFieldValues(list, arrayList, true);
            elementLabelSpec.style = new StyleSpec();
            this.hcTool.updateFont(elementLabelSpec.style);
            if (this.leaderLinesOk) {
                elementLabelSpec.style.location = CALLOUT;
                elementLabelSpec.lineStyle = new StyleSpec();
                elementLabelSpec.lineStyle.fill = this.hcTool.getForegroundColor();
                elementLabelSpec.lineStyle.stroke = new StrokeSpec();
                elementLabelSpec.lineStyle.stroke.width = 2;
            }
            elementsSpec.label = new ElementLabelSpec[]{elementLabelSpec};
        } else {
            this.addColorFieldsIfNeeded(elementsSpec, list);
            for (ElementLabelSpec elementLabelSpec : elementsSpec.label) {
                elementLabelSpec.style = this.hcTool.adjustText(elementLabelSpec.style, true);
            }
        }
    }

    protected void addTooltips(ElementsSpec elementsSpec, List<FieldValueRefSpec> list) {
        if (list.isEmpty() || elementsSpec.tooltip != null) {
            return;
        }
        TooltipSpec tooltipSpec = new TooltipSpec();
        ArrayList arrayList = new ArrayList();
        tooltipSpec.content = this.addFieldValues(list, arrayList, true);
        elementsSpec.tooltip = new TooltipSpec[]{tooltipSpec};
    }

    private void addColorFieldsIfNeeded(ElementsSpec elementsSpec, List<FieldValueRefSpec> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ElementLabelSpec elementLabelSpec = elementsSpec.label[0];
        for (Object object : elementLabelSpec.content) {
            arrayList.add(object);
            if (!(object instanceof FieldValueRefSpec)) continue;
            String string = ((FieldValueRefSpec)object).$ref;
            hashMap.put(string, string);
        }
        ArrayList arrayList2 = new ArrayList();
        for (FieldValueRefSpec fieldValueRefSpec : list) {
            if (hashMap.get(fieldValueRefSpec.$ref) != null) continue;
            arrayList2.add(fieldValueRefSpec);
            hashMap.put(fieldValueRefSpec.$ref, fieldValueRefSpec.$ref);
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        elementLabelSpec.content = this.addFieldValues(arrayList2, arrayList, false);
    }

    protected Object[] addFieldValues(List<FieldValueRefSpec> list, ArrayList arrayList, boolean bl) {
        for (FieldValueRefSpec fieldValueRefSpec : list) {
            if (!bl) {
                bl = false;
                arrayList.add(", ");
            }
            arrayList.add(fieldValueRefSpec);
        }
        Object[] objectArray = arrayList.toArray();
        return objectArray;
    }

    private void convertTextElement(ElementsSpec elementsSpec) {
        if (elementsSpec.positioning == null) {
            elementsSpec.style = this.hcTool.adjustColorText(elementsSpec.style, true);
            elementsSpec.textBackgroundStyle = this.hcTool.adjustElementAwayFromText(elementsSpec.textBackgroundStyle);
        }
        elementsSpec.style = this.hcTool.adjustText(elementsSpec.style, true);
        if (elementsSpec.label != null) {
            for (MappedJSONObject mappedJSONObject : elementsSpec.label) {
                ((ElementLabelSpec)mappedJSONObject).backgroundStyle = this.hcTool.adjustElementAwayFromText(((ElementLabelSpec)mappedJSONObject).backgroundStyle);
                ((ElementLabelSpec)mappedJSONObject).style = this.hcTool.adjustText(((ElementLabelSpec)mappedJSONObject).style, true);
            }
        }
        if (elementsSpec.color != null || elementsSpec.styleBy != null) {
            if (elementsSpec.color != null) {
                for (MappedJSONObject mappedJSONObject : elementsSpec.color) {
                    boolean bl = this.isCategorical(((AestheticSpec)mappedJSONObject).field);
                    this.hcTool.adjustColorAestheticTowardForeground((AestheticSpec)mappedJSONObject, bl);
                }
            }
            if (elementsSpec.styleBy != null) {
                for (MappedJSONObject mappedJSONObject : elementsSpec.styleBy) {
                    if (((AestheticSpec)mappedJSONObject).field == null) continue;
                    this.hcTool.adjustStyleByAestheticTowardForeground((AestheticSpec)mappedJSONObject);
                }
            }
        }
    }

    private void convertDimensionAxes(Object object) {
        if (object == null) {
            return;
        }
        if (BasicFactory.isArray(object)) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                this.convertAxis((AxisSpec)object2);
            }
        } else {
            this.convertAxis((AxisSpec)object);
        }
    }

    protected void convertAxis(AxisSpec axisSpec) {
        axisSpec.gridBand = null;
        axisSpec.lineStyle = this.hcTool.adjustForegroundGuide(axisSpec.lineStyle, true);
        axisSpec.gridStyle = this.hcTool.adjustForegroundGuide(axisSpec.gridStyle, false);
        axisSpec.markStyle = this.hcTool.adjustMarkStyle(axisSpec.markStyle);
        axisSpec.boxStyle = this.hcTool.adjustBackground(axisSpec.boxStyle, false);
        axisSpec.titleStyle = this.hcTool.adjustText(axisSpec.titleStyle, true);
        axisSpec.tickStyle = this.hcTool.adjustTickStyle(axisSpec.tickStyle);
    }

    private void convertLegends(LegendSpec[] legendSpecArray) {
        if (legendSpecArray == null) {
            return;
        }
        for (LegendSpec legendSpec : legendSpecArray) {
            this.convertLegend(legendSpec);
        }
    }

    protected void convertLegend(LegendSpec legendSpec) {
        legendSpec.tickStyle = this.hcTool.adjustText(legendSpec.tickStyle, true);
        legendSpec.boundsStyle = this.hcTool.adjustBackground(legendSpec.boundsStyle, false);
        legendSpec.titleStyle = this.hcTool.adjustColorText(legendSpec.titleStyle, true);
        if (legendSpec.tickStyle != null && legendSpec.labelStyle == null) {
            legendSpec.labelStyle = legendSpec.tickStyle;
            legendSpec.tickStyle = null;
        } else {
            legendSpec.labelStyle = this.hcTool.adjustText(legendSpec.labelStyle, true);
        }
        if (legendSpec.location != null && legendSpec.location instanceof BoundsSpec) {
            this.expandBoundsSpec((BoundsSpec)legendSpec.location);
        }
        legendSpec.itemBoxStyle = this.hcTool.adjustBackground(legendSpec.itemBoxStyle, false);
    }

    private void convertTitles(TitleSpec[] titleSpecArray) {
        if (titleSpecArray == null) {
            return;
        }
        for (TitleSpec titleSpec : titleSpecArray) {
            this.convertTitle(titleSpec);
        }
    }

    private void convertTitle(TitleSpec titleSpec) {
        titleSpec.backgroundStyle = this.hcTool.adjustBackground(titleSpec.backgroundStyle, false);
        titleSpec.style = this.hcTool.adjustColorText(titleSpec.style, true);
    }

    public void convert(VisJSONSpec visJSONSpec) {
        this.fieldMap = null;
        this.convertTitles(visJSONSpec.titles);
        this.convertLegends(visJSONSpec.legends);
        this.dataSpecs = visJSONSpec.data;
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.fill = "white";
        visJSONSpec.style = this.hcTool.adjustBackground(styleSpec, false);
        this.expandSizeSpec(visJSONSpec.size);
        this.convertGrammars(visJSONSpec.grammar);
        this.dataSpecs = null;
    }

    public ContrastParameters getContrastParameters() {
        return this.params.copy();
    }
}

