/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ColorOffsetSpec;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class ContrastTool {
    protected static final double BLACK_LUMINANCE = 0.05;
    protected static final double WHITE_LUMINANCE = 1.05;
    protected static final double YELLOW_LUMINANCE = 0.9778;
    private static final double divRGB = 0.00392156862745098;
    private static final double threshold = 10.0164;
    private static final double lowConstant = 3.035269835488375E-4;
    private static final double highDiv = 0.9478672985781991;
    protected static double contrastThreshold = 4.75;
    private static final String BOLD = "bold";
    protected final double foregroundLumaniance;
    protected final double backgroundLumaniance;
    protected final String foregroundColor;
    protected final String backgroundColor;
    protected String defaultFillColor;
    protected String nearBackgroundFillColor;
    protected boolean isLightBackground;
    private final double fontMagnification;
    private final int magnifiedDefaultFontSize;
    protected final boolean boldText;

    public abstract StyleSpec adjustBackground(StyleSpec var1, boolean var2);

    protected abstract double getContrastRatioWithBackground(double[] var1);

    protected abstract double getContrastRatioWithForeground(double[] var1);

    protected abstract MappingSpec[] getShiftedDefaultMapping(boolean var1);

    protected ContrastTool(double d, double d2, boolean bl, String string, double d3, String string2, double d4) {
        double d5 = d2 < 1.0 ? 1.0 : d2;
        this.fontMagnification = d5 > 2.0 ? 2.0 : d5;
        this.magnifiedDefaultFontSize = (int)Math.ceil(d * d2);
        this.foregroundColor = string;
        this.foregroundLumaniance = d3;
        this.backgroundColor = string2;
        this.backgroundLumaniance = d4;
        this.boldText = bl;
    }

    public StyleSpec adjustForegroundGuide(StyleSpec styleSpec, boolean bl) {
        if (styleSpec == null && !bl || this.isTransparentObject(styleSpec, bl)) {
            return styleSpec;
        }
        StyleSpec styleSpec2 = styleSpec == null ? new StyleSpec() : styleSpec;
        styleSpec2.fill = this.foregroundColor;
        return styleSpec2;
    }

    public StyleSpec adjustMarkStyle(StyleSpec styleSpec) {
        return this.isEmptyStyle(styleSpec) ? styleSpec : this.adjustForegroundGuide(styleSpec, true);
    }

    public StyleSpec adjustTickStyle(StyleSpec styleSpec) {
        return this.isEmptyStyle(styleSpec) ? styleSpec : this.adjustText(styleSpec, true);
    }

    private boolean isEmptyStyle(StyleSpec styleSpec) {
        return styleSpec != null && styleSpec.fill == null && styleSpec.stroke == null && styleSpec.width == null && styleSpec.font == null && styleSpec.size == null && styleSpec.height == null && styleSpec.outline == null && styleSpec.symbol == null && styleSpec.padding == null && styleSpec.accessibility == null && styleSpec.snap == null && styleSpec.align == null && styleSpec.alignEdge == null && styleSpec.angle == null && styleSpec.cornerRadius == null && styleSpec.effect == null && styleSpec.endArrow == null && styleSpec.image == null && styleSpec.location == null && styleSpec.outlineMethod == null && styleSpec.startArrow == null && styleSpec.valign == null;
    }

    public StyleSpec adjustColorText(StyleSpec styleSpec, boolean bl) {
        StyleSpec styleSpec2;
        if (this.isTransparentObject(styleSpec, bl)) {
            return styleSpec;
        }
        StyleSpec styleSpec3 = styleSpec2 = styleSpec == null ? new StyleSpec() : styleSpec;
        if (styleSpec2.fill == null) {
            styleSpec2.fill = this.foregroundColor;
        } else {
            Object object = styleSpec2.fill;
            FillSpec fillSpec = this.getFillSpec(object);
            if (fillSpec == null) {
                ColorNew colorNew = this.getColor(object);
                styleSpec2.fill = this.shiftColorForward(colorNew);
            } else {
                styleSpec2.fill = this.shiftFillTowardForeground(fillSpec);
            }
        }
        this.updateFont(styleSpec2);
        return styleSpec2;
    }

    public StyleSpec adjustText(StyleSpec styleSpec, boolean bl) {
        if (styleSpec == null && !bl) {
            return null;
        }
        if (this.isTransparentObject(styleSpec, bl) || styleSpec != null && styleSpec.fill == null && !bl) {
            return styleSpec;
        }
        StyleSpec styleSpec2 = styleSpec == null ? new StyleSpec() : styleSpec;
        styleSpec2.fill = this.foregroundColor;
        styleSpec2.effect = null;
        this.updateFont(styleSpec2);
        return styleSpec2;
    }

    private Object[] getShiftedDefaultPalette(boolean bl) {
        ColorNew[] colorNewArray = ColorUtil.getDefaultColors();
        Object[] objectArray = new Object[colorNewArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ColorNew colorNew = colorNewArray[i];
            colorNew = bl ? this.shiftTowardForeground(colorNew) : this.shiftTowardBackground(colorNew);
            objectArray[i] = this.convertToColorSpec(colorNew);
        }
        return objectArray;
    }

    protected static double getLuminance(double[] dArray) {
        return 0.2126 * ContrastTool.lumValue(dArray[0]) + 0.7152 * ContrastTool.lumValue(dArray[1]) + 0.0722 * ContrastTool.lumValue(dArray[2]) + 0.05;
    }

    private static double lumValue(double d) {
        if (d < 10.0164) {
            return d * 3.035269835488375E-4;
        }
        double d2 = (d * 0.00392156862745098 + 0.055) * 0.9478672985781991;
        return Math.pow(d2, 2.4);
    }

    private Object shiftColorForward(ColorNew colorNew) {
        if (this.isWhiteGrayOrBlack(colorNew)) {
            return this.foregroundColor;
        }
        colorNew = this.shiftTowardForeground(colorNew);
        return this.convertToColorSpec(colorNew);
    }

    private boolean isWhiteGrayOrBlack(ColorNew colorNew) {
        double[] dArray = colorNew.getRGBA();
        return dArray[0] == dArray[1] && dArray[0] == dArray[2];
    }

    public StyleSpec adjustFacetElementFillTowardBackground(StyleSpec styleSpec) {
        if (this.isTransparentObject(styleSpec, true)) {
            this.updateFont(styleSpec);
            this.replaceOutline(styleSpec, this.foregroundColor);
            return styleSpec;
        }
        if (styleSpec == null) {
            StyleSpec styleSpec2 = new StyleSpec();
            styleSpec2.fill = this.getFacetElementDefaultColor();
            return styleSpec2;
        }
        Object object = styleSpec.fill;
        FillSpec fillSpec = this.getFillSpec(object);
        if (styleSpec.fill == null) {
            styleSpec.fill = this.getFacetElementDefaultColor();
        } else if (fillSpec == null) {
            ColorNew colorNew = this.getColor(object);
            if (this.isWhiteGrayOrBlack(colorNew)) {
                styleSpec.fill = this.getFacetElementDefaultColor();
            } else {
                colorNew = this.shiftBack(colorNew, 7.0);
                styleSpec.fill = this.convertToColorSpec(colorNew);
            }
        } else {
            styleSpec.fill = this.shiftFillTowardBackground(fillSpec, 7.0);
        }
        this.updateFont(styleSpec);
        this.replaceOutline(styleSpec, this.foregroundColor);
        return styleSpec;
    }

    protected final String getFacetElementDefaultColor() {
        return this.nearBackgroundFillColor;
    }

    public StyleSpec adjustElementAwayFromText(StyleSpec styleSpec) {
        if (this.isTransparentObject(styleSpec, true)) {
            this.updateFont(styleSpec);
            this.replaceOutline(styleSpec, this.foregroundColor);
            return styleSpec;
        }
        if (styleSpec == null) {
            StyleSpec styleSpec2 = new StyleSpec();
            styleSpec2.fill = this.defaultFillColor;
            return styleSpec2;
        }
        Object object = styleSpec.fill;
        FillSpec fillSpec = this.getFillSpec(object);
        if (styleSpec.fill == null) {
            styleSpec.fill = this.defaultFillColor;
        } else if (fillSpec == null) {
            ColorNew colorNew = this.getColor(object);
            if (this.isWhiteGrayOrBlack(colorNew)) {
                styleSpec.fill = this.defaultFillColor;
            } else {
                colorNew = this.shiftTowardBackground(colorNew);
                styleSpec.fill = this.convertToColorSpec(colorNew);
            }
        } else {
            styleSpec.fill = this.shiftFillTowardBackground(fillSpec, contrastThreshold);
        }
        this.updateFont(styleSpec);
        this.replaceOutline(styleSpec, this.foregroundColor);
        return styleSpec;
    }

    protected void replaceOutline(StyleSpec styleSpec, Object object) {
        if (styleSpec != null && styleSpec.outline != null && !this.isTransparentColor(styleSpec.outline, false)) {
            styleSpec.outline = object;
        }
    }

    public StyleSpec adjustColorTowardText(StyleSpec styleSpec, boolean bl) {
        StyleSpec styleSpec2;
        if (this.isTransparentObject(styleSpec, bl)) {
            return styleSpec;
        }
        StyleSpec styleSpec3 = styleSpec2 = styleSpec == null ? new StyleSpec() : styleSpec;
        if (styleSpec2.fill == null) {
            styleSpec2.fill = this.foregroundColor;
            return styleSpec2;
        }
        Object object = styleSpec.fill;
        FillSpec fillSpec = this.getFillSpec(object);
        if (fillSpec == null) {
            ColorNew colorNew = this.getColor(object);
            styleSpec.fill = this.shiftColorForward(colorNew);
        } else {
            styleSpec.fill = this.shiftFillTowardForeground(fillSpec);
        }
        this.updateFont(styleSpec);
        return styleSpec;
    }

    public void updateFont(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return;
        }
        FontSpec fontSpec = styleSpec.font;
        if (fontSpec == null) {
            styleSpec.font = this.makeFontSpec();
            return;
        }
        if (fontSpec.size == null) {
            fontSpec.size = this.magnifiedDefaultFontSize;
        } else {
            double d = this.magnifiedDefaultFontSize;
            if (BasicFactory.isString(fontSpec.size)) {
                Double d2 = UnitConverter.convertLength(fontSpec.size, d, d);
                fontSpec.size = (int)Math.ceil(d2 * this.fontMagnification);
            } else if (BasicFactory.isNumber(fontSpec.size)) {
                fontSpec.size = (int)Math.ceil(((Number)fontSpec.size).doubleValue() * this.fontMagnification);
            }
        }
        if (this.boldText) {
            fontSpec.weight = BOLD;
        }
    }

    protected boolean isTransparentObject(StyleSpec styleSpec, boolean bl) {
        if (styleSpec == null && !bl) {
            return true;
        }
        return styleSpec == null ? false : this.isTransparentColor(styleSpec.fill, bl);
    }

    ColorSpec convertToColorSpec(ColorNew colorNew) {
        if (colorNew == null) {
            return null;
        }
        ColorSpec colorSpec = new ColorSpec();
        double[] dArray = colorNew.getRGBA();
        colorSpec.r = dArray[0];
        colorSpec.g = dArray[1];
        colorSpec.b = dArray[2];
        colorSpec.a = dArray[3];
        return colorSpec;
    }

    private double shift(double d, boolean bl) {
        if (bl) {
            double d2 = (255.0 - d) / 5.0;
            return d + d2;
        }
        return d * 0.8;
    }

    protected StyleSpec setForeAndBackground(StyleSpec styleSpec) {
        StyleSpec styleSpec2 = styleSpec == null ? new StyleSpec() : styleSpec;
        styleSpec2.fill = this.backgroundColor;
        this.replaceOutline(styleSpec2, this.foregroundColor);
        return styleSpec2;
    }

    protected boolean isTransparentColor(Object object, boolean bl) {
        ColorSpec colorSpec;
        if (object == null) {
            return !bl;
        }
        if ("transparent".equals(object)) {
            return true;
        }
        ColorSpec colorSpec2 = colorSpec = object instanceof ColorSpec ? (ColorSpec)object : null;
        if (colorSpec != null) {
            if (colorSpec.a != null && colorSpec.a.doubleValue() == 0.0) {
                return true;
            }
            ColorNew colorNew = ColorUtil.createColorFromColorSpec(colorSpec);
            return colorNew.getRGBA()[3] == 0.0;
        }
        return false;
    }

    protected final FillSpec getFillSpec(Object object) {
        return object instanceof FillSpec ? (FillSpec)object : null;
    }

    ColorNew getColor(Object object) {
        if (this.getFillSpec(object) != null) {
            return null;
        }
        return ColorUtil.toCanonicalColor(object);
    }

    protected final boolean isAlphaZero(double[] dArray) {
        return dArray[3] < 0.01;
    }

    protected FillSpec shiftFillTowardBackground(FillSpec fillSpec, double d) {
        ColorOffsetSpec[] colorOffsetSpecArray;
        for (ColorOffsetSpec colorOffsetSpec : colorOffsetSpecArray = fillSpec.colors) {
            if (this.isShiftingColor(colorOffsetSpec.color)) continue;
            ColorNew colorNew = this.getColor(colorOffsetSpec.color);
            colorNew = this.shiftBack(colorNew, d);
            colorOffsetSpec.color = this.convertToColorSpec(colorNew);
        }
        return fillSpec;
    }

    private boolean isShiftingColor(Object object) {
        if (object instanceof ColorSpec) {
            ColorSpec colorSpec = (ColorSpec)object;
            if (colorSpec.l != null || colorSpec.v != null) {
                return true;
            }
        }
        return false;
    }

    protected FillSpec shiftFillTowardForeground(FillSpec fillSpec) {
        ColorOffsetSpec[] colorOffsetSpecArray;
        for (ColorOffsetSpec colorOffsetSpec : colorOffsetSpecArray = fillSpec.colors) {
            ColorNew colorNew = this.getColor(colorOffsetSpec.color);
            colorNew = this.shiftTowardForeground(colorNew);
            colorOffsetSpec.color = this.convertToColorSpec(colorNew);
        }
        return fillSpec;
    }

    protected ColorNew shiftTowardBackground(ColorNew colorNew) {
        return this.shiftBack(colorNew, contrastThreshold);
    }

    protected ColorNew shiftBack(ColorNew colorNew, double d) {
        if (colorNew == null) {
            return colorNew;
        }
        double[] dArray = colorNew.getRGBA();
        double d2 = this.getContrastRatioWithForeground(dArray);
        if (!this.isLightBackground) {
            dArray[3] = this.shiftAlpha(dArray[3]);
        }
        for (int i = 0; i < 8 && d2 < d; ++i) {
            dArray[0] = this.shift(dArray[0], this.isLightBackground);
            dArray[1] = this.shift(dArray[1], this.isLightBackground);
            dArray[2] = this.shift(dArray[2], this.isLightBackground);
            d2 = this.getContrastRatioWithForeground(dArray);
        }
        return new ColorNew(this.round(dArray[0]), this.round(dArray[1]), this.round(dArray[2]), dArray[3]);
    }

    private int round(double d) {
        int n = (int)Math.round(d);
        return n > 255 ? 255 : n;
    }

    protected double shiftAlpha(double d) {
        if (d > 0.0 && d < 1.0) {
            d += (1.0 - d) / 2.0;
        }
        return d;
    }

    protected ColorNew shiftTowardForeground(ColorNew colorNew) {
        if (colorNew == null) {
            return colorNew;
        }
        double[] dArray = colorNew.getRGBA();
        double d = this.getContrastRatioWithBackground(dArray);
        dArray[3] = this.shiftAlpha(dArray[3]);
        for (int i = 0; i < 8 && d < contrastThreshold; ++i) {
            dArray[0] = this.shift(dArray[0], !this.isLightBackground);
            dArray[1] = this.shift(dArray[1], !this.isLightBackground);
            dArray[2] = this.shift(dArray[2], !this.isLightBackground);
            d = this.getContrastRatioWithBackground(dArray);
        }
        return new ColorNew(this.round(dArray[0]), this.round(dArray[1]), this.round(dArray[2]), dArray[3]);
    }

    public AestheticSpec adjustColorAestheticTowardBackground(AestheticSpec aestheticSpec, boolean bl) {
        MappingSpec[] mappingSpecArray;
        Object[] objectArray = aestheticSpec.palette;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ColorNew colorNew = this.getColor(objectArray[i]);
                colorNew = this.shiftTowardBackground(colorNew);
                objectArray[i] = this.convertToColorSpec(colorNew);
            }
        }
        if ((mappingSpecArray = aestheticSpec.mapping) != null) {
            boolean bl2 = bl && objectArray == null;
            boolean bl3 = false;
            for (MappingSpec mappingSpec : mappingSpecArray) {
                if (bl2 && mappingSpec.atLabel != null) {
                    bl3 = true;
                }
                ColorNew colorNew = this.getColor(mappingSpec.color);
                colorNew = this.shiftTowardBackground(colorNew);
                mappingSpec.color = this.convertToColorSpec(colorNew);
            }
            if (bl3) {
                aestheticSpec.palette = this.getShiftedDefaultPalette(false);
            }
        }
        if (objectArray == null && mappingSpecArray == null) {
            if (bl) {
                aestheticSpec.palette = this.getShiftedDefaultPalette(false);
            } else {
                aestheticSpec.mapping = this.getShiftedDefaultMapping(false);
            }
        }
        return aestheticSpec;
    }

    public AestheticSpec adjustColorAestheticTowardForeground(AestheticSpec aestheticSpec, boolean bl) {
        MappingSpec[] mappingSpecArray;
        Object[] objectArray = aestheticSpec.palette;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ColorNew colorNew = this.getColor(objectArray[i]);
                colorNew = this.shiftTowardForeground(colorNew);
                objectArray[i] = this.convertToColorSpec(colorNew);
            }
        }
        if ((mappingSpecArray = aestheticSpec.mapping) != null) {
            boolean bl2 = bl && objectArray == null;
            boolean bl3 = false;
            for (MappingSpec mappingSpec : mappingSpecArray) {
                if (bl2 && mappingSpec.atLabel != null) {
                    bl3 = true;
                }
                ColorNew colorNew = this.getColor(mappingSpec.color);
                colorNew = this.shiftTowardForeground(colorNew);
                mappingSpec.color = this.convertToColorSpec(colorNew);
            }
            if (bl3) {
                aestheticSpec.palette = this.getShiftedDefaultPalette(true);
            }
        }
        if (objectArray == null && mappingSpecArray == null) {
            if (bl) {
                aestheticSpec.palette = this.getShiftedDefaultPalette(true);
            } else {
                aestheticSpec.mapping = this.getShiftedDefaultMapping(true);
            }
        }
        return aestheticSpec;
    }

    private FontSpec makeFontSpec() {
        FontSpec fontSpec = new FontSpec();
        fontSpec.size = this.magnifiedDefaultFontSize;
        if (this.boldText) {
            fontSpec.weight = BOLD;
        }
        return fontSpec;
    }

    public void adjustStyleByAestheticTowardBackground(AestheticSpec aestheticSpec) {
        MappingSpec[] mappingSpecArray;
        Object[] objectArray = aestheticSpec.palette;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.adjustElementAwayFromText((StyleSpec)objectArray[i]);
            }
        }
        if ((mappingSpecArray = aestheticSpec.mapping) != null) {
            for (MappingSpec mappingSpec : mappingSpecArray) {
                mappingSpec.style = this.adjustElementAwayFromText(mappingSpec.style);
            }
        }
    }

    public void adjustStyleByAestheticTowardForeground(AestheticSpec aestheticSpec) {
        MappingSpec[] mappingSpecArray;
        Object[] objectArray = aestheticSpec.palette;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.adjustLinearElementStyleByTowardForeground((StyleSpec)objectArray[i]);
            }
        }
        if ((mappingSpecArray = aestheticSpec.mapping) != null) {
            for (MappingSpec mappingSpec : mappingSpecArray) {
                mappingSpec.style = this.adjustLinearElementStyleByTowardForeground(mappingSpec.style);
            }
        }
    }

    private StyleSpec adjustLinearElementStyleByTowardForeground(StyleSpec styleSpec) {
        if (this.isTransparentObject(styleSpec, true) || styleSpec == null || styleSpec.fill == null) {
            return styleSpec;
        }
        Object object = styleSpec.fill;
        FillSpec fillSpec = this.getFillSpec(object);
        if (fillSpec == null) {
            ColorNew colorNew = this.getColor(object);
            styleSpec.fill = this.shiftColorForward(colorNew);
        } else {
            styleSpec.fill = this.shiftFillTowardForeground(fillSpec);
        }
        return styleSpec;
    }

    public Object showOutline(Object object) {
        if (object == null) {
            return this.foregroundColor;
        }
        ColorNew colorNew = this.getColor(object);
        return this.shiftColorForward(colorNew);
    }

    protected MappingSpec[] makeDefaultMappings(ColorSpec[] colorSpecArray) {
        MappingSpec[] mappingSpecArray = new MappingSpec[colorSpecArray.length];
        double d = 100.0 / (double)(colorSpecArray.length - 1);
        for (int i = 0; i < colorSpecArray.length; ++i) {
            MappingSpec mappingSpec = new MappingSpec();
            mappingSpec.color = colorSpecArray[i];
            Number number = MathUtil.r3(d * (double)i);
            mappingSpec.at = number.toString() + "%";
            mappingSpecArray[i] = mappingSpec;
        }
        return mappingSpecArray;
    }

    public final Object getForegroundColor() {
        return this.foregroundColor;
    }
}

