/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.internal.accessibility.AccessibilityBuilder;
import com.ibm.vis.internal.accessibility.Summarizer;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CoordinateSummarizer
extends Summarizer {
    private static final String COORDINATES2 = "coordinates";
    private static final String HAS_NEGATIVE_SLOPE = "hasNegativeSlope";
    private static final String HAS_POSITIVE_SLOPE = "hasPositiveSlope";
    private static final String IS_FLAT = "isFlat";
    private static final String SLOPE_STARTS_FLAT = "slopeStartsFlat";
    private static final String SLOPE_STARTS_POSITIVE = "slopeStartsPositive";
    private static final String SLOPE_STARTS_NEGATIVE = "slopeStartsNegative";
    private static final String BECOMES_NEGATIVE = "becomesNegative";
    private static final String BECOMES_POSITIVE = "becomesPositive";
    private static final String BECOMES_FLAT = "becomesFlat";
    private Field xField;
    private Field yField;
    private double x;
    private double y;
    private final String coordinates;
    private final String comma;
    private final String type;

    public CoordinateSummarizer(PositionSpec[] positionSpecArray, SceneHelper sceneHelper, String string) {
        this.settXyAndLabel(positionSpecArray, sceneHelper);
        this.coordinates = Internationalization.getString(COORDINATES2);
        this.comma = Internationalization.getString("comma");
        this.type = string;
    }

    private void settXyAndLabel(PositionSpec[] positionSpecArray, SceneHelper sceneHelper) {
        this.y = 0.0;
        String string = "";
        FieldValueRefSpec fieldValueRefSpec = positionSpecArray[0].field;
        if (fieldValueRefSpec == null) {
            Object object = positionSpecArray[0].value;
            if (object != null && BasicFactory.isNumber(object)) {
                this.y = ((Number)object).doubleValue();
            }
        } else {
            this.yField = sceneHelper.getField(fieldValueRefSpec.$ref);
            string = this.yField.label == null ? this.yField.id : this.yField.label;
        }
        int n = positionSpecArray.length - 1;
        this.x = 0.0;
        String string2 = "";
        fieldValueRefSpec = positionSpecArray[n].field;
        if (fieldValueRefSpec == null) {
            Object object = positionSpecArray[n].value;
            if (object != null && BasicFactory.isNumber(object)) {
                this.x = ((Number)object).doubleValue();
            }
        } else {
            this.xField = sceneHelper.getField(fieldValueRefSpec.$ref);
            string2 = this.xField.label == null ? this.xField.id : this.xField.label;
        }
        this.labelName = string2 + " " + string;
    }

    @Override
    public Object getForRows(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        ArrayList<FeaturePart> arrayList = new ArrayList<FeaturePart>();
        for (int n : nArray) {
            arrayList.add(this.makeFeaturePart(n));
        }
        BasicFactory.sortList(arrayList, FeaturePartComparator.X);
        if (nArray.length == 1) {
            return ((FeaturePart)arrayList.get(0)).getId();
        }
        int[] nArray2 = new int[nArray.length - 1];
        double d = ((FeaturePart)arrayList.get(0)).getAnchor().getY();
        for (int n = 0; n < nArray2.length; ++n) {
            double d2 = ((FeaturePart)arrayList.get(n + 1)).getAnchor().getY();
            double d3 = d2 - d;
            nArray2[n] = d3 == 0.0 ? 0 : (d3 > 0.0 ? 1 : -1);
            d = d2;
        }
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int i = 0; i < nArray2.length - 1; ++i) {
            if (nArray2[i] == nArray2[i + 1]) continue;
            intPrimitiveArrayList.add(i + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.buildSlopeDescription(intPrimitiveArrayList, nArray2, arrayList, stringBuilder);
        stringBuilder.append(" ");
        this.buildCoordinates(arrayList, stringBuilder);
        return stringBuilder.toString();
    }

    private void buildCoordinates(ArrayList<FeaturePart> arrayList, StringBuilder stringBuilder) {
        stringBuilder.append(this.coordinates).append(" ");
        boolean bl = true;
        for (FeaturePart featurePart : arrayList) {
            if (!bl) {
                stringBuilder.append(this.comma);
            }
            stringBuilder.append(featurePart.getId()).append(" ");
            bl = false;
        }
    }

    private void buildSlopeDescription(IntPrimitiveArrayList intPrimitiveArrayList, int[] nArray, ArrayList<FeaturePart> arrayList, StringBuilder stringBuilder) {
        stringBuilder.append(this.type).append(" ");
        int n = intPrimitiveArrayList.size();
        if (n == 0) {
            String string = nArray[0] == 0 ? IS_FLAT : (nArray[0] > 0 ? HAS_POSITIVE_SLOPE : HAS_NEGATIVE_SLOPE);
            stringBuilder.append(Internationalization.getString(string));
            return;
        }
        String string = nArray[0] == 0 ? SLOPE_STARTS_FLAT : (nArray[0] > 0 ? SLOPE_STARTS_POSITIVE : SLOPE_STARTS_NEGATIVE);
        stringBuilder.append(Internationalization.getString(string));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.comma).append(" ");
            int n2 = intPrimitiveArrayList.get(i);
            string = nArray[n2] == 0 ? Internationalization.getString(BECOMES_FLAT) : (nArray[n2] > 0 ? Internationalization.getString(BECOMES_POSITIVE) : Internationalization.getString(BECOMES_NEGATIVE));
            string = AccessibilityBuilder.ParseLocalizationString(string, arrayList.get(n2).getId(), 1);
            if (string.contains("{1}")) {
                n2 = 2;
            }
            stringBuilder.append(string);
        }
    }

    private FeaturePart makeFeaturePart(int n) {
        String string = this.xField == null ? this.x + "" : this.xField.getFormattedValue(n);
        String string2 = this.yField == null ? this.y + "" : this.yField.getFormattedValue(n);
        String string3 = string + " " + string2;
        double d = this.xField == null ? this.x : this.xField.getRowValue(n);
        double d2 = this.yField == null ? this.x : this.yField.getRowValue(n);
        Point point = new Point(d, d2);
        return new FeaturePart(string3, point);
    }
}

