/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.accessibility.ContrastTool;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DarkBackgroundContrastTool
extends ContrastTool {
    protected DarkBackgroundContrastTool(double d, double d2, boolean bl, String string, double d3, String string2, double d4) {
        super(d, d2, bl, string, d3, string2, d4);
        this.isLightBackground = false;
        this.defaultFillColor = "#787878";
        this.nearBackgroundFillColor = "#363636";
    }

    @Override
    public StyleSpec adjustBackground(StyleSpec styleSpec, boolean bl) {
        if (this.isTransparentObject(styleSpec, bl)) {
            this.replaceOutline(styleSpec, this.foregroundColor);
            return styleSpec;
        }
        return this.setForeAndBackground(styleSpec);
    }

    @Override
    protected double getContrastRatioWithForeground(double[] dArray) {
        if (this.isAlphaZero(dArray)) {
            return 99.0;
        }
        double d = DarkBackgroundContrastTool.getLuminance(dArray);
        if (d < this.foregroundLumaniance) {
            return this.foregroundLumaniance / d;
        }
        return d / this.foregroundLumaniance;
    }

    @Override
    protected double getContrastRatioWithBackground(double[] dArray) {
        if (this.isAlphaZero(dArray)) {
            return 99.0;
        }
        return DarkBackgroundContrastTool.getLuminance(dArray) / this.backgroundLumaniance;
    }

    @Override
    protected MappingSpec[] getShiftedDefaultMapping(boolean bl) {
        ColorSpec[] colorSpecArray = new ColorSpec[11];
        for (int i = 0; i < 11; ++i) {
            ColorNew colorNew = ColorUtil.temperature((double)i * 0.1);
            colorNew = bl ? this.shiftTowardForeground(colorNew) : this.shiftTowardBackground(colorNew);
            colorSpecArray[i] = this.convertToColorSpec(colorNew);
        }
        return this.makeDefaultMappings(colorSpecArray);
    }
}

