/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.internal.accessibility.Summarizer;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FieldSummarizer
extends Summarizer {
    private static final String VALUES = "values";
    private static final String COUNT = "count";
    private static final String CATEGORICAL = "categorical";
    private final Field field;

    public FieldSummarizer(Field field) {
        this.field = field;
        this.labelName = field.label == null ? field.id : field.label;
    }

    @Override
    public Object getForRows(int[] nArray) {
        int n = nArray.length;
        if (n == 1) {
            return this.field.getFormattedValue(nArray[0]);
        }
        HashMap<String, String> hashMap = null;
        if (!this.field.isCategorical()) {
            return this.makeNumericSummary(nArray, n);
        }
        hashMap = this.makeCategoricalSummary(nArray, n);
        return hashMap;
    }

    private String makeNumericSummary(int[] nArray, int n) {
        Object object;
        Object object2 = null;
        Object object3 = null;
        for (int i = 0; i < n; ++i) {
            object = this.field.getRowValue(nArray[i]);
            if (object == null || Double.isNaN(((Number)object).doubleValue())) continue;
            if (object2 == null) {
                object2 = object;
            } else if (((Number)object2).doubleValue() < ((Number)object).doubleValue()) {
                object2 = object;
            }
            if (object3 == null) {
                object3 = object;
                continue;
            }
            if (!(((Number)object3).doubleValue() > ((Number)object).doubleValue())) continue;
            object3 = object;
        }
        if (object3 == null) {
            return Internationalization.getString("noValue");
        }
        String string = Internationalization.getString("range");
        object = Internationalization.getString("comma");
        String string2 = this.field.getFormattedStringValue(((Number)object3).doubleValue(), 0, null);
        String string3 = this.field.getFormattedStringValue(((Number)object2).doubleValue(), 0, null);
        return string + string2 + (String)object + string3;
    }

    @Override
    public String getCategoryForRows(int[] nArray) {
        if (!this.field.isCategorical() || nArray == null || nArray.length < 1) {
            return null;
        }
        String string = this.field.getFormattedValue(nArray[0]);
        if (string == null) {
            return null;
        }
        for (int i = 1; i < nArray.length; ++i) {
            String string2 = this.field.getFormattedValue(nArray[i]);
            if (string.equals(string2)) continue;
            return null;
        }
        return string;
    }

    private HashMap<String, String> makeCategoricalSummary(int[] nArray, int n) {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray[i];
            object2 = this.field.getFormattedValue(n2);
            if (object2 == null) {
                object2 = "";
            }
            if ((object = (Integer)hashMap2.get(object2)) == null) {
                hashMap2.put(object2, 1);
                continue;
            }
            int n3 = (Integer)object + 1;
            hashMap2.put(object2, n3);
        }
        String string = "";
        int n4 = 0;
        object2 = hashMap2.keySet();
        object = object2.toArray(new String[object2.size()]);
        BasicFactory.sortArray((Object[])object);
        for (Object object3 : object) {
            if (n4 > 0) {
                string = string.concat(", ");
            }
            string = string.concat((String)object3 + ":" + (Integer)hashMap2.get(object3));
            ++n4;
        }
        hashMap.put(COUNT, string);
        hashMap.put("type", CATEGORICAL);
        return hashMap;
    }
}

