/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.TargetedStyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class LayoutStyleInfo {
    private final boolean textStyle;
    private final boolean lineLike;
    protected final String key;

    public static LayoutStyleInfo[] getTargetedStyles(String string) {
        if ("treemap".equals(string)) {
            int n = 6;
            LayoutStyleInfo[] layoutStyleInfoArray = new LayoutStyleInfo[n * 2 + 2];
            for (int i = 0; i < n; ++i) {
                String string2 = "level_" + i;
                layoutStyleInfoArray[i] = new LayoutStyleInfo(string2, false, false);
                string2 = "level_label_" + i;
                layoutStyleInfoArray[i + n] = new LayoutStyleInfo(string2, true, false);
            }
            layoutStyleInfoArray[n * 2] = new LayoutStyleInfo("level_leaf", false, false);
            layoutStyleInfoArray[n * 2 + 1] = new LayoutStyleInfo("level_label_leaf", true, false);
            return layoutStyleInfoArray;
        }
        if ("chord".equals(string)) {
            LayoutStyleInfo[] layoutStyleInfoArray = new LayoutStyleInfo[]{new LayoutStyleInfo("arc", false, false), new LayoutStyleInfo("arctext", true, false)};
            return layoutStyleInfoArray;
        }
        if ("fishbone".equals(string)) {
            LayoutStyleInfo[] layoutStyleInfoArray = new LayoutStyleInfo[3];
            for (int i = 0; i < layoutStyleInfoArray.length; ++i) {
                String string3 = "level_edge_" + i;
                layoutStyleInfoArray[i] = new LayoutStyleInfo(string3, false, true);
            }
            return layoutStyleInfoArray;
        }
        if ("calendar".equals(string)) {
            LayoutStyleInfo[] layoutStyleInfoArray = new LayoutStyleInfo[]{new LayoutStyleInfo("month", true, false), new LayoutStyleInfo("dayOfWeek", true, false), new LayoutStyleInfo("separator", false, true)};
            return layoutStyleInfoArray;
        }
        return null;
    }

    private LayoutStyleInfo(String string, boolean bl, boolean bl2) {
        this.textStyle = bl;
        this.lineLike = bl2;
        this.key = string;
    }

    public final boolean isTextStyle() {
        return this.textStyle;
    }

    public final boolean isLineLike() {
        return this.lineLike;
    }

    private TargetedStyleSpec makeTargetedStyle() {
        TargetedStyleSpec targetedStyleSpec = new TargetedStyleSpec();
        targetedStyleSpec.target = this.key;
        return targetedStyleSpec;
    }

    public TargetedStyleSpec getSpec(TargetedStyleSpec[] targetedStyleSpecArray) {
        if (targetedStyleSpecArray == null) {
            return this.makeTargetedStyle();
        }
        for (TargetedStyleSpec targetedStyleSpec : targetedStyleSpecArray) {
            if (!this.key.equals(targetedStyleSpec.target)) continue;
            return targetedStyleSpec;
        }
        return this.makeTargetedStyle();
    }
}

