/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility.description;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.accessibility.description.A11yValue;
import com.ibm.vis.spec.internal.FieldSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class A11yValueTuple {
    private final A11yValue[] values;

    A11yValueTuple(double[] dArray, int[] nArray) {
        this.values = new A11yValue[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.values[i] = new A11yValue(dArray[nArray[i]]);
        }
    }

    void format(FieldSpec[] fieldSpecArray) {
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            A11yValue a11yValue = this.values[i];
            FieldSpec fieldSpec = fieldSpecArray[i];
            if (a11yValue == null || fieldSpec == null) continue;
            a11yValue.setFormattedValueFromCategories(fieldSpec.categories);
        }
    }

    final A11yValue getValue(int n) {
        return this.values[n];
    }

    public String toString() {
        if (this.values == null || this.values.length < 1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) {
                stringBuilder.append(this.values[i].getAsString());
            }
            if (this.values.length == i + 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

