/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility.description;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class AestheticInfo {
    private final String[] aesthetics;
    private boolean[] required;
    private String[] requiredAesthetics;

    AestheticInfo(String[] stringArray, boolean[] blArray) {
        this.aesthetics = stringArray;
        this.required = blArray;
    }

    List<FieldSpec> getFields(ElementsSpec elementsSpec, DataSpec dataSpec) {
        ArrayList<FieldSpec> arrayList = new ArrayList<FieldSpec>();
        for (String string : this.aesthetics) {
            this.addAesthetic(string, elementsSpec, dataSpec, arrayList);
        }
        return arrayList;
    }

    String[] getRequiredAesthetics() {
        if (this.requiredAesthetics != null) {
            return this.requiredAesthetics;
        }
        if (this.required == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.required.length; ++i) {
            if (!this.required[i]) continue;
            arrayList.add(this.aesthetics[i]);
        }
        this.requiredAesthetics = arrayList.toArray(new String[arrayList.size()]);
        return this.requiredAesthetics;
    }

    private void addAesthetic(String string, ElementsSpec elementsSpec, DataSpec dataSpec, List<FieldSpec> list) {
        FieldSpec fieldSpec = null;
        if ("color".equals(string)) {
            fieldSpec = this.getFieldFromAesthetic(elementsSpec.color, dataSpec);
        } else if ("styleBy".equals(string)) {
            fieldSpec = this.getFieldFromAesthetic(elementsSpec.styleBy, dataSpec);
        } else if ("label".equals(string)) {
            this.addFieldsFromElementLabel(elementsSpec.label, dataSpec, list);
        } else if ("styleBy".equals(string)) {
            fieldSpec = this.getFieldFromAesthetic(elementsSpec.styleBy, dataSpec);
        } else if ("dashing".equals(string)) {
            fieldSpec = this.getFieldFromAesthetic(elementsSpec.styleBy, dataSpec);
        } else if ("size".equals(string)) {
            fieldSpec = this.getFieldFromAesthetic(elementsSpec.size, dataSpec);
        }
        if (fieldSpec != null) {
            list.add(fieldSpec);
        }
    }

    private void addFieldsFromElementLabel(ElementLabelSpec[] elementLabelSpecArray, DataSpec dataSpec, List<FieldSpec> list) {
        if (elementLabelSpecArray == null) {
            return;
        }
        for (ElementLabelSpec elementLabelSpec : elementLabelSpecArray) {
            this.addFieldsInLabel(elementLabelSpec, list, dataSpec);
        }
    }

    private void addFieldsInLabel(ElementLabelSpec elementLabelSpec, List<FieldSpec> list, DataSpec dataSpec) {
        for (Object object : elementLabelSpec.content) {
            FieldSpec fieldSpec;
            if (!(object instanceof FieldValueRefSpec) || (fieldSpec = this.getFieldSpec(((FieldValueRefSpec)object).$ref, dataSpec)) == null) continue;
            list.add(fieldSpec);
        }
    }

    private FieldSpec getFieldFromAesthetic(AestheticSpec[] aestheticSpecArray, DataSpec dataSpec) {
        return aestheticSpecArray == null || aestheticSpecArray.length < 1 ? null : this.getField(aestheticSpecArray[0], dataSpec);
    }

    private FieldSpec getField(AestheticSpec aestheticSpec, DataSpec dataSpec) {
        return aestheticSpec.field == null ? null : this.getFieldSpec(aestheticSpec.field.$ref, dataSpec);
    }

    private FieldSpec getFieldSpec(String string, DataSpec dataSpec) {
        if (dataSpec.fields != null) {
            for (FieldSpec fieldSpec : dataSpec.fields) {
                if (!string.equals(fieldSpec.id)) continue;
                return fieldSpec;
            }
        }
        return null;
    }
}

