/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility.description;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.accessibility.description.AestheticInfo;
import com.ibm.vis.internal.accessibility.description.DataInfo;
import com.ibm.vis.internal.accessibility.description.FacetInfo;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FacetSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DescriptionRule {
    private final String elementType;
    private final String layoutMethod;
    private final String[] transformMethods;
    private final int dimensions;
    private final String ruleName;
    private final DataInfo info;
    private final AestheticInfo aes;
    private final FacetInfo[] facetInfos;
    private List<DescriptionRule> children;
    private int matchValue;

    DescriptionRule(String string, String string2, DataInfo dataInfo, int n, String string3, String[] stringArray, AestheticInfo aestheticInfo, FacetInfo[] facetInfoArray) {
        this.elementType = string;
        this.ruleName = string2;
        this.info = dataInfo;
        this.dimensions = n;
        this.layoutMethod = string3;
        this.transformMethods = stringArray;
        this.aes = aestheticInfo;
        this.facetInfos = facetInfoArray;
    }

    protected void addChild(DescriptionRule descriptionRule) {
        if (this.children == null) {
            this.children = new ArrayList<DescriptionRule>();
        }
        this.children.add(descriptionRule);
    }

    final String getName() {
        return this.ruleName;
    }

    final DataInfo getInfo() {
        return this.info;
    }

    protected DescriptionRule findMatch(ElementsSpec elementsSpec, GrammarSpec grammarSpec) {
        this.match(elementsSpec, grammarSpec);
        if (this.matchValue == 0) {
            return null;
        }
        DescriptionRule descriptionRule = this;
        if (this.children != null) {
            for (DescriptionRule descriptionRule2 : this.children) {
                DescriptionRule descriptionRule3 = descriptionRule2.findMatch(elementsSpec, grammarSpec);
                if (descriptionRule3 == null || descriptionRule3.matchValue <= descriptionRule.matchValue) continue;
                descriptionRule = descriptionRule3;
            }
        }
        return descriptionRule;
    }

    private void match(ElementsSpec elementsSpec, GrammarSpec grammarSpec) {
        this.matchValue = 0;
        if (!elementsSpec.type.equals(this.elementType) || !this.facetPasses(grammarSpec.facet)) {
            return;
        }
        this.matchValue = this.hasRequiredAesthetics(elementsSpec);
        if (this.matchValue < 0) {
            this.matchValue = 0;
            return;
        }
        boolean bl = this.dimensionsMatch(grammarSpec.coordinates);
        boolean bl2 = this.layoutMatches(elementsSpec);
        if (!bl || !bl2) {
            ++this.matchValue;
            return;
        }
        if (bl2 && this.layoutMethod != null) {
            this.matchValue += 2;
            return;
        }
        int n = this.transformMatch(grammarSpec.coordinates);
        this.matchValue += n == 0 ? 1 : 2 + n;
    }

    boolean facetPasses(FacetSpec facetSpec) {
        if (facetSpec == null) {
            return this.areAllFacetsOptional();
        }
        if (this.facetInfos == null) {
            return false;
        }
        return this.getMatchingFacet(facetSpec) != null;
    }

    FacetInfo getMatchingFacet(FacetSpec facetSpec) {
        if (facetSpec == null || this.facetInfos == null) {
            return null;
        }
        for (FacetInfo facetInfo : this.facetInfos) {
            if (!facetInfo.matches(facetSpec)) continue;
            return facetInfo;
        }
        return null;
    }

    private boolean areAllFacetsOptional() {
        if (this.facetInfos == null) {
            return true;
        }
        for (FacetInfo facetInfo : this.facetInfos) {
            if (facetInfo.isOptional()) continue;
            return false;
        }
        return true;
    }

    private int hasRequiredAesthetics(ElementsSpec elementsSpec) {
        String[] stringArray = this.aes.getRequiredAesthetics();
        if (stringArray == null || stringArray.length < 1) {
            return 0;
        }
        int n = 0;
        for (String string : stringArray) {
            if ("color".equals(string)) {
                if (elementsSpec.color == null) {
                    return -10;
                }
                ++n;
                continue;
            }
            if ("styleBy".equals(string)) {
                if (elementsSpec.styleBy == null) {
                    return -10;
                }
                ++n;
                continue;
            }
            if ("label".equals(string)) {
                if (elementsSpec.label == null) {
                    return -10;
                }
                ++n;
                continue;
            }
            if ("dashing".equals(string)) {
                if (elementsSpec.dashing == null) {
                    return -10;
                }
                ++n;
                continue;
            }
            if (!"size".equals(string)) continue;
            if (elementsSpec.size == null) {
                return -10;
            }
            ++n;
        }
        return n;
    }

    private boolean dimensionsMatch(CoordinatesSpec coordinatesSpec) {
        if (coordinatesSpec.dimensions == null) {
            return this.dimensions == 0;
        }
        return coordinatesSpec.dimensions.length == this.dimensions;
    }

    private boolean layoutMatches(ElementsSpec elementsSpec) {
        if (this.layoutMethod == null) {
            return elementsSpec.positioning == null;
        }
        return elementsSpec.positioning != null && this.layoutMethod.equals(elementsSpec.positioning.method);
    }

    private int transformMatch(CoordinatesSpec coordinatesSpec) {
        if (this.transformMethods == null && (coordinatesSpec.transforms == null || coordinatesSpec.transforms.length == 0)) {
            return 2;
        }
        if (this.transformMethods == null || coordinatesSpec.transforms == null || coordinatesSpec.transforms.length == 0) {
            return 0;
        }
        if (this.transformMethods[0].equals(coordinatesSpec.transforms[0].type)) {
            if (this.transformMethods.length != coordinatesSpec.transforms.length) {
                return 1;
            }
            if (this.transformMethods.length == 1) {
                return 2;
            }
            return this.transformMethods[1].equals(coordinatesSpec.transforms[1].type) ? 2 : 1;
        }
        return 0;
    }

    final AestheticInfo getAestheticInfo() {
        return this.aes;
    }

    public String toString() {
        return this.ruleName;
    }
}

