/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility.description;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.internal.accessibility.description.AestheticInfo;
import com.ibm.vis.internal.accessibility.description.DataInfo;
import com.ibm.vis.internal.accessibility.description.DescriptionRule;
import com.ibm.vis.internal.accessibility.description.FacetInfo;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DescriptionRules {
    private static final String BOX_AND_WHISKER_PLOT = "boxAndWhiskerPlot";
    private static final String WORD_CLOUD = "wordCloud";
    private static final String CLOUD = "cloud";
    private static final String CALENDAR_PLOT = "calendarPlot";
    private static final String BUBBLE_PLOT = "bubblePlot";
    private static final String SCATTER_PLOT = "scatter";
    private static final String AREA_CHART = "areaChart";
    private static final String STACKED_AREA_CHART = "stackedAreaChart";
    private static final String CLUSTERED_AREA_CHART = "clusteredAreaChart";
    private static final String LINE_CHART = "lineChart";
    private static final String STACKED_LINE_CHART = "stackedLineChart";
    private static final String CLUSTERED_LINE_CHART = "clusteredLineChart";
    private static final String BUBBLE_CLOUD_PLOT = "bubbleCloudPlot";
    private static final String LINK_CHART = "linkChart";
    private static final String CHORD_CHART = "chordChart";
    private static final String BAR_CHART = "barChart";
    private static final String STACKED_BAR_CHART = "stackedBarChart";
    private static final String CLUSTER_BAR_CHART = "clusteredBarChart";
    private static final String CLUSTER_STACK_BAR_CHART = "clusterStackedBarChart";
    private static final String PIE_CHART = "pieChart";
    private static final String ROSE_CHART = "roseChart";
    private static final String TREEMAP = "treemap";
    private static List<DescriptionRule> rules;
    private static FacetInfo panelVert;
    private static FacetInfo panelHoriz;

    DescriptionRules() {
    }

    private static List<DescriptionRule> getRules() {
        if (rules == null) {
            rules = DescriptionRules.buildRules();
        }
        return rules;
    }

    static DescriptionRule findBestMatch(ElementsSpec elementsSpec, GrammarSpec grammarSpec) {
        List<DescriptionRule> list = DescriptionRules.getRules();
        for (DescriptionRule descriptionRule : list) {
            DescriptionRule descriptionRule2 = descriptionRule.findMatch(elementsSpec, grammarSpec);
            if (descriptionRule2 == null) continue;
            return descriptionRule2;
        }
        return null;
    }

    private static List<DescriptionRule> buildRules() {
        ArrayList<DescriptionRule> arrayList = new ArrayList<DescriptionRule>();
        arrayList.add(DescriptionRules.getIntervalRule());
        arrayList.add(DescriptionRules.getLineRule());
        arrayList.add(DescriptionRules.getPointRule());
        arrayList.add(DescriptionRules.getAreaRule());
        arrayList.add(DescriptionRules.getEdgeRule());
        arrayList.add(DescriptionRules.getTextRule());
        arrayList.add(DescriptionRules.getBoxplotRule());
        return arrayList;
    }

    private static DescriptionRule getBoxplotRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        dataInfo.rangeX = true;
        dataInfo.rangeY = true;
        String[] stringArray = new String[]{"color"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("schema:boxplot", DescriptionRules.gs(BOX_AND_WHISKER_PLOT), dataInfo, 2, null, null, aestheticInfo, null);
        return descriptionRule;
    }

    private static final String gs(String string) {
        return Internationalization.getString(string);
    }

    private static DescriptionRule getTextRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        dataInfo.rangeX = true;
        dataInfo.rangeY = true;
        dataInfo.maxValues = true;
        dataInfo.minValues = true;
        String[] stringArray = new String[]{"size", "color", "styleBy"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("text", DescriptionRules.gs(WORD_CLOUD), dataInfo, 2, CLOUD, null, aestheticInfo, null);
        return descriptionRule;
    }

    private static DescriptionRule getPointRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        dataInfo.rangeX = true;
        dataInfo.rangeY = true;
        dataInfo.maxValues = true;
        dataInfo.minValues = true;
        String[] stringArray = new String[]{"size", "color"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("point", DescriptionRules.gs(SCATTER_PLOT), dataInfo, 2, null, null, aestheticInfo, DescriptionRules.getPaneledFacets());
        String[] stringArray2 = new String[]{"size", "styleBy", "color", "label"};
        AestheticInfo aestheticInfo2 = new AestheticInfo(stringArray2, null);
        DescriptionRule descriptionRule2 = new DescriptionRule("point", DescriptionRules.gs(CALENDAR_PLOT), dataInfo, 2, "calendar", null, aestheticInfo2, null);
        descriptionRule.addChild(descriptionRule2);
        DescriptionRule descriptionRule3 = new DescriptionRule("point", DescriptionRules.gs(BUBBLE_CLOUD_PLOT), dataInfo, 2, "bubble", null, aestheticInfo, null);
        descriptionRule.addChild(descriptionRule3);
        AestheticInfo aestheticInfo3 = new AestheticInfo(stringArray, new boolean[]{true, false});
        DescriptionRule descriptionRule4 = new DescriptionRule("point", DescriptionRules.gs(BUBBLE_PLOT), dataInfo, 2, null, null, aestheticInfo3, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule4);
        return descriptionRule;
    }

    private static DescriptionRule getAreaRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        dataInfo.rangeX = true;
        dataInfo.rangeY = true;
        String[] stringArray = new String[]{"color"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("area", DescriptionRules.gs(AREA_CHART), dataInfo, 2, null, null, aestheticInfo, DescriptionRules.getPaneledFacets());
        String[] stringArray2 = new String[]{"stack"};
        DescriptionRule descriptionRule2 = new DescriptionRule("area", DescriptionRules.gs(STACKED_AREA_CHART), dataInfo, 2, null, stringArray2, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule2);
        String[] stringArray3 = new String[]{"cluster"};
        DescriptionRule descriptionRule3 = new DescriptionRule("area", DescriptionRules.gs(CLUSTERED_AREA_CHART), dataInfo, 2, null, stringArray3, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule3);
        return descriptionRule;
    }

    private static DescriptionRule getEdgeRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        String[] stringArray = new String[]{"color"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("edge", DescriptionRules.gs(LINK_CHART), dataInfo, 2, null, null, aestheticInfo, null);
        stringArray = new String[]{};
        aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule2 = new DescriptionRule("edge", DescriptionRules.gs(CHORD_CHART), dataInfo, 2, "chord", null, aestheticInfo, null);
        descriptionRule.addChild(descriptionRule2);
        return descriptionRule;
    }

    private static DescriptionRule getLineRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        dataInfo.rangeX = true;
        dataInfo.rangeY = true;
        String[] stringArray = new String[]{"color", "dashing"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("line", DescriptionRules.gs(LINE_CHART), dataInfo, 2, null, null, aestheticInfo, DescriptionRules.getPaneledFacets());
        String[] stringArray2 = new String[]{"stack"};
        DescriptionRule descriptionRule2 = new DescriptionRule("line", DescriptionRules.gs(STACKED_LINE_CHART), dataInfo, 2, null, stringArray2, aestheticInfo, null);
        descriptionRule.addChild(descriptionRule2);
        String[] stringArray3 = new String[]{"cluster"};
        DescriptionRule descriptionRule3 = new DescriptionRule("line", DescriptionRules.gs(CLUSTERED_LINE_CHART), dataInfo, 2, null, stringArray3, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule3);
        return descriptionRule;
    }

    private static FacetInfo[] getPaneledFacets() {
        return new FacetInfo[]{DescriptionRules.getPanelFacet(true), DescriptionRules.getPanelFacet(false)};
    }

    private static FacetInfo getPanelFacet(boolean bl) {
        if (bl) {
            if (panelHoriz == null) {
                panelHoriz = new FacetInfo("panelHorizontal", 1, null, true);
            }
            return panelHoriz;
        }
        if (panelVert == null) {
            panelVert = new FacetInfo("panel", 1, null, true);
        }
        return panelVert;
    }

    private static DescriptionRule getIntervalRule() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.categories = true;
        dataInfo.maxValues = true;
        dataInfo.minValues = true;
        String[] stringArray = new String[]{"color"};
        AestheticInfo aestheticInfo = new AestheticInfo(stringArray, null);
        DescriptionRule descriptionRule = new DescriptionRule("interval", DescriptionRules.gs(BAR_CHART), dataInfo, 2, null, null, aestheticInfo, DescriptionRules.getPaneledFacets());
        String[] stringArray2 = new String[]{"stack", "polar"};
        DescriptionRule descriptionRule2 = new DescriptionRule("interval", DescriptionRules.gs(PIE_CHART), dataInfo, 1, null, stringArray2, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule2);
        String[] stringArray3 = new String[]{"polar"};
        DescriptionRule descriptionRule3 = new DescriptionRule("interval", DescriptionRules.gs(ROSE_CHART), dataInfo, 2, null, stringArray3, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule3);
        String[] stringArray4 = new String[]{"stack"};
        DescriptionRule descriptionRule4 = new DescriptionRule("interval", DescriptionRules.gs(STACKED_BAR_CHART), dataInfo, 2, null, stringArray4, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule4);
        String[] stringArray5 = new String[]{"cluster"};
        DescriptionRule descriptionRule5 = new DescriptionRule("interval", DescriptionRules.gs(CLUSTER_BAR_CHART), dataInfo, 2, null, stringArray5, aestheticInfo, DescriptionRules.getPaneledFacets());
        descriptionRule.addChild(descriptionRule5);
        descriptionRule5 = new DescriptionRule("interval", DescriptionRules.gs(CLUSTER_BAR_CHART), dataInfo, 3, null, stringArray5, aestheticInfo, null);
        descriptionRule.addChild(descriptionRule5);
        String[] stringArray6 = new String[]{"cluster", "stack"};
        DescriptionRule descriptionRule6 = new DescriptionRule("interval", DescriptionRules.gs(CLUSTER_STACK_BAR_CHART), dataInfo, 2, null, stringArray6, aestheticInfo, null);
        descriptionRule.addChild(descriptionRule6);
        String[] stringArray7 = new String[]{"label", "color"};
        AestheticInfo aestheticInfo2 = new AestheticInfo(stringArray7, null);
        DescriptionRule descriptionRule7 = new DescriptionRule("interval", DescriptionRules.gs(TREEMAP), dataInfo, 0, TREEMAP, null, aestheticInfo2, null);
        descriptionRule.addChild(descriptionRule7);
        return descriptionRule;
    }

    static {
        panelVert = null;
        panelHoriz = null;
    }
}

