/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility.description;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.internal.accessibility.AccessibilityBuilder;
import com.ibm.vis.spec.internal.FacetSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class FacetInfo {
    private static final String PANELED_CHART = "paneled";
    private static final String FACETED_BY = "facetBy";
    private final String method;
    private final String name;
    private final int numFields;
    private final boolean optional;

    FacetInfo(String string, int n, String string2, boolean bl) {
        this.method = string;
        this.name = string2;
        this.numFields = n;
        this.optional = bl;
    }

    boolean matches(FacetSpec facetSpec) {
        if (facetSpec == null) {
            return false;
        }
        return this.method.equals(facetSpec.method) && this.numFields == facetSpec.fields.length;
    }

    boolean isOptional() {
        return this.optional;
    }

    String updateChartName(String string) {
        return this.name == null ? "paneled " + string : this.name;
    }

    String getFacetName(String string) {
        return AccessibilityBuilder.ParseLocalizationString(Internationalization.getString(FACETED_BY), string, 1);
    }
}

