/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility.description;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.internal.accessibility.AccessibilityBuilder;
import com.ibm.vis.internal.accessibility.description.A11yValueTuple;
import com.ibm.vis.internal.accessibility.description.A11yValueTupleComparator;
import com.ibm.vis.internal.accessibility.description.AestheticInfo;
import com.ibm.vis.internal.accessibility.description.DataInfo;
import com.ibm.vis.internal.accessibility.description.DescriptionRule;
import com.ibm.vis.internal.accessibility.description.DescriptionRules;
import com.ibm.vis.internal.accessibility.description.FacetInfo;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FacetFieldSpec;
import com.ibm.vis.spec.internal.FacetSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.StringValueSpec;
import com.ibm.vis.spec.internal.TitleSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SimpleChartDescriber {
    private static final String CATEGORIES = "categories";
    private static final String RANGE = "range";
    private static final String ROWS = "rows";
    private static final String MIN_VALUE = "minValue";
    private static final String MAX_VALUE = "maxValue";
    private static final String MIN_VALUES = "minValues";
    private static final String MAX_VALUES = "maxValues";
    private static final String FIELD_DESCRIPTIONS = "fieldDescriptions";
    private static final String Y_AXIS = "y";
    private static final String X_AXIS = "x";
    private VisJSONSpec spec;

    public SimpleChartDescriber(VisJSONSpec visJSONSpec) {
        this.spec = visJSONSpec;
    }

    public String getDescription() {
        if (this.spec.grammar.length > 1) {
            return null;
        }
        ElementsSpec[] elementsSpecArray = this.spec.grammar[0].elements;
        if (elementsSpecArray.length > 1) {
            return null;
        }
        DescriptionRule descriptionRule = DescriptionRules.findBestMatch(elementsSpecArray[0], this.spec.grammar[0]);
        if (descriptionRule == null) {
            return null;
        }
        List<String> list = this.createDescription(descriptionRule, elementsSpecArray[0], this.spec.grammar[0].facet);
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.get(0));
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("  \n").append(list.get(i));
        }
        return stringBuilder.toString();
    }

    private List<String> createDescription(DescriptionRule descriptionRule, ElementsSpec elementsSpec, FacetSpec facetSpec) {
        String string;
        A11yValueTuple[] a11yValueTupleArray;
        int n;
        FacetInfo facetInfo;
        List<String> list = this.getTitle();
        if (list == null) {
            list = new ArrayList<String>();
        }
        if ((facetInfo = descriptionRule.getMatchingFacet(facetSpec)) == null) {
            list.add(descriptionRule.getName());
        } else {
            list.add(facetInfo.updateChartName(descriptionRule.getName()));
        }
        DataInfo dataInfo = descriptionRule.getInfo();
        DataSpec dataSpec = this.getData(elementsSpec);
        FieldSpec fieldSpec = this.getFieldSpec(elementsSpec, 0);
        FieldSpec fieldSpec2 = this.getFieldSpec(elementsSpec, 1);
        ArrayList<FieldSpec> arrayList = this.getFieldsOfInterest(fieldSpec2, fieldSpec, elementsSpec, descriptionRule, dataSpec);
        FieldSpec[] fieldSpecArray = arrayList.toArray(new FieldSpec[arrayList.size()]);
        int[] nArray = this.buildRowColumns(fieldSpecArray, dataSpec);
        int n2 = n = fieldSpec2 != null && fieldSpec != null && fieldSpec2 != fieldSpec ? 1 : 0;
        if (dataInfo.rowCount) {
            this.addRowCount(dataSpec, list);
        }
        if (dataInfo.categories) {
            this.addCategories(fieldSpec2, fieldSpec, fieldSpecArray, list);
            this.addCategoriesForFaceting(facetInfo, facetSpec, list);
        }
        String string2 = this.buildFieldDescription(fieldSpecArray);
        if (dataInfo.maxValues && nArray.length > 0 && dataSpec != null) {
            a11yValueTupleArray = this.getEndValueTuples(dataSpec, nArray, fieldSpecArray, n, true);
            string = a11yValueTupleArray.length == 1 ? MAX_VALUE : MAX_VALUES;
            this.addValueTuples(Internationalization.getString(string), a11yValueTupleArray, string2, list);
        }
        if (dataInfo.minValues && nArray.length > 0 && dataSpec != null) {
            a11yValueTupleArray = this.getEndValueTuples(dataSpec, nArray, fieldSpecArray, n, false);
            string = a11yValueTupleArray.length == 1 ? MIN_VALUE : MIN_VALUES;
            this.addValueTuples(Internationalization.getString(string), a11yValueTupleArray, string2, list);
        }
        if (dataInfo.rangeY && fieldSpec != null && dataSpec != null) {
            a11yValueTupleArray = Internationalization.getString(Y_AXIS);
            this.addRange(dataSpec, fieldSpec, list, (String)a11yValueTupleArray);
        }
        if (dataInfo.rangeX && fieldSpec2 != null && dataSpec != null) {
            a11yValueTupleArray = Internationalization.getString(X_AXIS);
            this.addRange(dataSpec, fieldSpec2, list, (String)a11yValueTupleArray);
        }
        return list.isEmpty() ? null : list;
    }

    private void addCategoriesForFaceting(FacetInfo facetInfo, FacetSpec facetSpec, List<String> list) {
        if (facetInfo == null || facetSpec == null) {
            return;
        }
        for (FacetFieldSpec facetFieldSpec : facetSpec.fields) {
            FieldSpec fieldSpec;
            FieldRefSpec fieldRefSpec = facetFieldSpec.field;
            if (fieldRefSpec == null || fieldRefSpec.$ref == null || (fieldSpec = this.getFieldSpecFromId(fieldRefSpec.$ref)) == null) continue;
            String string = this.getFieldName(fieldSpec);
            StringBuilder stringBuilder = new StringBuilder(facetInfo.getFacetName(string));
            if (fieldSpec.categories != null) {
                String string2 = Internationalization.getString(CATEGORIES);
                stringBuilder.append(string2).append(fieldSpec.categories.length);
            }
            list.add(stringBuilder.toString());
        }
    }

    private String buildFieldDescription(FieldSpec[] fieldSpecArray) {
        if (fieldSpecArray == null || fieldSpecArray.length < 1) {
            return null;
        }
        String string = Internationalization.getString("comma");
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            stringBuilder.append(this.getFieldName(fieldSpecArray[i]));
            if (i >= fieldSpecArray.length - 1) continue;
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private int[] buildRowColumns(FieldSpec[] fieldSpecArray, DataSpec dataSpec) {
        int[] nArray = new int[fieldSpecArray.length];
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            nArray[i] = this.getFieldIndex(fieldSpecArray[i], dataSpec);
        }
        return nArray;
    }

    private ArrayList<FieldSpec> getFieldsOfInterest(FieldSpec fieldSpec, FieldSpec fieldSpec2, ElementsSpec elementsSpec, DescriptionRule descriptionRule, DataSpec dataSpec) {
        ArrayList<FieldSpec> arrayList = new ArrayList<FieldSpec>();
        this.addUniqueField(fieldSpec, arrayList);
        this.addUniqueField(fieldSpec2, arrayList);
        AestheticInfo aestheticInfo = descriptionRule.getAestheticInfo();
        if (aestheticInfo != null) {
            List<FieldSpec> list = aestheticInfo.getFields(elementsSpec, dataSpec);
            for (FieldSpec fieldSpec3 : list) {
                this.addUniqueField(fieldSpec3, arrayList);
            }
        }
        return arrayList;
    }

    private void addUniqueField(FieldSpec fieldSpec, ArrayList<FieldSpec> arrayList) {
        if (fieldSpec != null && !arrayList.contains(fieldSpec)) {
            arrayList.add(fieldSpec);
        }
    }

    private void addRange(DataSpec dataSpec, FieldSpec fieldSpec, List<String> list, String string) {
        Range range = this.getRange(dataSpec, fieldSpec);
        if (range != null) {
            String string2 = Internationalization.getString(RANGE);
            String string3 = Internationalization.getString("comma");
            String string4 = string == null ? this.getFieldName(fieldSpec) + string2 + MathUtil.s4(range.getMin()).toString() + string3 + MathUtil.s4(range.getMax()).toString() : this.getFieldName(fieldSpec) + " " + string + string2 + MathUtil.s4(range.getMin()).toString() + string3 + MathUtil.s4(range.getMax()).toString();
            list.add(string4);
        }
    }

    private void addCategories(FieldSpec fieldSpec, FieldSpec fieldSpec2, FieldSpec[] fieldSpecArray, List<String> list) {
        String string = " " + Internationalization.getString(CATEGORIES);
        if (fieldSpec != null && fieldSpec.categories != null) {
            list.add(this.getFieldName(fieldSpec) + AccessibilityBuilder.ParseLocalizationString(string, String.valueOf(fieldSpec.categories.length), 1));
            return;
        }
        if (fieldSpec2 != null && fieldSpec2.categories != null) {
            list.add(this.getFieldName(fieldSpec2) + AccessibilityBuilder.ParseLocalizationString(string, String.valueOf(fieldSpec2.categories.length), 1));
            return;
        }
        if (fieldSpecArray != null && fieldSpecArray.length > 0) {
            for (int i = 0; i < fieldSpecArray.length; ++i) {
                if (fieldSpecArray[i].categories == null) continue;
                list.add(this.getFieldName(fieldSpecArray[i]) + AccessibilityBuilder.ParseLocalizationString(string, String.valueOf(fieldSpecArray[i].categories.length), 1));
            }
        }
    }

    private void addRowCount(DataSpec dataSpec, List<String> list) {
        int n = dataSpec.rows.length;
        list.add(Internationalization.getString(ROWS) + n);
    }

    private void addValueTuples(String string, A11yValueTuple[] a11yValueTupleArray, String string2, List<String> list) {
        String string3;
        if (a11yValueTupleArray == null || a11yValueTupleArray.length < 1) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            if (a11yValueTupleArray.length > 1) {
                stringBuilder.append(AccessibilityBuilder.ParseLocalizationString(string, String.valueOf(a11yValueTupleArray.length), 1)).append(" ");
            } else {
                stringBuilder.append(string).append(" ");
            }
        }
        if (string2 != null) {
            string3 = Internationalization.getString(FIELD_DESCRIPTIONS) + " ";
            stringBuilder.append(AccessibilityBuilder.ParseLocalizationString(string3, string2, 1));
        }
        string3 = Internationalization.getString("comma");
        for (int i = 0; i < a11yValueTupleArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(a11yValueTupleArray[i].toString());
        }
        list.add(stringBuilder.toString());
    }

    private List<String> getTitle() {
        if (this.spec.titles == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TitleSpec titleSpec = this.spec.titles[0];
        String string = this.makeTitleString(titleSpec);
        if (string != null) {
            arrayList.add(string);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    private String makeTitleString(TitleSpec titleSpec) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray = titleSpec.content) {
            FieldSpec fieldSpec;
            if (BasicFactory.isString(object)) {
                stringBuilder.append((String)object);
                continue;
            }
            if (object instanceof StringValueSpec) {
                stringBuilder.append(((StringValueSpec)object).value);
                continue;
            }
            if (!(object instanceof FieldValueRefSpec) || (fieldSpec = this.getFieldSpecFromId(((FieldValueRefSpec)object).$ref)) == null) continue;
            stringBuilder.append(this.getFieldName(fieldSpec));
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private String getFieldName(FieldSpec fieldSpec) {
        return fieldSpec.label == null || fieldSpec.label.length() < 1 ? fieldSpec.id : fieldSpec.label;
    }

    private FieldSpec getFieldSpec(ElementsSpec elementsSpec, int n) {
        if (elementsSpec.position == null || elementsSpec.position.length < n + 1) {
            return null;
        }
        FieldValueRefSpec fieldValueRefSpec = elementsSpec.position[n].field;
        return fieldValueRefSpec == null ? null : this.getFieldSpecFromId(fieldValueRefSpec.$ref);
    }

    private DataSpec getData(ElementsSpec elementsSpec) {
        if (elementsSpec.data == null) {
            return this.spec.data == null || this.spec.data.length < 1 ? null : this.spec.data[0];
        }
        String string = elementsSpec.data.$ref;
        for (DataSpec dataSpec : this.spec.data) {
            if (!dataSpec.id.equals(string)) continue;
            return dataSpec;
        }
        return null;
    }

    private Range getRange(DataSpec dataSpec, FieldSpec fieldSpec) {
        int n = this.getFieldIndex(fieldSpec, dataSpec);
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (double[] dArray : dataSpec.rows) {
            if (Double.isNaN(dArray[n])) continue;
            double d3 = dArray[n];
            if (d > d3) {
                d = d3;
            }
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        return new Range(d, d2);
    }

    private A11yValueTuple[] getEndValueTuples(DataSpec dataSpec, int[] nArray, FieldSpec[] fieldSpecArray, int n, boolean bl) {
        Object[] objectArray2;
        ArrayList<A11yValueTuple> arrayList = new ArrayList<A11yValueTuple>();
        for (Object[] objectArray2 : dataSpec.rows) {
            if (Double.isNaN(objectArray2[n])) continue;
            arrayList.add(new A11yValueTuple((double[])objectArray2, nArray));
        }
        int n2 = arrayList.size();
        if (n2 < 2) {
            return new A11yValueTuple[0];
        }
        A11yValueTuple[] a11yValueTupleArray = arrayList.toArray(new A11yValueTuple[arrayList.size()]);
        Arrays.sort(a11yValueTupleArray, new A11yValueTupleComparator(n));
        int n3 = n2 > 11 ? 3 : (n2 < 4 ? 1 : 2);
        objectArray2 = new A11yValueTuple[n3];
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                objectArray2[i] = (double)a11yValueTupleArray[i];
                objectArray2[i].format(fieldSpecArray);
            }
        } else {
            --n2;
            for (int i = 0; i < n3; ++i) {
                objectArray2[i] = (double)((A11yValueTuple)arrayList.get(n2 - i));
                objectArray2[i].format(fieldSpecArray);
            }
        }
        return objectArray2;
    }

    private int getFieldIndex(FieldSpec fieldSpec, DataSpec dataSpec) {
        for (int i = 0; i < dataSpec.fields.length; ++i) {
            if (dataSpec.fields[i] != fieldSpec) continue;
            return i;
        }
        return 0;
    }

    private FieldSpec getFieldSpecFromId(String string) {
        for (DataSpec dataSpec : this.spec.data) {
            if (dataSpec.fields == null) continue;
            for (FieldSpec fieldSpec : dataSpec.fields) {
                if (!string.equals(fieldSpec.id)) continue;
                return fieldSpec;
            }
        }
        return null;
    }
}

