/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.json;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Diagnostic {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int NO_CODE = -1;
    private int code = -1;
    private int severity = 0;
    private String message;
    private List<Diagnostic> children;
    private String source;
    private List<Object> data;

    public Diagnostic(int n, int n2, String string, String string2) {
        this.severity = n;
        this.code = n2;
        this.source = string;
        this.message = string2;
    }

    public final void setCode(int n) {
        this.code = n;
    }

    public final int getCode() {
        return this.code;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final void setMessage(String string) {
        this.message = string;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setSource(String string) {
        this.source = string;
    }

    public final String getSource() {
        return this.source;
    }

    public final void setData(List<Object> list) {
        this.data = list;
    }

    public final List<Object> getData() {
        return this.data;
    }

    public final List<Diagnostic> getChildren() {
        return this.children;
    }

    public void add(Diagnostic diagnostic) {
        if (this.children == null) {
            this.children = new ArrayList<Diagnostic>();
        }
        this.children.add(diagnostic);
        int n = diagnostic.getSeverity();
        if (n > this.getSeverity()) {
            this.severity = n;
        }
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean isERROR() {
        return this.severity == 2;
    }

    public String toString() {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = this.message != null && !this.message.isEmpty();
        if (bl || this.children == null) {
            if (this.severity == 0) {
                stringBuilder.append("OK");
            } else if (this.severity == 1) {
                stringBuilder.append("WARNING");
            } else if (this.severity == 2) {
                stringBuilder.append("ERROR");
            } else {
                stringBuilder.append(this.severity);
            }
            if (bl) {
                if (this.source != null && !this.source.isEmpty()) {
                    stringBuilder.append(' ');
                    stringBuilder.append(this.source);
                    stringBuilder.append(':');
                }
                stringBuilder.append(' ');
                stringBuilder.append(this.message);
            }
        }
        if (this.children != null) {
            for (Diagnostic diagnostic : this.children) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(diagnostic);
            }
        }
        return stringBuilder.toString();
    }

    public static List<Diagnostic> flatten(Diagnostic diagnostic) {
        ArrayList<Diagnostic> arrayList = new ArrayList<Diagnostic>();
        Diagnostic.doFlatten(arrayList, diagnostic);
        return arrayList;
    }

    private static void doFlatten(List<Diagnostic> list, Diagnostic diagnostic) {
        list.add(diagnostic);
        List<Diagnostic> list2 = diagnostic.getChildren();
        if (list2 != null) {
            for (Diagnostic diagnostic2 : list2) {
                Diagnostic.doFlatten(list, diagnostic2);
            }
        }
    }
}

