/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class JSONTreeNode {
    private final LinkedHashMap<String, JSONTreeNode> children = new LinkedHashMap();
    private final ArrayList<JSONTreeNode> anonymousChildren = new ArrayList();
    private Object value;
    private final JSONTreeNode parent;
    private Object jsonObject;
    private boolean nodeHasAnonymousChildren;
    private final String propertyName;

    public JSONTreeNode(Object object, JSONTreeNode jSONTreeNode, String string) {
        this.parse(object);
        this.jsonObject = object;
        this.parent = jSONTreeNode;
        this.propertyName = string;
    }

    private void parse(Object object) {
        if (BasicFactory.isArray(object)) {
            JSONArray jSONArray = (JSONArray)object;
            this.nodeHasAnonymousChildren = true;
            for (Object e : jSONArray) {
                this.anonymousChildren.add(new JSONTreeNode(e, this, ""));
            }
        } else if (BasicFactory.isObject(object)) {
            for (String string : BasicFactory.keySet(object)) {
                Object object2 = BasicFactory.getItem(object, string);
                this.children.put(string, new JSONTreeNode(object2, this, string));
            }
        } else {
            this.value = object;
        }
    }

    public JSONTreeNode findNode(String string) {
        JSONTreeNode jSONTreeNode = null;
        for (String string2 : this.children.keySet()) {
            if (!string2.equals(string)) continue;
            jSONTreeNode = this.children.get(string2);
            break;
        }
        return jSONTreeNode;
    }

    public ArrayList<JSONTreeNode> findNodes(String string) {
        Object object;
        ArrayList<JSONTreeNode> arrayList = new ArrayList<JSONTreeNode>();
        JSONTreeNode jSONTreeNode = this.findNode(string);
        if (jSONTreeNode != null) {
            arrayList.add(jSONTreeNode);
        }
        for (JSONTreeNode object2 : this.anonymousChildren) {
            object = object2.findNodes(string);
            arrayList.addAll((Collection<JSONTreeNode>)object);
        }
        for (String string2 : this.children.keySet()) {
            object = this.children.get(string2);
            ArrayList<JSONTreeNode> arrayList2 = ((JSONTreeNode)object).findNodes(string);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public boolean containsValue(String string, Object object) {
        Object object2;
        Object object3;
        boolean bl = false;
        JSONTreeNode jSONTreeNode = this.children.get(string);
        if (jSONTreeNode == null) {
            object3 = this.anonymousChildren.iterator();
            while (object3.hasNext() && (jSONTreeNode = ((JSONTreeNode)(object2 = object3.next())).findNode(string)) == null) {
            }
        }
        if (jSONTreeNode != null && jSONTreeNode.value != null) {
            object3 = jSONTreeNode.value;
            object2 = object;
            if (BasicFactory.isNumber(object3)) {
                object3 = String.valueOf(object3);
            }
            if (BasicFactory.isNumber(object2)) {
                object2 = String.valueOf(object2);
            }
            bl = object3 == null ? object2 == null : object3.equals(object2);
        }
        return bl;
    }

    public boolean contains(String string) {
        if (this.children.get(string) != null) {
            return true;
        }
        for (JSONTreeNode jSONTreeNode : this.anonymousChildren) {
            if (jSONTreeNode.findNode(string) == null) continue;
            return true;
        }
        return false;
    }

    public ArrayList<JSONTreeNode> getChildren() {
        ArrayList<JSONTreeNode> arrayList = new ArrayList<JSONTreeNode>();
        arrayList.addAll(this.anonymousChildren);
        arrayList.addAll(this.children.values());
        return arrayList;
    }

    public final ArrayList<JSONTreeNode> getAnonymousChildren() {
        return this.anonymousChildren;
    }

    public JSONTreeNode getChildByIndex(int n) {
        JSONTreeNode jSONTreeNode = null;
        if (this.anonymousChildren.size() > n) {
            jSONTreeNode = this.anonymousChildren.get(n);
        } else if (this.children.size() > n) {
            Object[] objectArray = this.children.values().toArray();
            jSONTreeNode = (JSONTreeNode)objectArray[n];
        }
        return jSONTreeNode;
    }

    public final Object getValue() {
        return this.value;
    }

    public final Object getJSONObject() {
        return this.jsonObject;
    }

    public final JSONTreeNode getParent() {
        return this.parent;
    }

    public final boolean hasAnonymousChildren() {
        return this.nodeHasAnonymousChildren;
    }

    public void replaceValue(Object object) {
        JSONTreeNode jSONTreeNode = this.getParent();
        if (jSONTreeNode != null) {
            if (jSONTreeNode.isArray()) {
                int n = jSONTreeNode.getAnonymousChildren().indexOf(this);
                BasicFactory.setAt((JSONArray)jSONTreeNode.getJSONObject(), object, n);
                this.value = object;
                this.jsonObject = object;
            } else if (BasicFactory.isObject(jSONTreeNode.getJSONObject())) {
                BasicFactory.put(jSONTreeNode.getJSONObject(), this.propertyName, object);
                this.value = object;
                this.jsonObject = object;
            }
        }
    }

    public void remove() {
        JSONTreeNode jSONTreeNode = this.getParent();
        if (jSONTreeNode != null) {
            jSONTreeNode.removeNode(this);
        }
    }

    private void removeNode(JSONTreeNode jSONTreeNode) {
        if (this.isArray()) {
            this.removeAnonymousChild(jSONTreeNode);
        } else {
            String string = jSONTreeNode.propertyName;
            this.children.remove(string);
            BasicFactory.remove(this.getJSONObject(), string);
        }
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public void addChild(JSONTreeNode jSONTreeNode) {
        if (BasicFactory.isObject(this.getJSONObject())) {
            this.children.put(jSONTreeNode.getPropertyName(), jSONTreeNode);
            BasicFactory.put(this.getJSONObject(), jSONTreeNode.getPropertyName(), jSONTreeNode.getJSONObject());
        }
    }

    public List<JSONTreeNode> addAnonymousChildren(int n) {
        ArrayList<JSONTreeNode> arrayList = new ArrayList<JSONTreeNode>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.addAnonymousChild());
        }
        return arrayList;
    }

    public JSONTreeNode addAnonymousChild() {
        JSONTreeNode jSONTreeNode = null;
        if (this.isArray()) {
            JSONObject jSONObject = BasicFactory.createJSONObject();
            jSONTreeNode = new JSONTreeNode(jSONObject, this, null);
            this.anonymousChildren.add(jSONTreeNode);
            this.nodeHasAnonymousChildren = true;
            BasicFactory.add((JSONArray)this.getJSONObject(), jSONObject);
        }
        return jSONTreeNode;
    }

    public boolean removeAnonymousChild(JSONTreeNode jSONTreeNode) {
        if (this.isArray() && this.anonymousChildren.remove(jSONTreeNode)) {
            BasicFactory.removeFromArray((JSONArray)this.getJSONObject(), jSONTreeNode.getJSONObject());
            return true;
        }
        return false;
    }

    public boolean isArray() {
        return BasicFactory.isArray(this.getJSONObject());
    }
}

