/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/migrationLayer")
public final class RaveSchema {
    private static final String ID = "id";
    private static final String PROPERTIES = "properties";
    private final Map<String, JSONArtifact> references = new HashMap<String, JSONArtifact>();
    private final JSONObject schema;

    public RaveSchema(JSONObject jSONObject) {
        assert (jSONObject != null);
        this.schema = jSONObject;
        this.referenceSearch(jSONObject, false);
    }

    public JSONArtifact resolve(Object object) {
        return this.references.get(object);
    }

    private void referenceSearch(Object object, boolean bl) {
        block7: {
            block6: {
                if (!BasicFactory.isObject(object)) break block6;
                if (bl) {
                    for (String string : BasicFactory.keySet(object)) {
                        this.referenceSearch(BasicFactory.getItem(object, string), false);
                    }
                } else {
                    if (BasicFactory.containsKey(object, ID)) {
                        this.references.put((String)BasicFactory.getItem(object, ID), (JSONArtifact)((JSONObject)object));
                    }
                    for (String string : BasicFactory.keySet(object)) {
                        this.referenceSearch(BasicFactory.getItem(object, string), PROPERTIES.equals(string));
                    }
                }
                break block7;
            }
            if (!BasicFactory.isArray(object)) break block7;
            int n = BasicFactory.size((JSONArray)object);
            for (int i = 0; i < n; ++i) {
                this.referenceSearch(BasicFactory.getArrayItem((JSONArray)object, i), false);
            }
        }
    }

    public JSONObject getSchema() {
        return this.schema;
    }
}

