/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.json.Diagnostic;
import com.ibm.vis.internal.json.RaveSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/migrationLayer")
public final class SchemaValidator {
    private static final String SPEC = "Spec";
    private static final String DERIVED = "Derived";
    public static final int UNEXPECTED_OBJECT_CODE = 1;
    public static final int UNEXPECTED_OBJECT_STRICT_CODE = 100;
    public static final int REQUIRED_OBJECT_CODE = 101;
    public static final int REQUIRED_VALUE_CODE = 102;
    public static final int BAD_TYPE_CODE = 103;
    public static final int BAD_ENUM_CODE = 104;
    public static final int MIN_ITEMS_CODE = 105;
    public static final int MAX_ITEMS_CODE = 106;
    public static final int MIN_VALUE_CODE = 107;
    public static final int MAX_VALUE_CODE = 108;
    private static final String T_ANY = "any";
    private static final String T_NULL = "null";
    private static final String T_INTEGER = "integer";
    private static final String T_NUMBER = "number";
    private static final String T_BOOLEAN = "boolean";
    private static final String T_OBJECT = "object";
    private static final String T_ARRAY = "array";
    private static final String T_STRING = "string";
    private static final String REF = "$ref";
    private static final String ID = "id";
    private static final String ITEMS = "items";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String REQUIRED = "required";
    private static final String MINIMUM = "minimum";
    private static final String MAXIMUM = "maximum";
    private static final String MIN_ITEMS = "minItems";
    private static final String MAX_ITEMS = "maxItems";
    private static final String ENUM = "enum";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String CLASS_TYPE = "classType";
    private static final String PROVIDER = "provider";
    private static final String FIELD = "Field";
    private static final String REFERENCE = "ReferenceSpec";
    private static final String REFER_TO = "referTo";
    private boolean isExternalData = false;
    private final Map<String, Map<String, String>> refToExpectedTypesMap = new HashMap<String, Map<String, String>>();
    private final Map<String, String> idToTypeMap = new HashMap<String, String>();
    private final RaveSchema schema;

    public SchemaValidator(RaveSchema raveSchema) {
        assert (raveSchema != null);
        this.schema = raveSchema;
    }

    public Diagnostic validate(JSONArtifact jSONArtifact) {
        Diagnostic diagnostic = SchemaValidator.ok();
        this.checkProperties(diagnostic, this.schema.getSchema(), jSONArtifact, null, null, true);
        this.checkReferences();
        return diagnostic;
    }

    private void checkReferences() {
        this.checkInvalidReferences();
        this.checkIncorrectReferences();
    }

    private void checkIncorrectReferences() {
        for (String string : this.refToExpectedTypesMap.keySet()) {
            if (this.refToExpectedTypesMap.get(string).size() == 0) continue;
            Map<String, String> map = this.refToExpectedTypesMap.get(string);
            for (String string2 : map.keySet()) {
                String string3;
                String string4 = map.get(string2);
                if (string4 == null || string4.equals(REFERENCE) || (string3 = this.idToTypeMap.get(string)) == null) continue;
                if (string3.startsWith(DERIVED) && string3.endsWith(string4)) {
                    string3 = string4;
                }
                if (string3.equals(string4)) continue;
                throw new SpecException("The reference to the Id : \"" + string + "\" at the location " + string2 + " is incorrect. It is a reference of the type : " + SchemaValidator.trimClassName(string3) + " , while it should be a reference of type : " + SchemaValidator.trimClassName(string4) + ".", ErrorCode.SPEC_INVALID_REFERENCE_TYPE, null);
            }
        }
    }

    private static String trimClassName(String string) {
        return string.replace(SPEC, "");
    }

    private void checkInvalidReferences() {
        this.removeExternalFieldReferences();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.refToExpectedTypesMap.keySet()) {
            if (this.idToTypeMap.containsKey(string)) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            String string = SchemaValidator.constructErrorString(arrayList);
            throw new SpecException("The reference is not defined in the spec: " + (String)string, ErrorCode.SPEC_UNDEFINED_REFERENCE, null);
        }
    }

    private static String constructErrorString(List<String> list) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < list.size() - 1; ++n) {
            stringBuilder.append(list.get(n));
            stringBuilder.append(',');
        }
        stringBuilder.append(list.get(n));
        return stringBuilder.toString();
    }

    private void removeExternalFieldReferences() {
        Set<String> set = this.refToExpectedTypesMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            Map<String, String> map = this.refToExpectedTypesMap.get(string);
            Set<String> set2 = map.keySet();
            for (String string2 : set2) {
                String string3 = map.get(string2);
                if (string3 != null && !string3.contains(FIELD) || !this.isExternalData) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.size() > 0) {
            set.removeAll(arrayList);
        }
    }

    private static String createDebugPath(String string, Object object) {
        String string2 = null;
        if (string == null) {
            string2 = object == null ? "" : object.toString();
        } else if (BasicFactory.isNumber(object)) {
            string2 = string + '[' + ((Number)object).intValue() + ']';
        } else if (BasicFactory.isString(object)) {
            string2 = string;
            if (!string.isEmpty()) {
                string2 = string2 + '.';
            }
            string2 = string2 + object.toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    private void checkProperties(Diagnostic diagnostic, Object object, Object object2, String string, Object object3, boolean bl) {
        String string2 = SchemaValidator.createDebugPath(string, object3);
        Object object4 = object;
        Object object5 = BasicFactory.getItem(object4, REF);
        if (object5 != null) {
            object4 = this.schema.resolve(object5);
        }
        this.checkType(diagnostic, BasicFactory.getItem(object4, TYPE), object2, string2, bl);
        if (object2 != null) {
            Object object6;
            Object object7;
            Object object8;
            if (BasicFactory.isArray(object2)) {
                Object object9;
                int n;
                object8 = BasicFactory.getItem(object4, ITEMS);
                if (object8 != null) {
                    int n2;
                    n = BasicFactory.size((JSONArray)object2);
                    if (BasicFactory.isArray(object8)) {
                        for (n2 = 0; n2 < n; ++n2) {
                            this.checkProperties(diagnostic, BasicFactory.getArrayItem((JSONArray)object8, n2), BasicFactory.getArrayItem((JSONArray)object2, n2), string2, n2, true);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            this.checkProperties(diagnostic, object8, BasicFactory.getArrayItem((JSONArray)object2, n2), string2, n2, false);
                        }
                    }
                }
                n = BasicFactory.size((JSONArray)object2);
                object7 = BasicFactory.getItem(object4, MIN_ITEMS);
                if (object7 != null && n < Integer.parseInt(object7.toString())) {
                    diagnostic.add(SchemaValidator.error(105, string2, "'" + n + "' is less than the minimum array size " + Integer.parseInt(BasicFactory.getItem(object4, MIN_ITEMS).toString()) + '.'));
                }
                if ((object9 = BasicFactory.getItem(object4, MAX_ITEMS)) != null && n > Integer.parseInt(object9.toString())) {
                    diagnostic.add(SchemaValidator.error(106, string2, "'" + n + "' is greater than the maximum array size " + Integer.parseInt(object9.toString()) + '.'));
                }
            } else {
                object8 = BasicFactory.getItem(object4, PROPERTIES);
                if (object8 != null) {
                    this.checkObject(diagnostic, object4, object8, object2, BasicFactory.getItem(object4, ADDITIONAL_PROPERTIES), string2);
                }
            }
            object8 = BasicFactory.getItem(object4, MINIMUM);
            if (object8 != null && BasicFactory.isNumber(object2) && ((Number)object8).doubleValue() > ((Number)object2).doubleValue()) {
                diagnostic.add(SchemaValidator.error(107, string2, "'" + ((Number)object2).doubleValue() + "' is less than the minimum value of " + ((Number)object8).doubleValue() + '.'));
            }
            if ((object6 = BasicFactory.getItem(object4, MAXIMUM)) != null && BasicFactory.isNumber(object2) && ((Number)object6).doubleValue() < ((Number)object2).doubleValue()) {
                diagnostic.add(SchemaValidator.error(108, string2, "'" + ((Number)object2).doubleValue() + "' is greater than the maximum value of " + ((Number)object6).doubleValue() + '.'));
            }
            if ((object7 = BasicFactory.getItem(object4, ENUM)) != null) {
                SchemaValidator.validateEnums(diagnostic, object2, string2, object4, (JSONArray)object7);
            }
        }
    }

    private static void validateEnums(Diagnostic diagnostic, Object object, String string, Object object2, JSONArray jSONArray) {
        int n = BasicFactory.size(jSONArray);
        Object[] objectArray = null;
        for (int i = 0; i < n; ++i) {
            Object object3 = BasicFactory.getArrayItem(jSONArray, i);
            if (object3 == object || object3 != null && (BasicFactory.isString(object3) && BasicFactory.isString(object) && ((String)object3).equals(object) || BasicFactory.isBoolean(object3) && BasicFactory.isBoolean(object) && ((Boolean)object3).booleanValue() == ((Boolean)object).booleanValue() || BasicFactory.isNumber(object3) && BasicFactory.isNumber(object) && ((Number)object3).doubleValue() == ((Number)object).doubleValue())) {
                objectArray = null;
                break;
            }
            if (objectArray == null) {
                objectArray = new Object[n];
            }
            objectArray[i] = object3;
        }
        if (objectArray != null) {
            String string2 = SchemaValidator.buildString(objectArray);
            diagnostic.add(SchemaValidator.error(104, string, "Value of '" + object.toString() + "' does not exist in the enumeration " + string2 + "."));
        }
    }

    private void addToMap(String string, String string2, String string3) {
        Map<String, String> map = this.refToExpectedTypesMap.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            map.put(string3, string2);
            this.refToExpectedTypesMap.put(string, map);
        } else {
            map.put(string3, string2);
        }
    }

    private static boolean checkSimpleType(Object object, Object object2, boolean bl) {
        boolean bl2 = false;
        if (!T_ANY.equals(object)) {
            if (T_NULL.equals(object)) {
                bl2 = object2 != null;
            } else if (object2 == null) {
                bl2 = bl;
            } else if (T_NUMBER.equals(object)) {
                bl2 = !BasicFactory.isNumber(object2);
            } else if (T_ARRAY.equals(object)) {
                bl2 = !BasicFactory.isArray(object2);
            } else if (T_INTEGER.equals(object)) {
                if (!BasicFactory.isNumber(object2) || ((Number)object2).doubleValue() % 1.0 != 0.0) {
                    bl2 = true;
                }
            } else if (!SchemaValidator.getType(object2).equals(object)) {
                bl2 = object.equals("double") ? !SchemaValidator.getType(object2).equals(T_NUMBER) : true;
            }
        }
        return bl2;
    }

    private void checkType(Diagnostic diagnostic, Object object, Object object2, String string, boolean bl) {
        if (object != null) {
            if (BasicFactory.isString(object) && SchemaValidator.checkSimpleType(object, object2, bl)) {
                diagnostic.add(SchemaValidator.error(103, string, "Value of type '" + SchemaValidator.getType(object2) + "' found, but '" + object + "' is required."));
            }
            if (BasicFactory.isArray(object)) {
                Object object3;
                Diagnostic diagnostic2 = null;
                Diagnostic diagnostic3 = null;
                int n = BasicFactory.size((JSONArray)object);
                Object[] objectArray = null;
                for (int i = 0; i < n; ++i) {
                    object3 = BasicFactory.getArrayItem((JSONArray)object, i);
                    if (BasicFactory.isString(object3)) {
                        if (SchemaValidator.checkSimpleType(object3, object2, bl)) {
                            diagnostic2 = SchemaValidator.error(103, string, "Value of type '" + SchemaValidator.getType(object2) + "' found, but '" + object3 + "' is required.");
                        } else {
                            diagnostic2 = null;
                            diagnostic3 = null;
                        }
                    } else {
                        diagnostic2 = SchemaValidator.ok();
                        this.checkType(diagnostic2, object3, object2, string, bl);
                    }
                    if (diagnostic2 == null || diagnostic2.isOK()) break;
                    if (objectArray == null) {
                        objectArray = new Object[n];
                    }
                    objectArray[i] = object3;
                    diagnostic3 = SchemaValidator.getLeastSevereDiagnostic(diagnostic3, diagnostic2);
                }
                if (diagnostic2 != null && !diagnostic2.isOK() && diagnostic3 != null) {
                    if (diagnostic3.isERROR()) {
                        String string2 = SchemaValidator.buildString(objectArray);
                        object3 = SchemaValidator.error(103, string, "Value '" + object2 + "' of type '" + SchemaValidator.getType(object2) + "' found, but one of " + string2 + " is required.");
                        ((Diagnostic)object3).add(diagnostic3);
                        diagnostic.add((Diagnostic)object3);
                    } else {
                        diagnostic.add(diagnostic3);
                    }
                }
            } else if (BasicFactory.isObject(object)) {
                this.checkProperties(diagnostic, object, object2, string, null, bl);
            }
        }
    }

    private static Diagnostic getLeastSevereDiagnostic(Diagnostic diagnostic, Diagnostic diagnostic2) {
        int n;
        int n2;
        if (diagnostic == null) {
            return diagnostic2;
        }
        if (diagnostic2 == null) {
            return diagnostic;
        }
        if (SchemaValidator.hasBadType(diagnostic)) {
            return diagnostic2;
        }
        if (SchemaValidator.hasBadType(diagnostic2)) {
            return diagnostic;
        }
        int n3 = SchemaValidator.unexpectedObjectCount(diagnostic.getChildren());
        if (n3 < (n2 = SchemaValidator.unexpectedObjectCount(diagnostic2.getChildren()))) {
            return diagnostic;
        }
        if (n2 < n3) {
            return diagnostic2;
        }
        if (diagnostic.getSeverity() < diagnostic2.getSeverity()) {
            return diagnostic;
        }
        if (diagnostic2.getSeverity() < diagnostic.getSeverity()) {
            return diagnostic2;
        }
        int n4 = SchemaValidator.errorCount(diagnostic.getChildren());
        if (n4 < (n = SchemaValidator.errorCount(diagnostic2.getChildren()))) {
            return diagnostic;
        }
        if (n < n4) {
            return diagnostic2;
        }
        if (diagnostic.getChildren().size() <= diagnostic2.getChildren().size()) {
            return diagnostic;
        }
        return diagnostic2;
    }

    private static boolean hasBadType(Diagnostic diagnostic) {
        if (diagnostic.getCode() == 103) {
            return true;
        }
        List<Diagnostic> list = diagnostic.getChildren();
        if (list != null) {
            for (Diagnostic diagnostic2 : list) {
                if (diagnostic2.getCode() != 103) continue;
                return true;
            }
        }
        return false;
    }

    private static int errorCount(List<Diagnostic> list) {
        int n = 0;
        for (Diagnostic diagnostic : list) {
            if (diagnostic.getSeverity() != 2) continue;
            ++n;
        }
        return n;
    }

    private static int unexpectedObjectCount(List<Diagnostic> list) {
        int n = 0;
        for (Diagnostic diagnostic : list) {
            if (diagnostic.getCode() != 1 && diagnostic.getCode() != 100) continue;
            ++n;
        }
        return n;
    }

    private void checkObject(Diagnostic diagnostic, Object object, Object object2, Object object3, Object object4, String string) {
        String[] stringArray;
        if (BasicFactory.isObject(object2)) {
            if (!BasicFactory.isObject(object3)) {
                diagnostic.add(SchemaValidator.error(101, string, "An object is required."));
            }
            for (String string2 : stringArray = BasicFactory.keySet(object2)) {
                Object object5 = BasicFactory.getItem(object2, string2);
                boolean bl = SchemaValidator.isTrue(object5, REQUIRED);
                if (BasicFactory.containsKey(object3, string2)) {
                    Object object6 = BasicFactory.getItem(object3, string2);
                    if (ID.equals(string2) && BasicFactory.isString(object6)) {
                        this.idToTypeMap.put((String)object6, (String)BasicFactory.getItem(object, CLASS_TYPE));
                    } else if (REF.equals(string2)) {
                        if (BasicFactory.getItem(object, REF) != null) {
                            this.addToMap((String)object6, (String)BasicFactory.getItem(object, REF), string);
                        } else {
                            String string3 = (String)BasicFactory.getItem(object, REFER_TO);
                            if (string3 != null) {
                                this.addToMap((String)object6, string3, string);
                            } else {
                                this.addToMap((String)object6, null, string);
                            }
                        }
                    } else if (PROVIDER.equals(string2)) {
                        this.isExternalData = true;
                    }
                    this.checkProperties(diagnostic, object5, object6, string, string2, bl);
                    continue;
                }
                if (!bl) continue;
                diagnostic.add(SchemaValidator.error(102, string, "Missing required value '" + string2 + "'."));
            }
        }
        if (BasicFactory.isObject(object3)) {
            for (String string2 : stringArray = BasicFactory.keySet(object3)) {
                if (object2 == null || BasicFactory.containsKey(object2, string2)) continue;
                if (BasicFactory.isBoolean(object4) && !((Boolean)object4).booleanValue()) {
                    diagnostic.add(SchemaValidator.error(100, string, "The property " + string2 + " is not defined in the schema and the schema does not allow additional properties."));
                    continue;
                }
                diagnostic.add(SchemaValidator.warning(1, string, "The property '" + string2 + "' is not defined in the schema.", (JSONArtifact)((JSONObject)object3), string2));
            }
        }
    }

    private static final String getType(Object object) {
        if (object == null) {
            return T_NULL;
        }
        if (BasicFactory.isString(object)) {
            return T_STRING;
        }
        if (BasicFactory.isBoolean(object)) {
            return T_BOOLEAN;
        }
        if (BasicFactory.isNumber(object)) {
            return T_NUMBER;
        }
        if (BasicFactory.isArray(object)) {
            return T_ARRAY;
        }
        if (BasicFactory.isObject(object)) {
            return T_OBJECT;
        }
        throw new IllegalArgumentException("Unexpected type for value '" + object + "'.");
    }

    private static final boolean isTrue(Object object, String string) {
        Object object2;
        if (BasicFactory.containsKey(object, string) && BasicFactory.isBoolean(object2 = BasicFactory.getItem(object, string))) {
            return (Boolean)object2;
        }
        return false;
    }

    private static final Diagnostic ok() {
        return new Diagnostic(0, -1, null, null);
    }

    private static final Diagnostic error(int n, String string, String string2) {
        return SchemaValidator.createDiagnostic(2, n, string, string2, null, null);
    }

    private static final Diagnostic warning(int n, String string, String string2, JSONArtifact jSONArtifact, Object object) {
        return SchemaValidator.createDiagnostic(1, n, string, string2, jSONArtifact, object);
    }

    private static final Diagnostic createDiagnostic(int n, int n2, String string, String string2, JSONArtifact jSONArtifact, Object object) {
        Diagnostic diagnostic = new Diagnostic(n, n2, string, string2);
        if (jSONArtifact != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(jSONArtifact);
            arrayList.add(object);
            diagnostic.setData(arrayList);
        }
        return diagnostic;
    }

    public static final boolean fixWarnings(Diagnostic diagnostic) {
        List<Object> list;
        boolean bl = false;
        if (diagnostic.getSeverity() == 1 && diagnostic.getCode() == 1 && (list = diagnostic.getData()) != null && list.size() == 2 && BasicFactory.isObject(list.get(0)) && BasicFactory.isString(list.get(1))) {
            BasicFactory.remove(list.get(0), (String)list.get(1));
            bl = true;
        }
        if ((list = diagnostic.getChildren()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                bl = SchemaValidator.fixWarnings((Diagnostic)list.get(i)) || bl;
            }
        }
        return bl;
    }

    private static String buildString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("'");
            stringBuilder.append(objectArray[i]);
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }
}

