/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.json;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.ResourceUtil;
import com.ibm.vis.engine.internal.util.Version;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.json.Diagnostic;
import com.ibm.vis.internal.json.RaveSchema;
import com.ibm.vis.internal.json.SchemaValidator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/migrationLayer")
public final class SpecValidator {
    public static final int TOO_OLD_CODE = 1001;
    private static final Version FIRST = new Version(1, 2, 0);
    private static final String VERSION = "version";
    private static Map<Version, RaveSchema> raveSchemas = new HashMap<Version, RaveSchema>(6);

    public static Diagnostic validate(JSONObject jSONObject) {
        return SpecValidator.validateWith(jSONObject, null);
    }

    public static Diagnostic validateWith(JSONObject jSONObject, Version version) {
        Version version2 = version;
        if (!BasicFactory.containsKey(jSONObject, VERSION)) {
            if (version == null) {
                throw new SpecException("A 'version' is required.", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        } else {
            version2 = Version.parseVersion((String)BasicFactory.getItem(jSONObject, VERSION));
        }
        return SpecValidator.validateAs((JSONArtifact)jSONObject, version2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Diagnostic validateAs(JSONArtifact jSONArtifact, Version version) {
        if (version.compareTo(FIRST) < 0) {
            return new Diagnostic(1, 1001, null, "The specification could not be validated because its version is less than " + FIRST.toString());
        }
        RaveSchema raveSchema = raveSchemas.get(version);
        if (raveSchema != null) return new SchemaValidator(raveSchema).validate(jSONArtifact);
        Class<SpecValidator> clazz = SpecValidator.class;
        synchronized (SpecValidator.class) {
            raveSchema = raveSchemas.get(version);
            if (raveSchema != null) return new SchemaValidator(raveSchema).validate(jSONArtifact);
            try {
                JSONObject jSONObject = ResourceUtil.getRaveSchema(version);
                if (jSONObject == null) {
                    throw new SpecException("Could not find a valid schema to validate specification 'version': " + version + ". The schema is invalid or empty. Consider disabling validation.", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                raveSchema = new RaveSchema(jSONObject);
                raveSchemas.put(version, raveSchema);
            }
            catch (IOException iOException) {
                throw new SpecException("Could not find a schema to validate specification 'version': " + version + ". The schema failed to load. Consider disabling validation.", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            return new SchemaValidator(raveSchema).validate(jSONArtifact);
        }
    }
}

