/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.renderer;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Dashing {
    private static final Map<String, int[]> DASHING_STYLES = new HashMap<String, int[]>();

    public static int[] getDashArray(String string) {
        if (string == null) {
            return null;
        }
        return DASHING_STYLES.get(string.toLowerCase());
    }

    public static boolean hasDashArray(String string) {
        if (string == null) {
            return false;
        }
        return DASHING_STYLES.containsKey(string.toLowerCase());
    }

    static {
        DASHING_STYLES.put("dot", new int[]{1, 3});
        DASHING_STYLES.put("shortdash", new int[]{4, 1});
        DASHING_STYLES.put("dash", new int[]{4, 3});
        DASHING_STYLES.put("longdash", new int[]{8, 3});
        DASHING_STYLES.put("shortdot", new int[]{1, 1});
        DASHING_STYLES.put("shortdashdot", new int[]{4, 1, 1, 1});
        DASHING_STYLES.put("shortdashdotdot", new int[]{4, 1, 1, 1, 1, 1});
        DASHING_STYLES.put("dashdot", new int[]{4, 3, 1, 3});
        DASHING_STYLES.put("longdashdot", new int[]{8, 3, 1, 3});
        DASHING_STYLES.put("longdashdotdot", new int[]{8, 3, 1, 3, 1, 3});
    }
}

