/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.renderer;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.interaction.effect.DirtyArea;
import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.renderer.GraphicsRenderer;
import com.ibm.vis.internal.renderer.NodeRenderer;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.spec.internal.LocalizationSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Renderer {
    private final SceneTree scene;
    private DirtyNodeManager dirtyNodeManager;

    public Renderer(SceneTree sceneTree) {
        this.scene = sceneTree;
    }

    public final void setDirtyNodeManager(DirtyNodeManager dirtyNodeManager) {
        this.dirtyNodeManager = dirtyNodeManager;
    }

    public void renderScene(GraphicsRenderer graphicsRenderer) {
        Renderer.render(graphicsRenderer, this.scene, this.dirtyNodeManager);
    }

    public final Dim getRenderImageSize() {
        return Renderer.getImageSize(this.scene);
    }

    public static void render(GraphicsRenderer graphicsRenderer, SceneTree sceneTree, DirtyNodeManager dirtyNodeManager) {
        if (sceneTree == null) {
            return;
        }
        Rect rect = null;
        if (dirtyNodeManager != null) {
            DirtyArea dirtyArea = dirtyNodeManager.getSceneDirtyArea();
            if (dirtyArea.getType() == 0) {
                return;
            }
            rect = dirtyArea.getDirtyRectangle();
            rect = Renderer.limitDirtyRect(rect, sceneTree);
            graphicsRenderer.clear(rect);
            if (rect != null) {
                graphicsRenderer.saveGraphicsState(null, rect);
            }
        }
        int n = 0;
        LocalizationSpec localizationSpec = sceneTree.getLocalization();
        if (localizationSpec != null) {
            if ("ltr".equals(localizationSpec.baseTextDirection)) {
                n = 1;
            } else if ("rtl".equals(localizationSpec.baseTextDirection)) {
                n = 2;
            }
        }
        CompositeSceneNode compositeSceneNode = sceneTree.getRoot();
        NodeRenderer nodeRenderer = graphicsRenderer.getNodeRendererProvider().getNodeRenderer(compositeSceneNode.getRenderType());
        if (Renderer.checkForShadows(compositeSceneNode)) {
            nodeRenderer.render(graphicsRenderer, compositeSceneNode, rect, n, 1, 0);
            nodeRenderer.render(graphicsRenderer, compositeSceneNode, rect, n, 2, 0);
        } else {
            nodeRenderer.render(graphicsRenderer, compositeSceneNode, rect, n, 0, 0);
        }
        if (rect != null) {
            graphicsRenderer.restoreGraphicsState();
        }
        if (dirtyNodeManager != null) {
            dirtyNodeManager.renderComplete();
        }
    }

    private static Rect limitDirtyRect(Rect rect, SceneTree sceneTree) {
        Rect rect2 = rect;
        Dim dim = sceneTree.getScaledSize();
        if (rect != null && (rect.getMinX() < 0.0 || rect.getMinY() < 0.0 || rect.getMaxX() > dim.getWidth() || rect.getMaxY() > dim.getHeight())) {
            double d = Math.max(rect.getMinX(), 0.0);
            double d2 = Math.max(rect.getMinY(), 0.0);
            double d3 = Math.min(rect.getMaxX() - d, dim.getWidth()) + 1.0;
            double d4 = Math.min(rect.getMaxY() - d2, dim.getHeight()) + 1.0;
            rect2 = new Rect(d, d2, d3, d4);
        }
        return rect2;
    }

    private static boolean checkForShadows(SceneNodeImpl sceneNodeImpl) {
        RenderEffects object3;
        Object object2;
        if (sceneNodeImpl.getShape() != null && (object2 = sceneNodeImpl.getRenderInfo()) != null && (object3 = ((SceneNodeRenderInfo)object2).getRenderEffects()) != null && object3.getShadow() != null) {
            return true;
        }
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            if (!Renderer.checkForShadows((SceneNodeImpl)sceneNode)) continue;
            return true;
        }
        return false;
    }

    public static final Dim getImageSize(SceneTree sceneTree) {
        Affine affine;
        Dim dim = sceneTree.getSize();
        TransformInfo transformInfo = sceneTree.getRoot().getTransform();
        Affine affine2 = affine = transformInfo == null ? null : transformInfo.getAffine();
        if (affine != null) {
            Point point = affine.transform(dim.getWidth(), dim.getHeight());
            dim = new Dim(point.getX(), point.getY());
        }
        int n = Math.max(1, (int)dim.getWidth());
        int n2 = Math.max(1, (int)dim.getHeight());
        return new Dim(n, n2);
    }
}

