/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.monitor.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogEntry;
import com.ibm.vis.monitor.LogLevel;
import java.util.HashMap;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LogEntryImpl
implements LogEntry {
    private final LogComponent component;
    private final String message;
    private final LogLevel level;
    private final HashMap<String, Object> parameters;
    private static final String[] NO_KEYS = new String[0];

    LogEntryImpl(LogLevel logLevel, LogComponent logComponent, String string, HashMap<String, Object> hashMap) {
        this.component = logComponent;
        this.message = string;
        this.level = logLevel;
        this.parameters = hashMap;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public LogComponent getComponent() {
        return this.component;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String[] getParameterKeys() {
        if (this.parameters == null) {
            return NO_KEYS;
        }
        Set<String> set = this.parameters.keySet();
        int n = set.size();
        if (n == 0) {
            return NO_KEYS;
        }
        return set.toArray(new String[n]);
    }

    @Override
    public Object getParameterValue(String string) {
        return this.parameters == null ? null : this.parameters.get(string);
    }

    public HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return (Object)((Object)this.level) + ":" + (Object)((Object)this.component) + ":" + this.message;
    }
}

