/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.monitor.internal;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.LogListener;
import com.ibm.vis.monitor.Logger;
import com.ibm.vis.monitor.internal.LogEntryImpl;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LoggerImpl
implements Logger {
    private final HashMap<String, Long> timing = new HashMap();
    private final ArrayList<LogListener> listeners = new ArrayList();

    public final boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public final Logger addListener(LogListener logListener) {
        if (!this.listeners.contains(logListener)) {
            this.listeners.add(logListener);
        }
        return this;
    }

    @Override
    public final Logger removeListener(LogListener logListener) {
        this.listeners.remove(logListener);
        return this;
    }

    public void logStartTime(LogComponent logComponent, String string) {
        this.timing.put(string, BasicFactory.getSystemTimer());
    }

    public void logEndTime(LogComponent logComponent, String string) {
        Long l = this.timing.get(string);
        if (l == null) {
            this.log(LogLevel.Warning, logComponent, "Timing Failed for " + string + " no matching start call", "target", string);
        } else {
            this.timing.remove(string);
            int n = (int)(BasicFactory.getSystemTimer() - l);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("time", n);
            this.logParam(LogLevel.Detail, logComponent, string + " Timing", hashMap);
        }
    }

    public void logParam(LogLevel logLevel, LogComponent logComponent, String string, HashMap<String, Object> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put("timestamp", BasicFactory.getUTCTime());
        for (LogListener logListener : this.listeners) {
            logListener.accept(new LogEntryImpl(logLevel, logComponent, string, hashMap));
        }
    }

    public final void log(LogLevel logLevel, LogComponent logComponent, String string, String string2, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string2 != null && object != null) {
            hashMap.put(string2, object);
        }
        this.logParam(logLevel, logComponent, string, hashMap);
    }

    public final void error(LogComponent logComponent, String string) {
        this.logParam(LogLevel.Error, logComponent, string, null);
    }

    public final void warning(LogComponent logComponent, String string) {
        this.logParam(LogLevel.Warning, logComponent, string, null);
    }

    public final void info(LogComponent logComponent, String string) {
        this.logParam(LogLevel.Info, logComponent, string, null);
    }

    public final void grammarError(LogComponent logComponent, String string) {
        this.logParam(LogLevel.GrammarError, logComponent, string, null);
    }

    public final void grammarWarning(LogComponent logComponent, String string) {
        this.logParam(LogLevel.GrammarWarning, logComponent, string, null);
    }

    public final void grammarInfo(LogComponent logComponent, String string) {
        this.logParam(LogLevel.GrammarInfo, logComponent, string, null);
    }

    public final void detail(LogComponent logComponent, String string) {
        this.logParam(LogLevel.Detail, logComponent, string, null);
    }

    public final void trace(LogComponent logComponent, String string) {
        this.logParam(LogLevel.Trace, logComponent, string, null);
    }

    public final boolean isTracing() {
        if (this.listeners.isEmpty()) {
            return false;
        }
        if (this.listeners.size() == 1) {
            return this.listeners.get(0).isTracing();
        }
        for (LogListener logListener : this.listeners) {
            if (!logListener.isTracing()) continue;
            return true;
        }
        return false;
    }
}

