/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.NonBasicGeom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.internal.ScenePartInterpolator;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AnimateRendererInfo
extends SceneNodeRenderInfo {
    private final SceneNodeRenderInfo base;
    private ScenePartInterpolator geomInterpolator;
    private ScenePartInterpolator styleInterpolator;
    private ScenePartInterpolator textInterpolator;
    private ScenePartInterpolator clipInterpolator;
    private ScenePartInterpolator transformInterpolator;
    private ScenePartInterpolator overrideInterpolator;

    public AnimateRendererInfo(SceneNodeRenderInfo sceneNodeRenderInfo) {
        this.base = sceneNodeRenderInfo;
    }

    @Override
    public boolean setAnimation(int n, ScenePartInterpolator scenePartInterpolator) {
        switch (n) {
            case 2: {
                this.geomInterpolator = scenePartInterpolator;
                break;
            }
            case 3: {
                this.styleInterpolator = scenePartInterpolator;
                break;
            }
            case 5: {
                this.clipInterpolator = scenePartInterpolator;
                break;
            }
            case 6: {
                this.transformInterpolator = scenePartInterpolator;
                break;
            }
            case 4: {
                this.textInterpolator = scenePartInterpolator;
                break;
            }
            case 1: {
                this.overrideInterpolator = scenePartInterpolator;
            }
        }
        return this.geomInterpolator == null && this.textInterpolator == null && this.styleInterpolator == null && this.clipInterpolator == null && this.transformInterpolator == null && this.overrideInterpolator == null;
    }

    @Override
    public SceneNode getNode() {
        return this.base.getNode();
    }

    @Override
    public Geom getRenderGeom() {
        if (this.geomInterpolator != null) {
            Geom geom = (Geom)this.geomInterpolator.interpolate();
            if (geom == null) {
                return null;
            }
            int n = geom.type();
            if (n == 1006 || n == 1005) {
                Stroke stroke = this.getRenderStroke();
                Shape shape = (Shape)this.getNode().getShape();
                if (shape.isInsideStroke() && stroke != null) {
                    double d = stroke.getWidth() / 2.0;
                    geom = geom.inset(d);
                    n = geom.type();
                }
                if (n == 1006 || n == 1005) {
                    geom = ((NonBasicGeom)geom).asSimple();
                }
            }
            return geom;
        }
        return this.base.getRenderGeom();
    }

    @Override
    public TextInfo getRenderText() {
        if (this.textInterpolator != null) {
            return (TextInfo)this.textInterpolator.interpolate();
        }
        return this.base.getRenderText();
    }

    @Override
    public GradientPaintInfo getRenderFill() {
        Object[] objectArray;
        GradientPaintInfo gradientPaintInfo = null;
        if (this.overrideInterpolator != null && (objectArray = (Object[])this.overrideInterpolator.interpolate())[0] != null) {
            gradientPaintInfo = (GradientPaintInfo)objectArray[0];
        }
        if ((gradientPaintInfo == null || gradientPaintInfo != null && gradientPaintInfo.getSolid() == null) && this.styleInterpolator != null && (objectArray = (Object[])this.styleInterpolator.interpolate())[0] != null) {
            gradientPaintInfo = (GradientPaintInfo)objectArray[0];
        }
        if (gradientPaintInfo == null || gradientPaintInfo != null && gradientPaintInfo.getSolid() == null && gradientPaintInfo.getColors().length == 0) {
            gradientPaintInfo = this.base.getRenderFill();
        }
        return gradientPaintInfo;
    }

    @Override
    public void setRenderFill(GradientPaintInfo gradientPaintInfo) {
        this.base.setRenderFill(gradientPaintInfo);
    }

    @Override
    public Stroke getRenderStroke() {
        Object[] objectArray;
        Stroke stroke = null;
        if (this.overrideInterpolator != null && (objectArray = (Object[])this.overrideInterpolator.interpolate())[1] != null) {
            stroke = (Stroke)objectArray[1];
        }
        if (stroke == null && this.styleInterpolator != null && (objectArray = (Object[])this.styleInterpolator.interpolate())[1] != null) {
            return (Stroke)objectArray[1];
        }
        if (stroke == null) {
            stroke = this.base.getRenderStroke();
        }
        return stroke;
    }

    @Override
    public RenderEffects getRenderEffects() {
        Object[] objectArray;
        RenderEffects renderEffects = null;
        if (this.overrideInterpolator != null && (objectArray = (Object[])this.overrideInterpolator.interpolate())[3] != null) {
            renderEffects = (RenderEffects)objectArray[3];
        }
        if (renderEffects == null && this.styleInterpolator != null && (objectArray = (Object[])this.styleInterpolator.interpolate())[3] != null) {
            return (RenderEffects)objectArray[3];
        }
        if (renderEffects == null) {
            renderEffects = this.base.getRenderEffects();
        }
        return renderEffects;
    }

    @Override
    public ImageFill getRenderImage() {
        ImageFill imageFill = this.base.getRenderImage();
        if (imageFill != null && (this.overrideInterpolator != null || this.styleInterpolator != null)) {
            Rect rect = this.base.getRenderBounds();
            Point point = new Point(imageFill.getX() - rect.getX(), imageFill.getY() - rect.getY());
            Rect rect2 = this.getRenderBounds();
            Point point2 = new Point(rect2.getX() + point.getX(), rect2.getY() + point.getY());
            Object[] objectArray = null;
            if (this.overrideInterpolator != null) {
                objectArray = (Object[])this.overrideInterpolator.interpolate();
            }
            if ((objectArray == null || objectArray.length < 3 || objectArray[2] == null) && this.styleInterpolator != null) {
                objectArray = (Object[])this.styleInterpolator.interpolate();
            }
            if (objectArray[2] != null) {
                Double d = (Double)objectArray[2];
                ImageFill imageFill2 = ImageFill.createFill(imageFill.getImageResource(), new Rect(point2.getX(), point2.getY(), imageFill.getWidth(), imageFill.getHeight()), d, imageFill.isClipped());
                return imageFill2;
            }
        }
        return imageFill;
    }

    @Override
    public Rect getRenderBounds() {
        if (this.textInterpolator != null) {
            TextInfo textInfo = (TextInfo)this.textInterpolator.interpolate();
            return textInfo == null ? null : textInfo.getNonTransformedBounds();
        }
        Geom geom = this.getRenderGeom();
        return geom == null ? this.base.getRenderBounds() : geom.getBounds();
    }

    @Override
    public boolean canAnimate() {
        return true;
    }

    @Override
    public SceneNodeRenderInfo getBase() {
        return this.base;
    }

    @Override
    public Rect getClipBounds() {
        return this.clipInterpolator == null ? this.base.getClipBounds() : (Rect)this.clipInterpolator.interpolate();
    }

    @Override
    public TransformInfo getTransform() {
        if (this.transformInterpolator != null) {
            return (TransformInfo)this.transformInterpolator.interpolate();
        }
        if (this.textInterpolator != null) {
            TransformInfo transformInfo = (TransformInfo)this.textInterpolator.interpolate();
            if (transformInfo == null) {
                return null;
            }
            TransformInfoImpl transformInfoImpl = new TransformInfoImpl();
            transformInfoImpl.setAffine(transformInfo.getAffine());
            return transformInfoImpl;
        }
        return this.base.getTransform();
    }
}

