/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CompositeSceneNode
extends SceneNodeImpl {
    private List<SceneNode> children = new ArrayList<SceneNode>();

    @Override
    public List<SceneNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<SceneNode> list) {
        this.children = list;
        if (list != null) {
            for (SceneNode sceneNode : list) {
                ((SceneNodeImpl)sceneNode).setParent(this);
            }
        }
    }

    public int getChildrenCount() {
        return this.getChildren().size();
    }

    public SceneNode getChild(int n) {
        return this.getChildren().get(n);
    }

    public void addChildAt(int n, SceneNode sceneNode) {
        this.getChildren().add(n, sceneNode);
        ((SceneNodeImpl)sceneNode).setParent(this);
    }

    public void addChild(SceneNode sceneNode) {
        this.getChildren().add(sceneNode);
        ((SceneNodeImpl)sceneNode).setParent(this);
    }

    public void removeChild(SceneNode sceneNode) {
        if (this.getChildren().remove(sceneNode)) {
            ((SceneNodeImpl)sceneNode).setParent(null);
        }
    }

    public void removeChildAt(int n) {
        this.getChildren().remove(n);
    }

    @Override
    public SceneNodeClassId getClassId() {
        return SceneNodeClassId.COMPOSITE_NODE;
    }

    @Override
    public Rect getPhysicalBounds() {
        Rect rect = null;
        for (SceneNode sceneNode : this.children) {
            Rect rect2 = sceneNode.getPhysicalBounds();
            if (rect == null) {
                rect = rect2.copy();
            }
            if (rect2 == null) continue;
            rect.extendToRect(rect2);
        }
        return Shape.transformBounds(rect, this.getTransform().getAffine());
    }
}

