/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.image.ImageResource;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CoreJSONSerializer {
    public static JSONObject serializeAffine(Affine affine) {
        if (affine == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        Number number = MathUtil.r3(affine.m00);
        if (number.doubleValue() != 1.0) {
            BasicFactory.put(jSONObject, "xx", number);
        }
        if ((number = MathUtil.r3(affine.m01)).doubleValue() != 0.0) {
            BasicFactory.put(jSONObject, "xy", number);
        }
        if ((number = MathUtil.r3(affine.m02)).doubleValue() != 0.0) {
            BasicFactory.put(jSONObject, "dx", number);
        }
        if ((number = MathUtil.r3(affine.m10)).doubleValue() != 0.0) {
            BasicFactory.put(jSONObject, "yx", number);
        }
        if ((number = MathUtil.r3(affine.m11)).doubleValue() != 1.0) {
            BasicFactory.put(jSONObject, "yy", number);
        }
        if ((number = MathUtil.r3(affine.m12)).doubleValue() != 0.0) {
            BasicFactory.put(jSONObject, "dy", number);
        }
        return BasicFactory.isEmpty(jSONObject) ? null : jSONObject;
    }

    public static Affine deserializeAffine(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        double d = BasicFactory.getNumberWithDefault(jSONObject, "xx", 1.0);
        double d2 = BasicFactory.getNumberWithDefault(jSONObject, "xy", 0.0);
        double d3 = BasicFactory.getNumberWithDefault(jSONObject, "dx", 0.0);
        double d4 = BasicFactory.getNumberWithDefault(jSONObject, "yx", 0.0);
        double d5 = BasicFactory.getNumberWithDefault(jSONObject, "yy", 1.0);
        double d6 = BasicFactory.getNumberWithDefault(jSONObject, "dy", 0.0);
        return new Affine(d, d2, d3, d4, d5, d6);
    }

    public static Affine deserializeAffineNonNull(JSONObject jSONObject) {
        if (jSONObject == null) {
            return Affine.identity();
        }
        return CoreJSONSerializer.deserializeAffine(jSONObject);
    }

    public static JSONObject serializeImageFill(ImageFill imageFill) {
        JSONObject jSONObject;
        Object object;
        if (imageFill == null) {
            return null;
        }
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        String string = imageFill.getMethod();
        BasicFactory.put(jSONObject2, "method", string);
        BasicFactory.put(jSONObject2, "source", CoreJSONSerializer.serializeImageResource(imageFill.getImageResource()));
        BasicFactory.put(jSONObject2, "alpha", imageFill.getAlpha());
        BasicFactory.put(jSONObject2, "x", MathUtil.r3(imageFill.getX()));
        BasicFactory.put(jSONObject2, "y", MathUtil.r3(imageFill.getY()));
        BasicFactory.put(jSONObject2, "width", MathUtil.r3(imageFill.getWidth()));
        BasicFactory.put(jSONObject2, "height", MathUtil.r3(imageFill.getHeight()));
        BasicFactory.put(jSONObject2, "clip", imageFill.isClipped());
        if (string.equals("texture")) {
            BasicFactory.put(jSONObject2, "tileX", imageFill.getTileX());
            BasicFactory.put(jSONObject2, "tileY", imageFill.getTileY());
        }
        if (string.equals("icon") && (object = imageFill.getHighlightRectID()) != null) {
            BasicFactory.put(jSONObject2, "HLRectID", object);
        }
        if ((jSONObject = CoreJSONSerializer.serializeAffine((Affine)(object = imageFill.getTransformInfo().getAffine()))) != null) {
            BasicFactory.put(jSONObject2, "transform", jSONObject);
        }
        return jSONObject2;
    }

    public static JSONObject serializeImageResource(ImageResource imageResource) {
        String string;
        Object object;
        JSONObject jSONObject = BasicFactory.createJSONObject();
        String[] stringArray = imageResource.getURIs();
        if (stringArray != null) {
            object = BasicFactory.createJSONArray();
            for (int i = 0; i < stringArray.length; ++i) {
                BasicFactory.add(object, stringArray[i]);
            }
            BasicFactory.put(jSONObject, "URIs", object);
        }
        if ((object = imageResource.getType()) != null) {
            BasicFactory.put(jSONObject, "type", object);
        }
        if ((string = imageResource.getEmbeddedData()) != null) {
            BasicFactory.put(jSONObject, "embedded", string);
        }
        return jSONObject;
    }

    public static JSONObject serializeA11y(AccessibleInfo accessibleInfo) {
        if (accessibleInfo == null || accessibleInfo.isEmpty()) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        JSONObject jSONObject2 = null;
        Map<String, Object> map = accessibleInfo.getProperties();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object instanceof AccessibleInfo) {
                object = CoreJSONSerializer.serializeA11y((AccessibleInfo)object);
                BasicFactory.put(jSONObject, string, object);
                continue;
            }
            if (object == null || BasicFactory.isBoolean(object)) {
                if (jSONObject2 == null) {
                    jSONObject2 = BasicFactory.createJSONObject();
                    BasicFactory.put(jSONObject, "state", jSONObject2);
                }
                BasicFactory.put(jSONObject2, string, object);
                continue;
            }
            if (object instanceof Map) {
                CoreJSONSerializer.serializeA11yMapProperty(jSONObject, string, (Map)object);
                continue;
            }
            BasicFactory.put(jSONObject, string, object);
        }
        return jSONObject;
    }

    private static void serializeA11yMapProperty(JSONObject jSONObject, String string, Map<String, String> map) {
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2);
            if (string3 instanceof Map) {
                CoreJSONSerializer.serializeA11yMapProperty(jSONObject2, string2, (Map)((Object)string3));
                continue;
            }
            BasicFactory.put(jSONObject2, string2, string3);
        }
        BasicFactory.put(jSONObject, string, jSONObject2);
    }
}

