/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.MathUtil;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FoundationJSONSerializer {
    public static JSONObject serializeColor(ColorNew colorNew) {
        if (colorNew == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        double[] dArray = colorNew.getRGBA();
        BasicFactory.put(jSONObject, "r", MathUtil.r3(dArray[0]));
        BasicFactory.put(jSONObject, "g", MathUtil.r3(dArray[1]));
        BasicFactory.put(jSONObject, "b", MathUtil.r3(dArray[2]));
        if (dArray[3] < 0.9995) {
            BasicFactory.put(jSONObject, "a", MathUtil.r3(dArray[3]));
        }
        return jSONObject;
    }

    public static JSONObject serializePaint(GradientPaintInfo gradientPaintInfo) {
        if (gradientPaintInfo == null) {
            return null;
        }
        if (gradientPaintInfo.getSolid() != null) {
            return FoundationJSONSerializer.serializeColor(gradientPaintInfo.getSolid());
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        if (gradientPaintInfo.getType() == 1003) {
            BasicFactory.put(jSONObject, "type", "radial");
            BasicFactory.put(jSONObject, "cx", MathUtil.r3(gradientPaintInfo.getCx()));
            BasicFactory.put(jSONObject, "cy", MathUtil.r3(gradientPaintInfo.getCy()));
            BasicFactory.put(jSONObject, "r", MathUtil.r3(gradientPaintInfo.getCr()));
        } else {
            BasicFactory.put(jSONObject, "type", "linear");
            BasicFactory.put(jSONObject, "x1", MathUtil.r3(gradientPaintInfo.getX1()));
            BasicFactory.put(jSONObject, "y1", MathUtil.r3(gradientPaintInfo.getY1()));
            BasicFactory.put(jSONObject, "x2", MathUtil.r3(gradientPaintInfo.getX2()));
            BasicFactory.put(jSONObject, "y2", MathUtil.r3(gradientPaintInfo.getY2()));
        }
        JSONArray jSONArray = BasicFactory.createJSONArray();
        float[] fArray = gradientPaintInfo.getOffsets();
        ColorNew[] colorNewArray = gradientPaintInfo.getColors();
        for (int i = 0; i < fArray.length; ++i) {
            JSONObject jSONObject2 = BasicFactory.createJSONObject();
            BasicFactory.put(jSONObject2, "offset", MathUtil.r3(fArray[i]));
            BasicFactory.put(jSONObject2, "color", FoundationJSONSerializer.serializeColor(colorNewArray[i]));
            BasicFactory.add(jSONArray, jSONObject2);
        }
        BasicFactory.put(jSONObject, "colors", jSONArray);
        return jSONObject;
    }

    public static JSONObject serializeStroke(Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        Number number = MathUtil.r3(stroke.getWidth());
        if (number.doubleValue() != 1.0) {
            BasicFactory.put(jSONObject, "width", number);
        }
        if (stroke.getDashing() != null) {
            BasicFactory.put(jSONObject, "style", stroke.getDashing());
        }
        if (stroke.getJoin() != null) {
            BasicFactory.put(jSONObject, "join", stroke.getJoin());
        }
        if (stroke.getCap() != null) {
            BasicFactory.put(jSONObject, "cap", stroke.getCap());
        }
        if (stroke.getColor() != null) {
            BasicFactory.put(jSONObject, "color", FoundationJSONSerializer.serializeColor(stroke.getColor()));
        }
        return jSONObject;
    }

    public static JSONObject serializeRenderEffects(RenderEffects renderEffects) {
        JSONObject jSONObject;
        if (renderEffects == null || renderEffects.getGlow() == null && renderEffects.getShadow() == null) {
            return null;
        }
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        JSONObject jSONObject3 = FoundationJSONSerializer.serializeRenderEffect(renderEffects.getGlow(), false);
        if (jSONObject3 != null) {
            BasicFactory.put(jSONObject2, "glow", jSONObject3);
        }
        if ((jSONObject = FoundationJSONSerializer.serializeRenderEffect(renderEffects.getShadow(), true)) != null) {
            BasicFactory.put(jSONObject2, "shadow", jSONObject);
        }
        return jSONObject2;
    }

    private static JSONObject serializeRenderEffect(RenderEffect renderEffect, boolean bl) {
        if (renderEffect == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        ColorNew colorNew = renderEffect.getColor();
        if (colorNew != null) {
            BasicFactory.put(jSONObject, "color", FoundationJSONSerializer.serializeColor(colorNew));
        }
        BasicFactory.put(jSONObject, "stdDev", renderEffect.getStdDev());
        if (bl) {
            BasicFactory.put(jSONObject, "dx", renderEffect.getDX());
            BasicFactory.put(jSONObject, "dy", renderEffect.getDY());
        }
        return jSONObject;
    }
}

