/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.NonBasicGeom;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GeomJSONSerializer {
    public static final String TYPE = "type";
    public static final String TYPE_LINE = "line";
    public static final String LINE_X1 = "x1";
    public static final String LINE_Y1 = "y1";
    public static final String LINE_X2 = "x2";
    public static final String LINE_Y2 = "y2";
    public static final String TYPE_RECT = "rect";
    public static final String RECT_X = "x";
    public static final String RECT_Y = "y";
    public static final String RECT_WIDTH = "width";
    public static final String RECT_HEIGHT = "height";
    public static final String TYPE_CIRCLE = "circle";
    public static final String CIRCLE_CX = "cx";
    public static final String CIRCLE_CY = "cy";
    public static final String CIRCLE_R = "r";
    public static final String TYPE_PATH = "path";
    public static final String PATH_PATH = "path";
    private static final String EMPTY_PATH = "M0,0";

    public static JSONObject serializeGeom(Geom geom) {
        BasicGeom basicGeom;
        if (geom == null) {
            return null;
        }
        if (geom instanceof Line) {
            return GeomJSONSerializer.serializeLine((Line)geom);
        }
        if (geom instanceof Rect) {
            return GeomJSONSerializer.serializeRect((Rect)geom);
        }
        if (geom instanceof Circle) {
            return GeomJSONSerializer.serializeCircle((Circle)geom);
        }
        if (geom instanceof Poly && ((Poly)(basicGeom = (Poly)geom)).getPointCount() == 2) {
            double[] dArray = ((Poly)basicGeom).getX();
            double[] dArray2 = ((Poly)basicGeom).getY();
            return GeomJSONSerializer.serializeLine(new Line(dArray[0], dArray2[0], dArray[1], dArray2[1]));
        }
        basicGeom = geom.getBounds();
        if (geom instanceof Poly || geom instanceof Curve) {
            return GeomJSONSerializer.serializePath((Rect)basicGeom, new Geom[]{geom});
        }
        if (geom instanceof CompositeGeom) {
            return GeomJSONSerializer.serializePath((Rect)basicGeom, ((CompositeGeom)geom).getParts());
        }
        if (geom instanceof NonBasicGeom) {
            return GeomJSONSerializer.serializeGeom(((NonBasicGeom)geom).asSimple());
        }
        throw new EngineException("Unknown Geom type passed to GeomJSONSerializer#serializeGeom", ErrorCode.ENGINE_BAD_GEOM, null);
    }

    private static JSONObject serializeLine(Line line) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, TYPE, TYPE_LINE);
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, LINE_X1, line.getX1());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, LINE_Y1, line.getY1());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, LINE_X2, line.getX2());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, LINE_Y2, line.getY2());
        return jSONObject;
    }

    private static JSONObject serializeRect(Rect rect) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, TYPE, TYPE_RECT);
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_X, rect.getX());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_Y, rect.getY());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_WIDTH, rect.getWidth());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_HEIGHT, rect.getHeight());
        return jSONObject;
    }

    private static JSONObject serializeCircle(Circle circle) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, TYPE, TYPE_CIRCLE);
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, CIRCLE_CX, circle.getX());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, CIRCLE_CY, circle.getY());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, CIRCLE_R, circle.getR());
        return jSONObject;
    }

    private static JSONObject serializePath(Rect rect, Geom[] geomArray) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, TYPE, "path");
        BasicFactory.put(jSONObject, "path", GeomJSONSerializer.serializePartsToSVGPath(geomArray));
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_X, rect.getX());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_Y, rect.getY());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_WIDTH, rect.getWidth());
        GeomJSONSerializer.checkNaNThenAdd(jSONObject, RECT_HEIGHT, rect.getHeight());
        return jSONObject;
    }

    private static void checkNaNThenAdd(JSONObject jSONObject, String string, double d) {
        if (Double.isNaN(d)) {
            BasicFactory.put(jSONObject, string, "NaN");
        } else {
            BasicFactory.put(jSONObject, string, MathUtil.r3(d));
        }
    }

    public static String serializePartsToSVGPath(Geom[] geomArray) {
        if (geomArray == null || geomArray.length == 0) {
            return EMPTY_PATH;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Geom geom : geomArray) {
            GeomJSONSerializer.serializeGeomToSVGPath(stringBuilder, geom);
        }
        String string = stringBuilder.toString();
        if (string.length() == 0) {
            return EMPTY_PATH;
        }
        return string;
    }

    private static void serializeGeomToSVGPath(StringBuilder stringBuilder, Geom geom) {
        if (geom == null) {
            return;
        }
        if (geom instanceof Line) {
            Line line = (Line)geom;
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'M', line.getX1(), line.getY1());
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'L', line.getX2(), line.getY2());
            return;
        }
        if (geom instanceof Rect) {
            Rect rect = (Rect)geom;
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'M', rect.getX(), rect.getY());
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'L', rect.getX2(), rect.getY());
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'L', rect.getX2(), rect.getY2());
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'L', rect.getX(), rect.getY2());
            stringBuilder.append('Z');
            return;
        }
        if (geom instanceof Circle) {
            GeomJSONSerializer.serializeCurveToSVGPath(stringBuilder, Curve.makeFromCircle((Circle)geom));
            return;
        }
        if (geom instanceof Poly) {
            GeomJSONSerializer.serializePolyToSVGPath(stringBuilder, (Poly)geom);
            return;
        }
        if (geom instanceof Curve) {
            GeomJSONSerializer.serializeCurveToSVGPath(stringBuilder, (Curve)geom);
            return;
        }
        if (geom instanceof CompositeGeom) {
            stringBuilder.append(GeomJSONSerializer.serializePartsToSVGPath(((CompositeGeom)geom).getParts()));
        }
        if (!(geom instanceof NonBasicGeom)) {
            throw new EngineException("Unknown Geom type passed to GeomJSONSerializer#serializeGeomToSVGPath", ErrorCode.ENGINE_BAD_GEOM, null);
        }
        GeomJSONSerializer.serializeGeomToSVGPath(stringBuilder, ((NonBasicGeom)geom).asSimple());
    }

    private static void serializePolyToSVGPath(StringBuilder stringBuilder, Poly poly) {
        double[] dArray = poly.getX();
        if (dArray == null || dArray.length == 0) {
            return;
        }
        double[] dArray2 = poly.getY();
        int n = dArray.length;
        GeomJSONSerializer.appendSVGControl(stringBuilder, 'M', dArray[0], dArray2[0]);
        for (int i = 1; i < n; ++i) {
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'L', dArray[i], dArray2[i]);
        }
        if (poly.filled()) {
            stringBuilder.append('Z');
        }
    }

    private static void serializeCurveToSVGPath(StringBuilder stringBuilder, Curve curve) {
        double[] dArray = curve.getX();
        if (dArray == null || dArray.length == 0) {
            return;
        }
        double[] dArray2 = curve.getY();
        boolean[] blArray = curve.getControls();
        int n = dArray.length;
        GeomJSONSerializer.appendSVGControl(stringBuilder, 'M', dArray[0], dArray2[0]);
        int n2 = 1;
        while (n2 < n) {
            if (!blArray[n2]) {
                GeomJSONSerializer.appendSVGControl(stringBuilder, 'L', dArray[n2], dArray2[n2]);
                ++n2;
                continue;
            }
            if (!blArray[n2 + 1]) {
                GeomJSONSerializer.appendSVGControl(stringBuilder, 'Q', dArray[n2], dArray2[n2]);
                GeomJSONSerializer.appendSVGControl(stringBuilder, ',', dArray[n2 + 1], dArray2[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (blArray[n2 + 2]) continue;
            GeomJSONSerializer.appendSVGControl(stringBuilder, 'C', dArray[n2], dArray2[n2]);
            GeomJSONSerializer.appendSVGControl(stringBuilder, ',', dArray[n2 + 1], dArray2[n2 + 1]);
            GeomJSONSerializer.appendSVGControl(stringBuilder, ',', dArray[n2 + 2], dArray2[n2 + 2]);
            n2 += 3;
        }
        if (curve.filled()) {
            stringBuilder.append('Z');
        }
    }

    private static void appendSVGControl(StringBuilder stringBuilder, char c, double d, double d2) {
        stringBuilder.append(c);
        stringBuilder.append(MathUtil.r3(d));
        stringBuilder.append(',');
        stringBuilder.append(MathUtil.r3(d2));
    }
}

