/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.CoordinatesSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SchemaSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.CoordinatesSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneNodeFactory {
    public static SceneNodeImpl createShapeNode(Shape shape) {
        SceneNodeImpl sceneNodeImpl = shape.getType() == 1010 ? new SchemaSceneNode(SceneNodeType.SCHEMA) : (shape.getType() == 1007 ? new SchemaSceneNode(SceneNodeType.MULTI_TEXT) : (shape.getType() == 1008 ? new SchemaSceneNode(SceneNodeType.MULTI_TEXT_LINE) : new SceneNodeImpl()));
        sceneNodeImpl.setShape(shape);
        return sceneNodeImpl;
    }

    public static GroupSceneNode createGroupNode(SceneNodeType sceneNodeType) {
        return new GroupSceneNode(sceneNodeType);
    }

    public static SceneNodeImpl createElementGroupNode(String string, Shape shape) {
        return new ElementGroupSceneNode(string, shape);
    }

    public static SceneNodeImpl createCoordinatesNode(Shape shape, CoordinatesSpec coordinatesSpec) {
        return new CoordinatesSceneNode(shape, coordinatesSpec);
    }

    public static SceneNodeImpl cloneNode(SceneNodeImpl sceneNodeImpl) {
        SceneNodeImpl sceneNodeImpl2 = null;
        SceneNodeClassId sceneNodeClassId = sceneNodeImpl.getClassId();
        sceneNodeImpl2 = sceneNodeClassId == SceneNodeClassId.GROUP ? SceneNodeFactory.createGroupNode(sceneNodeImpl.getType()) : (sceneNodeClassId == SceneNodeClassId.ELEMENT_GROUP ? ((ElementGroupSceneNode)sceneNodeImpl).copy() : (sceneNodeClassId == SceneNodeClassId.COORDINATES ? SceneNodeFactory.createCoordinatesNode((Shape)sceneNodeImpl.getShape(), ((CoordinatesSceneNode)sceneNodeImpl).getCoordinates()) : SceneNodeFactory.createShapeNode((Shape)sceneNodeImpl.getShape())));
        SceneNodeFactory.copyInfo(sceneNodeImpl2, sceneNodeImpl);
        return sceneNodeImpl2;
    }

    private static void copyInfo(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        sceneNodeImpl.setType(sceneNodeImpl2.getType());
        sceneNodeImpl.setOutOfBounds(sceneNodeImpl2.isOutOfBounds());
        sceneNodeImpl.setTransform((TransformInfoImpl)sceneNodeImpl2.getTransform());
        sceneNodeImpl.setParent(sceneNodeImpl2.getParent());
        sceneNodeImpl.setField(sceneNodeImpl2.getField());
        sceneNodeImpl.setClipBounds(sceneNodeImpl2.getClipBounds());
        sceneNodeImpl.setA11y(sceneNodeImpl2.getA11y());
        if (sceneNodeImpl2.getShape() != null) {
            Shape shape = ((Shape)sceneNodeImpl2.getShape()).makeGeometryClone();
            shape.copyInfoFrom((Shape)sceneNodeImpl2.getShape());
            sceneNodeImpl.setShape(shape);
        }
        sceneNodeImpl.setId(sceneNodeImpl2.getId());
        sceneNodeImpl.setValue(sceneNodeImpl2.getValue());
        if (sceneNodeImpl instanceof CompositeSceneNode) {
            for (SceneNode sceneNode : sceneNodeImpl2.getChildren()) {
                ((CompositeSceneNode)sceneNodeImpl).addChild(SceneNodeFactory.cloneNode((SceneNodeImpl)sceneNode));
            }
        }
    }
}

