/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.AnimateRendererInfo;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.internal.ScenePartInterpolator;
import com.ibm.vis.scenetree.internal.SimpleRendererInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.StyleInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneNodeImpl
implements SceneNode {
    private String id = null;
    private TransformInfoImpl transform = new TransformInfoImpl();
    private Rect clipBounds = null;
    private boolean outOfBounds = false;
    private Object customData = null;
    private Map<String, String> meta = null;
    private String field = null;
    private Object value = null;
    private AccessibleInfo a11y = null;
    protected Shape shape;
    private SceneNodeType type = null;
    private SceneNodeImpl parent;
    private SceneNodeRenderInfo renderInfo;
    private boolean temporarilyDirty = false;
    private boolean persistentlyDirty = false;
    private int dirtyChildCount = 0;
    private int zOrder = 0;
    private int initialZOrder = 0;
    private static final List<SceneNode> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());

    SceneNodeImpl() {
    }

    @Override
    public SceneNodeType getType() {
        return this.type;
    }

    public final void setType(SceneNodeType sceneNodeType) {
        this.type = sceneNodeType;
    }

    @Override
    public final ShapeInfo getShape() {
        return this.shape;
    }

    public final void setShape(Shape shape) {
        this.shape = shape;
        this.renderInfo = null;
    }

    @Override
    public final String getId() {
        if (this.shape != null) {
            return this.shape.getID();
        }
        return this.id;
    }

    public final void setId(String string) {
        if (this.shape != null) {
            this.shape.setID(string);
        } else {
            this.id = string;
        }
    }

    @Override
    public void translate(double d, double d2) {
        if (this.shape != null) {
            this.shape.getTransformInfo().translate(d, d2);
        } else {
            this.transform.translate(d, d2);
        }
    }

    @Override
    public void intTranslate(double d, double d2) {
        if (this.shape != null) {
            this.shape.getTransformInfo().intTranslate(d, d2);
        } else {
            this.transform.intTranslate(d, d2);
        }
    }

    public final void setClipBounds(Rect rect) {
        this.clipBounds = rect;
        this.renderInfo = null;
    }

    @Deprecated
    public final void setClipBoundsShapeRect(Rect rect) {
        double d = rect.getWidth();
        double d2 = rect.getHeight();
        double d3 = rect.getX();
        double d4 = rect.getY();
        this.clipBounds = new Rect(MathUtil.r3(d3).doubleValue(), MathUtil.r3(d4).doubleValue(), MathUtil.r3(d).doubleValue(), MathUtil.r3(d2).doubleValue());
        this.renderInfo = null;
    }

    @Override
    public final Rect getClipBounds() {
        if (this.getRenderInfo().getClipBounds() != null) {
            return this.getRenderInfo().getClipBounds();
        }
        return this.clipBounds;
    }

    @Override
    public final TransformInfo getTransform() {
        TransformInfo transformInfo = this.getRenderInfo().getTransform();
        if (transformInfo != null) {
            return transformInfo;
        }
        if (this.shape != null) {
            return this.shape.getTransformInfo();
        }
        return this.transform;
    }

    @Override
    public final boolean isVisible() {
        if (this.shape != null) {
            return this.shape.isVisible();
        }
        return true;
    }

    public final void setOutOfBounds(boolean bl) {
        this.outOfBounds = bl;
    }

    public final boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setMeta(String string, String string2) {
        if (this.shape != null) {
            this.shape.setMeta(string, string2);
            return;
        }
        if (string2 == null) {
            this.ensureMeta().remove(string);
        } else {
            this.ensureMeta().put(string, string2);
        }
    }

    @Override
    public String getMeta(String string) {
        if (this.shape != null) {
            return this.shape.getMeta(string);
        }
        return this.ensureMeta().get(string);
    }

    public Map<String, String> getMetaMap() {
        if (this.shape != null) {
            return this.shape.getMetaMap();
        }
        return this.meta;
    }

    private final Map<String, String> ensureMeta() {
        if (this.meta == null) {
            this.meta = new HashMap<String, String>();
        }
        return this.meta;
    }

    @Override
    public String getField() {
        if (this.shape != null) {
            return this.shape.getField();
        }
        return this.field;
    }

    public final void setField(String string) {
        if (this.shape != null) {
            this.shape.setField(string);
        } else {
            this.field = string;
        }
    }

    @Override
    public Object getValue() {
        if (this.shape != null) {
            return this.shape.getValue();
        }
        return this.value;
    }

    public final void setValue(Object object) {
        if (this.shape != null) {
            this.shape.setValue(object);
        } else {
            this.value = object;
        }
    }

    @Override
    public final Object getUserData() {
        return this.customData;
    }

    public final void setUserData(Object object) {
        this.customData = object;
    }

    public final AccessibleInfo getA11y() {
        if (this.shape != null) {
            return this.shape.getA11yInfo();
        }
        return this.a11y;
    }

    public final void setA11y(AccessibleInfo accessibleInfo) {
        this.a11y = accessibleInfo;
    }

    @Override
    public List<SceneNode> getChildren() {
        return EMPTY_LIST;
    }

    @Override
    public SceneNodeClassId getClassId() {
        return SceneNodeClassId.SHAPE;
    }

    public void setRows(int[] nArray) {
        if (this.shape != null) {
            this.shape.setRows(nArray);
        }
    }

    public void setTransform(TransformInfoImpl transformInfoImpl) {
        if (this.shape == null) {
            this.transform = transformInfoImpl;
        } else {
            Affine affine = transformInfoImpl == null ? null : transformInfoImpl.getAffine();
            this.shape.setTransform(affine);
        }
        this.renderInfo = null;
    }

    @Override
    @Deprecated
    public void clipTo(Rect rect) {
        this.setClipBoundsShapeRect(rect);
        this.renderInfo = null;
    }

    public void clearMetaMap() {
        Map<String, String> map = this.getMetaMap();
        if (map != null) {
            map.clear();
        }
    }

    public void finalizeTree(boolean bl, int n) {
        List<SceneNode> list = this.getChildren();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)list.get(i);
            sceneNodeImpl.setParent(this);
            int n3 = bl ? n : i;
            sceneNodeImpl.setInitialZOrder(n3);
            if (sceneNodeImpl.shape == null) {
                sceneNodeImpl.finalizeTree(false, 0);
                continue;
            }
            sceneNodeImpl.finalizeTree(true, n3);
        }
    }

    protected void setParent(SceneNodeImpl sceneNodeImpl) {
        this.parent = sceneNodeImpl;
    }

    public Affine getNetTransform() {
        TransformInfo transformInfo;
        Affine affine = null;
        if (this.parent != null) {
            affine = this.parent.getNetTransform();
        }
        if ((transformInfo = this.getTransform()) == null || transformInfo.getAffine() == null) {
            return affine;
        }
        if (affine == null) {
            return transformInfo.getAffine();
        }
        return affine.multiply(transformInfo.getAffine());
    }

    public SceneNodeImpl getParent() {
        return this.parent;
    }

    public SceneNodeRenderInfo getRenderInfo() {
        if (this.renderInfo == null) {
            this.renderInfo = new SimpleRendererInfo(this);
        }
        return this.renderInfo;
    }

    public void invalidateRenderInfo() {
        this.renderInfo = null;
    }

    public void putAnimateInfo(int n, ScenePartInterpolator scenePartInterpolator) {
        if (scenePartInterpolator == null) {
            this.removeAnimateInfo(n);
        } else {
            if (!this.getRenderInfo().canAnimate()) {
                this.renderInfo = new AnimateRendererInfo(this.renderInfo);
            }
            this.renderInfo.setAnimation(n, scenePartInterpolator);
        }
    }

    public void removeAnimateInfo(int n) {
        if (this.getRenderInfo().canAnimate() && this.renderInfo.setAnimation(n, null)) {
            this.renderInfo = this.renderInfo.getBase();
        }
    }

    public final void setTemporarilyDirty(boolean bl) {
        this.temporarilyDirty = bl;
    }

    public final boolean isTemporarilyDirty() {
        return this.temporarilyDirty;
    }

    public final void setPersistentlyDirty(boolean bl) {
        this.persistentlyDirty = bl;
    }

    public final boolean isPersistentlyDirty() {
        return this.persistentlyDirty;
    }

    public final void setDirtyChildCount(int n) {
        this.dirtyChildCount = n;
    }

    public final int getDirtyChildCount() {
        return this.dirtyChildCount;
    }

    public final boolean isDirtyDirectly() {
        return this.temporarilyDirty || this.persistentlyDirty;
    }

    public final boolean isDirtyIndirectly() {
        return this.dirtyChildCount > 0;
    }

    public final boolean isDirty() {
        return this.temporarilyDirty || this.persistentlyDirty || this.dirtyChildCount > 0;
    }

    public final int getRenderType() {
        SceneNodeRenderInfo sceneNodeRenderInfo = this.getRenderInfo();
        int n = 0;
        if (this.renderInfo.getRenderText() != null) {
            n = 7;
        } else {
            Geom geom = sceneNodeRenderInfo.getRenderGeom();
            if (geom != null) {
                switch (geom.type()) {
                    case 1001: {
                        n = 2;
                        break;
                    }
                    case 1007: {
                        n = 6;
                        break;
                    }
                    case 1004: {
                        n = 4;
                        break;
                    }
                    case 1000: {
                        n = 3;
                        break;
                    }
                    case 1003: {
                        n = 5;
                        break;
                    }
                    case 1002: {
                        n = 1;
                        break;
                    }
                    default: {
                        throw new EngineException("Unregonized geom for rendering.", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
                    }
                }
            }
        }
        return n;
    }

    public SceneNodeImpl getRoot() {
        SceneNodeImpl sceneNodeImpl = this.parent;
        if (sceneNodeImpl != null) {
            while (sceneNodeImpl.parent != null) {
                sceneNodeImpl = sceneNodeImpl.parent;
            }
        }
        return sceneNodeImpl;
    }

    public Point getScale() {
        Affine affine;
        double d = 1.0;
        double d2 = 1.0;
        if (this.transform != null && (affine = this.transform.getAffine()) != null) {
            d = Math.abs(affine.m00);
            d2 = Math.abs(affine.m11);
        }
        return new Point(d, d2);
    }

    @Override
    public Rect getPhysicalBounds() {
        SceneNodeRenderInfo sceneNodeRenderInfo = this.getRenderInfo();
        if (sceneNodeRenderInfo != null && this.shape != null) {
            if (this.shape instanceof Text) {
                return Shape.transformBounds(((Text)this.shape).getNonTransformedBounds(), this.getTransform().getAffine());
            }
            return Shape.transformBounds(this.shape.getBounds(), this.getTransform().getAffine());
        }
        return null;
    }

    public boolean isEffect() {
        String string = this.getId();
        return string != null && string.startsWith("_");
    }

    @Override
    public StyleInfo getRenderStyleInfo() {
        return this.getRenderInfo();
    }

    @Override
    public final int getZOrder() {
        return this.zOrder;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
        if (this.shape != null) {
            for (SceneNode sceneNode : this.getChildren()) {
                ((SceneNodeImpl)sceneNode).setZOrder(n);
            }
        }
    }

    public void resetZOrder() {
        this.zOrder = this.initialZOrder;
        if (this.shape != null) {
            for (SceneNode sceneNode : this.getChildren()) {
                ((SceneNodeImpl)sceneNode).resetZOrder();
            }
        }
    }

    public final int getInitialZOrder() {
        return this.initialZOrder;
    }

    public void setInitialZOrder(int n) {
        this.initialZOrder = n;
        this.zOrder = n;
        if (this.shape != null) {
            for (SceneNode sceneNode : this.getChildren()) {
                ((SceneNodeImpl)sceneNode).setInitialZOrder(n);
            }
        }
    }
}

