/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.CoordinatesSceneNode;
import com.ibm.vis.scenetree.internal.CoreJSONSerializer;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.FoundationJSONSerializer;
import com.ibm.vis.scenetree.internal.GeomJSONSerializer;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.internal.SchemaSceneNode;
import com.ibm.vis.scenetree.internal.TextJSONSerializer;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneNodeJSONSerializer {
    private static final JSONObject TRANSPARENT_FILL = BasicFactory.createJSONObject();
    public static final double MIN_DIMENSION = 4.656612875245797E-10;

    public static JSONArray serialize(SceneTree sceneTree) {
        String string;
        if (sceneTree == null) {
            return null;
        }
        JSONObject jSONObject = SceneNodeJSONSerializer.serializeNode(sceneTree.getRoot());
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONObject, "children");
        if (sceneTree.getLocalization() != null && (string = sceneTree.getLocalization().baseTextDirection) != null) {
            JSONObject jSONObject2 = BasicFactory.createJSONObject();
            BasicFactory.put(jSONObject2, "id", "localization");
            BasicFactory.put(jSONObject2, "baseTextDirection", string);
            BasicFactory.add(jSONArray, jSONObject2);
        }
        return jSONArray;
    }

    public static JSONObject serializeNode(SceneNode sceneNode) {
        SceneNodeClassId sceneNodeClassId = sceneNode.getClassId();
        if (sceneNodeClassId == SceneNodeClassId.SHAPE) {
            return SceneNodeJSONSerializer.serializeShapeNode((SceneNodeImpl)sceneNode);
        }
        if (sceneNodeClassId == SceneNodeClassId.SCHEMA_SHAPE) {
            return SceneNodeJSONSerializer.serializeSchemaNode((SchemaSceneNode)sceneNode);
        }
        if (sceneNodeClassId == SceneNodeClassId.COORDINATES) {
            return SceneNodeJSONSerializer.serializeCoordinatesNode((CoordinatesSceneNode)sceneNode);
        }
        if (sceneNodeClassId == SceneNodeClassId.GROUP) {
            return SceneNodeJSONSerializer.serializeGroupNode((GroupSceneNode)sceneNode);
        }
        if (sceneNodeClassId == SceneNodeClassId.ELEMENT_GROUP) {
            return SceneNodeJSONSerializer.serializeElementGroupNode((ElementGroupSceneNode)sceneNode);
        }
        throw new EngineException("Illegal SceneNodeType", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
    }

    private static JSONObject serializeShapeNode(SceneNodeImpl sceneNodeImpl) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        SceneNodeJSONSerializer.writeShapeProperties(sceneNodeImpl, jSONObject);
        SceneNodeJSONSerializer.writeNodeProperties(sceneNodeImpl, jSONObject);
        SceneNodeJSONSerializer.writeElementProperties(sceneNodeImpl, jSONObject);
        return jSONObject;
    }

    private static JSONObject serializeSchemaNode(SchemaSceneNode schemaSceneNode) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        SceneNodeType sceneNodeType = schemaSceneNode.getType();
        if (schemaSceneNode.getShape() instanceof MultiPartText && SceneNodeType.TITLE == sceneNodeType) {
            SceneNodeJSONSerializer.writeShapeProperties(schemaSceneNode, jSONObject);
            SceneNodeJSONSerializer.writeNodeProperties(schemaSceneNode, jSONObject);
            SceneNodeJSONSerializer.writeElementProperties(schemaSceneNode, jSONObject);
        } else {
            SceneNodeJSONSerializer.writeNodeProperties(schemaSceneNode, jSONObject);
            SceneNodeJSONSerializer.writeElementProperties(schemaSceneNode, jSONObject);
            SceneNodeJSONSerializer.writeChildren(schemaSceneNode, jSONObject);
            if (schemaSceneNode.getShape() instanceof Shape) {
                Shape shape = (Shape)schemaSceneNode.getShape();
                Rect rect = shape instanceof Text ? ((Text)shape).getNonTransformedBounds() : shape.getBounds();
                if (shape.getSnap()) {
                    SceneNodeJSONSerializer.writeRectToJson(jSONObject, Math.round(rect.getX()), Math.round(rect.getY()), Math.round(rect.getWidth()), Math.round(rect.getHeight()));
                } else {
                    SceneNodeJSONSerializer.writeRectToJson(jSONObject, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
                }
            }
        }
        return jSONObject;
    }

    private static JSONObject serializeCoordinatesNode(CoordinatesSceneNode coordinatesSceneNode) {
        TransformSpec[] transformSpecArray;
        JSONObject jSONObject = BasicFactory.createJSONObject();
        SceneNodeJSONSerializer.writeNodeProperties(coordinatesSceneNode, jSONObject);
        SceneNodeJSONSerializer.writeElementProperties(coordinatesSceneNode, jSONObject);
        SceneNodeJSONSerializer.writeShapeProperties(coordinatesSceneNode, jSONObject);
        CoordinatesSpec coordinatesSpec = coordinatesSceneNode.getCoordinates();
        if (coordinatesSpec == null) {
            coordinatesSpec = new CoordinatesSpec();
        }
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "coordinates", jSONObject2);
        DimensionSpec[] dimensionSpecArray = coordinatesSpec.dimensions;
        if (dimensionSpecArray != null) {
            transformSpecArray = BasicFactory.createJSONArray();
            BasicFactory.put(jSONObject2, "dimensions", transformSpecArray);
            for (DimensionSpec dimensionSpec : dimensionSpecArray) {
                ScaleSpec mappedJSONObject = dimensionSpec.scale;
                if (mappedJSONObject == null) {
                    BasicFactory.add((JSONArray)transformSpecArray, "linear");
                    continue;
                }
                SpanSpec[] spanSpecArray = mappedJSONObject.spans;
                if (spanSpecArray == null || spanSpecArray.length == 0) {
                    BasicFactory.add((JSONArray)transformSpecArray, "linear");
                    continue;
                }
                if (spanSpecArray.length == 1) {
                    String string = spanSpecArray[0].method;
                    BasicFactory.add((JSONArray)transformSpecArray, string);
                    continue;
                }
                BasicFactory.add((JSONArray)transformSpecArray, "multiple");
            }
        }
        if ((transformSpecArray = coordinatesSpec.transforms) != null) {
            DimensionSpec[] dimensionSpecArray2 = BasicFactory.createJSONArray();
            BasicFactory.put(jSONObject2, "transforms", dimensionSpecArray2);
            for (TransformSpec transformSpec : transformSpecArray) {
                BasicFactory.add((JSONArray)dimensionSpecArray2, transformSpec.type);
            }
        }
        return jSONObject;
    }

    private static JSONObject serializeGroupNode(GroupSceneNode groupSceneNode) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        SceneNodeJSONSerializer.writeNodeProperties(groupSceneNode, jSONObject);
        SceneNodeJSONSerializer.writeChildren(groupSceneNode, jSONObject);
        return jSONObject;
    }

    private static JSONObject serializeElementGroupNode(ElementGroupSceneNode elementGroupSceneNode) {
        Geom geom;
        JSONObject jSONObject = BasicFactory.createJSONObject();
        SceneNodeJSONSerializer.writeNodeProperties(elementGroupSceneNode, jSONObject);
        SceneNodeJSONSerializer.writeChildren(elementGroupSceneNode, jSONObject);
        String string = elementGroupSceneNode.getElementType();
        BasicFactory.put(jSONObject, "elementType", string);
        Geom geom2 = geom = elementGroupSceneNode.getBaseline() == null ? null : elementGroupSceneNode.getBaseline().getRenderGeom(0.0);
        if (geom != null) {
            JSONObject jSONObject2 = GeomJSONSerializer.serializeGeom(geom);
            BasicFactory.remove(jSONObject2, "type");
            BasicFactory.put(jSONObject, "baseline", jSONObject2);
        }
        return jSONObject;
    }

    private static void writeChildren(SceneNodeImpl sceneNodeImpl, JSONObject jSONObject) {
        List<SceneNode> list = sceneNodeImpl.getChildren();
        JSONArray jSONArray = BasicFactory.createSizedJSONArray(list.size());
        for (SceneNode sceneNode : list) {
            JSONObject jSONObject2 = SceneNodeJSONSerializer.serializeNode(sceneNode);
            BasicFactory.add(jSONArray, jSONObject2);
        }
        BasicFactory.put(jSONObject, "children", jSONArray);
    }

    private static void writeNodeProperties(SceneNodeImpl sceneNodeImpl, JSONObject jSONObject) {
        JSONObject jSONObject2;
        AccessibleInfo accessibleInfo;
        JSONObject jSONObject3;
        Object object;
        Object object2;
        Iterator<String> iterator;
        String string;
        Map<String, String> map;
        String string2;
        SceneNodeType sceneNodeType = sceneNodeImpl.getType();
        if (sceneNodeType != null) {
            if (SceneNodeType.IMAGE_HIGHLIGHT == sceneNodeType) {
                BasicFactory.put(jSONObject, "ImageHL", true);
            } else {
                BasicFactory.put(jSONObject, "type", SceneNodeTypeUtil.toString(sceneNodeType));
            }
        }
        if ((string2 = sceneNodeImpl.getId()) != null) {
            BasicFactory.put(jSONObject, "id", string2);
        }
        if (!sceneNodeImpl.isVisible()) {
            BasicFactory.put(jSONObject, "visible", false);
        }
        if ((map = sceneNodeImpl.getMetaMap()) != null && map.size() != 0) {
            string = BasicFactory.createJSONObject();
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = map.get(object2);
                BasicFactory.put(string, (String)object2, object);
            }
            BasicFactory.put(jSONObject, "meta", string);
        }
        if ((string = sceneNodeImpl.getField()) != null) {
            BasicFactory.put(jSONObject, "field", string);
        }
        if ((iterator = sceneNodeImpl.getValue()) != null) {
            BasicFactory.put(jSONObject, "value", iterator);
        }
        if ((object2 = sceneNodeImpl.getClipBounds()) != null) {
            object = BasicFactory.createJSONObject();
            SceneNodeJSONSerializer.writeRectToJson(object, ((Rect)object2).getX(), ((Rect)object2).getY(), ((Rect)object2).getWidth(), ((Rect)object2).getHeight());
            BasicFactory.put(jSONObject, "clip", object);
        }
        if ((jSONObject3 = CoreJSONSerializer.serializeAffine((Affine)(object = ((TransformInfoImpl)sceneNodeImpl.getTransform()).getAffine()))) != null) {
            BasicFactory.put(jSONObject, "transform", jSONObject3);
        }
        if ((accessibleInfo = sceneNodeImpl.getA11y()) != null && (jSONObject2 = CoreJSONSerializer.serializeA11y(accessibleInfo)) != null) {
            BasicFactory.put(jSONObject, "accessibility", jSONObject2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeElementProperties(SceneNodeImpl sceneNodeImpl, JSONObject jSONObject) {
        if (sceneNodeImpl.getShape() instanceof Shape) {
            Text text;
            String string;
            int[] nArray;
            Shape shape = (Shape)sceneNodeImpl.getShape();
            String string2 = shape.getKey();
            if (string2 != null) {
                BasicFactory.put(jSONObject, "key", string2);
            }
            if ((nArray = shape.getRows()) != null) {
                void var8_12;
                string = BasicFactory.createSizedJSONArray(nArray.length);
                BasicFactory.put(jSONObject, "rows", string);
                int[] object = nArray;
                int n = object.length;
                boolean bl = false;
                while (var8_12 < n) {
                    int n2 = object[var8_12];
                    BasicFactory.add((JSONArray)string, n2);
                    ++var8_12;
                }
                int[] nArray2 = shape.getOriginalRows();
                if (nArray2 != null) {
                    JSONArray jSONArray = BasicFactory.createJSONArray();
                    for (int n3 : nArray2) {
                        BasicFactory.add(jSONArray, n3);
                    }
                    if (BasicFactory.size(jSONArray) > 0) {
                        BasicFactory.put(jSONObject, "orows", jSONArray);
                    }
                }
            }
            if ((string = shape.getTooltip()) != null) {
                BasicFactory.put(jSONObject, "tooltip", string);
            } else if (shape instanceof Text && (string = (text = (Text)shape).getTruncatedTooltipText()) != null && text.isCreateTooltipForTruncated()) {
                BasicFactory.put(jSONObject, "tooltip", string);
            }
        }
    }

    private static void writeShapeProperties(SceneNodeImpl sceneNodeImpl, JSONObject jSONObject) {
        Object object;
        Object object2;
        if (!(sceneNodeImpl.getShape() instanceof Shape)) {
            return;
        }
        Shape shape = (Shape)sceneNodeImpl.getShape();
        SceneNodeRenderInfo sceneNodeRenderInfo = sceneNodeImpl.getRenderInfo();
        if (sceneNodeRenderInfo.getRenderGeom() != null) {
            object2 = GeomJSONSerializer.serializeGeom(sceneNodeRenderInfo.getRenderGeom());
            if (shape.getReversed() != null) {
                BasicFactory.put(object2, "reversed", shape.getReversed());
            }
            BasicFactory.put(jSONObject, "shape", object2);
        }
        if (sceneNodeRenderInfo.getRenderText() != null) {
            object2 = sceneNodeRenderInfo.getRenderText();
            object = TextJSONSerializer.serializeText((TextInfo)object2);
            BasicFactory.put(jSONObject, "shape", object);
            BasicFactory.put(jSONObject, "font", TextJSONSerializer.serializeTextFont((TextInfo)object2));
            BasicFactory.put(jSONObject, "align", object2.getTextAlign());
        }
        if (shape instanceof Text && (object = ((Text)(object2 = (Text)shape)).getTruncatedTooltipText()) != null && ((Text)object2).isCreateTooltipForTruncated()) {
            BasicFactory.put(jSONObject, "tooltip", object);
        }
        if (sceneNodeRenderInfo.getRenderStroke() != null) {
            BasicFactory.put(jSONObject, "stroke", FoundationJSONSerializer.serializeStroke(sceneNodeRenderInfo.getRenderStroke()));
        }
        if (sceneNodeRenderInfo.getRenderFill() != null) {
            BasicFactory.put(jSONObject, "fill", FoundationJSONSerializer.serializePaint(sceneNodeRenderInfo.getRenderFill()));
        } else if (shape.isFilled()) {
            BasicFactory.put(jSONObject, "fill", TRANSPARENT_FILL);
        }
        if (sceneNodeRenderInfo.getRenderEffects() != null) {
            BasicFactory.put(jSONObject, "effect", FoundationJSONSerializer.serializeRenderEffects(sceneNodeRenderInfo.getRenderEffects()));
        }
        if (sceneNodeRenderInfo.getRenderImage() != null && (object2 = CoreJSONSerializer.serializeImageFill(sceneNodeRenderInfo.getRenderImage())) != null) {
            BasicFactory.put(jSONObject, "image", object2);
        }
        if (shape.getGeom() instanceof Rect) {
            SceneNodeJSONSerializer.applyShapeRectHack(shape, jSONObject);
        } else if (shape.getGeom() instanceof Wedge) {
            SceneNodeJSONSerializer.addShapeWedgeArcCenter(shape.getCenter(), shape.getSnap(), jSONObject);
        }
    }

    private static void applyShapeRectHack(Shape shape, JSONObject jSONObject) {
        Object object = BasicFactory.getItem(jSONObject, "shape");
        if (object != null) {
            String string = BasicFactory.getItem(object, "height") + "";
            String string2 = BasicFactory.getItem(object, "width") + "";
            if (string != null && string2 != null && shape.getStroke() != null) {
                if (!shape.isInsideStroke()) {
                    if (Double.parseDouble(string) == 0.0) {
                        BasicFactory.put(object, "height", 4.656612875245797E-10);
                    }
                    if (Double.parseDouble(string2) == 0.0) {
                        BasicFactory.put(object, "width", 4.656612875245797E-10);
                    }
                } else if (Double.parseDouble(string) == 0.0 || Double.parseDouble(string2) == 0.0) {
                    BasicFactory.remove(jSONObject, "stroke");
                }
            }
        }
    }

    private static void addShapeWedgeArcCenter(Point point, boolean bl, JSONObject jSONObject) {
        Object object = BasicFactory.getItem(jSONObject, "shape");
        double d = point.getX();
        double d2 = point.getY();
        if (bl) {
            d = Math.round(d);
            d2 = Math.round(d2);
        }
        BasicFactory.put(object, "cx", MathUtil.r3(d));
        BasicFactory.put(object, "cy", MathUtil.r3(d2));
    }

    private static void writeRectToJson(JSONObject jSONObject, double d, double d2, double d3, double d4) {
        BasicFactory.put(jSONObject, "x", MathUtil.r3(d));
        BasicFactory.put(jSONObject, "y", MathUtil.r3(d2));
        BasicFactory.put(jSONObject, "width", MathUtil.r3(d3));
        BasicFactory.put(jSONObject, "height", MathUtil.r3(d4));
    }

    static {
        BasicFactory.put(TRANSPARENT_FILL, "a", 0.0);
    }
}

