/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.internal.ScenePartInterpolator;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SimpleRendererInfo
extends SceneNodeRenderInfo {
    private final SceneNode node;
    private Shape nodeShape = null;
    private Geom renderGeom = null;
    private TextInfo renderText = null;
    private GradientPaintInfo renderFill = null;
    private Stroke renderStroke = null;
    private RenderEffects renderEffects = null;
    private ImageFill renderImage = null;
    private Rect renderBounds = null;
    private boolean allowRenderInfoCalculations = true;

    public SimpleRendererInfo(SceneNode sceneNode) {
        this.node = sceneNode;
        this.nodeShape = (Shape)sceneNode.getShape();
        SceneNodeClassId sceneNodeClassId = sceneNode.getClassId();
        if (sceneNodeClassId != SceneNodeClassId.SHAPE && sceneNodeClassId != SceneNodeClassId.COORDINATES || this.nodeShape == null) {
            this.allowRenderInfoCalculations = false;
            return;
        }
    }

    @Override
    public final SceneNode getNode() {
        return this.node;
    }

    @Override
    public final Geom getRenderGeom() {
        if (this.renderGeom == null && this.allowRenderInfoCalculations) {
            double d = 0.0;
            Stroke stroke = this.getRenderStroke();
            if (this.nodeShape.isInsideStroke() && stroke != null) {
                d = stroke.getWidth() / 2.0;
            }
            this.renderGeom = this.nodeShape.getRenderGeom(d);
        }
        return this.renderGeom;
    }

    @Override
    public TextInfo getRenderText() {
        if (this.renderText == null && this.allowRenderInfoCalculations) {
            this.renderText = this.nodeShape.getTextInfo();
        }
        return this.renderText;
    }

    @Override
    public GradientPaintInfo getRenderFill() {
        if (this.renderFill == null && this.allowRenderInfoCalculations) {
            this.renderFill = SimpleRendererInfo.getFill(this.nodeShape);
        }
        return this.renderFill;
    }

    @Override
    public void setRenderFill(GradientPaintInfo gradientPaintInfo) {
        this.renderFill = gradientPaintInfo;
    }

    @Override
    public Stroke getRenderStroke() {
        if (this.renderStroke == null && this.allowRenderInfoCalculations) {
            this.renderStroke = SimpleRendererInfo.getStroke(this.nodeShape);
        }
        return this.renderStroke;
    }

    @Override
    public RenderEffects getRenderEffects() {
        if (this.renderEffects == null && this.allowRenderInfoCalculations) {
            this.renderEffects = this.nodeShape.getEffect();
        }
        return this.renderEffects;
    }

    @Override
    public ImageFill getRenderImage() {
        if (this.renderImage == null && this.allowRenderInfoCalculations) {
            this.renderImage = this.nodeShape.getImage() != null ? this.nodeShape.getImage().createFill() : null;
        }
        return this.renderImage;
    }

    @Override
    public Rect getRenderBounds() {
        if (this.renderBounds == null && this.allowRenderInfoCalculations) {
            this.renderBounds = SimpleRendererInfo.getBounds(this.nodeShape);
        }
        return this.renderBounds;
    }

    private static Rect getBounds(Shape shape) {
        Rect rect = shape instanceof Text ? ((Text)shape).getNonTransformedBounds() : shape.getBounds();
        if (shape.getSnap()) {
            return new Rect(Math.round(rect.getX()), Math.round(rect.getY()), Math.round(rect.getWidth()), Math.round(rect.getHeight()));
        }
        return rect;
    }

    private static GradientPaintInfo getFill(Shape shape) {
        if (shape.isFilled()) {
            Fill fill = shape.getFill();
            if (fill == null) {
                return null;
            }
            if (fill.getSolid() != null) {
                return GradientPaintInfo.makeSolid(fill.getSolid());
            }
            if (fill.getGradient() != null) {
                return fill.getGradient().makePaintInfo(shape.getLocalGradientGeometry(), shape.getGlobalGradientGeometry());
            }
        }
        return null;
    }

    private static Stroke getStroke(Shape shape) {
        Object object;
        Object object2;
        double d;
        double d2;
        Rect rect;
        Stroke stroke = shape.getStroke();
        if (shape.getGeom() instanceof Rect && stroke != null && shape.isInsideStroke() && (MathUtil.r3((rect = (Rect)shape.getGeom()).getWidth()).doubleValue() == 0.0 || MathUtil.r3(rect.getHeight()).doubleValue() == 0.0)) {
            return null;
        }
        if (stroke != null && stroke.getWidth() == 0.0) {
            return null;
        }
        double d3 = d2 = stroke == null ? 1.0 : stroke.getWidth();
        if (shape.isInsideStroke() && stroke != null && d2 >= (d = Math.min(((Rect)(object2 = shape.getBounds())).getWidth(), ((Rect)object2).getHeight()) / 2.0)) {
            d2 = d2 > 1.0 ? d + 1.0 : d;
            d2 = MathUtil.r3(d2 + 0.001).doubleValue();
        }
        if (d2 == 0.0) {
            return null;
        }
        object2 = ColorUtil.createDefaultColor();
        boolean bl = false;
        if (shape.isFilled()) {
            object = shape.getOutline();
            if (stroke != null || object != null) {
                bl = true;
                if (object != null) {
                    object2 = object;
                }
            }
        } else {
            object = shape.getFill();
            if (stroke != null || object != null) {
                bl = true;
                if (object != null && ((Fill)object).getSolid() != null) {
                    object2 = ((Fill)object).getSolid();
                }
            }
        }
        if (!bl) {
            return null;
        }
        object = stroke == null ? null : stroke.getDashing();
        Object object3 = stroke == null ? null : stroke.getJoin();
        String string = stroke == null ? null : stroke.getCap();
        return new Stroke(d2, (String)object, object3, string, (ColorNew)object2);
    }

    @Override
    public Rect getClipBounds() {
        return null;
    }

    @Override
    public TransformInfo getTransform() {
        return null;
    }

    @Override
    public boolean canAnimate() {
        return false;
    }

    @Override
    public boolean setAnimation(int n, ScenePartInterpolator scenePartInterpolator) {
        throw new EngineException("SimpleRendererInfo#setAnimation was called", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
    }

    @Override
    public SceneNodeRenderInfo getBase() {
        return null;
    }
}

