/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.scenetree.provisional.FontInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;

public class TextJSONSerializer {
    public static final String TYPE = "type";
    public static final String TYPE_TEXT = "text";
    public static final String TEXT_TEXT = "text";
    public static final String TEXT_ALIGN = "align";
    public static final String TEXT_X = "x";
    public static final String TEXT_Y = "y";
    public static final String TEXT_WIDTH = "width";
    public static final String TEXT_HEIGHT = "height";
    public static final String FONT_FAMILY = "family";
    public static final String FONT_SIZE = "size";
    public static final String FONT_ASCENT = "ascent";
    public static final String FONT_WEIGHT = "weight";
    public static final String FONT_STYLE = "style";

    public static JSONObject serializeText(TextInfo textInfo) {
        if (textInfo == null || textInfo.getText() == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, TYPE, "text");
        BasicFactory.put(jSONObject, "text", textInfo.getText());
        if (textInfo.getTextAlign() != null) {
            BasicFactory.put(jSONObject, TEXT_ALIGN, textInfo.getTextAlign());
        }
        Point point = textInfo.getAnchorPoint();
        BasicFactory.put(jSONObject, TEXT_X, MathUtil.r3(point.getX()));
        BasicFactory.put(jSONObject, TEXT_Y, MathUtil.r3(point.getY()));
        Dim dim = textInfo.getTextSize();
        BasicFactory.put(jSONObject, TEXT_WIDTH, MathUtil.r3(dim.getWidth()));
        BasicFactory.put(jSONObject, TEXT_HEIGHT, MathUtil.r3(dim.getHeight()));
        return jSONObject;
    }

    public static JSONObject serializeTextFont(TextInfo textInfo) {
        if (textInfo == null || textInfo.getFont() == null) {
            return null;
        }
        return TextJSONSerializer.serializeFont(textInfo.getFont(), textInfo.requiredPreciseAscent());
    }

    public static JSONObject serializeFont(FontInfo fontInfo, Double d) {
        if (fontInfo == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, FONT_FAMILY, fontInfo.getFamily());
        BasicFactory.put(jSONObject, FONT_SIZE, MathUtil.r3(fontInfo.getSize()) + "px");
        if (d != null) {
            BasicFactory.put(jSONObject, FONT_ASCENT, MathUtil.r3(d));
        } else {
            BasicFactory.put(jSONObject, FONT_ASCENT, MathUtil.r3(fontInfo.getAscent()));
        }
        if (fontInfo.getWeight() != null) {
            BasicFactory.put(jSONObject, FONT_WEIGHT, fontInfo.getWeight());
        }
        if (fontInfo.getStyle() != null) {
            BasicFactory.put(jSONObject, FONT_STYLE, fontInfo.getStyle());
        }
        return jSONObject;
    }
}

