/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.provisional;

import com.ibm.vis.scenetree.provisional.SceneNodeType;
import java.util.HashMap;
import java.util.Map;

public final class SceneNodeTypeUtil {
    private static String[] type2str;
    private static Map<String, SceneNodeType> str2type;

    private static void register(SceneNodeType sceneNodeType, String string) {
        SceneNodeTypeUtil.type2str[sceneNodeType.ordinal()] = string;
        str2type.put(string, sceneNodeType);
    }

    public static SceneNodeType fromString(String string) {
        return str2type.get(string);
    }

    public static String toString(SceneNodeType sceneNodeType) {
        return type2str[sceneNodeType.ordinal()];
    }

    public static boolean isAxis(SceneNodeType sceneNodeType) {
        return sceneNodeType == SceneNodeType.AXIS || sceneNodeType == SceneNodeType.AXIS_LABEL || sceneNodeType == SceneNodeType.AXIS_MARK || sceneNodeType == SceneNodeType.AXIS_MINOR || sceneNodeType == SceneNodeType.AXIS_BACK;
    }

    public static boolean isLegend(SceneNodeType sceneNodeType) {
        return sceneNodeType == SceneNodeType.LEGEND || sceneNodeType == SceneNodeType.LEGEND_ENTRY || sceneNodeType == SceneNodeType.LEGEND_CONTENT;
    }

    public static boolean isText(SceneNodeType sceneNodeType) {
        return sceneNodeType == SceneNodeType.TEXT || sceneNodeType == SceneNodeType.MULTI_TEXT || sceneNodeType == SceneNodeType.MULTI_TEXT_LINE;
    }

    static {
        SceneNodeType[] sceneNodeTypeArray = SceneNodeType.values();
        type2str = new String[sceneNodeTypeArray.length];
        str2type = new HashMap<String, SceneNodeType>(sceneNodeTypeArray.length, 1.0f);
        SceneNodeTypeUtil.register(SceneNodeType.AXIS, "axis");
        SceneNodeTypeUtil.register(SceneNodeType.AXIS_LABEL, "axis-label");
        SceneNodeTypeUtil.register(SceneNodeType.AXIS_MARK, "axis-mark");
        SceneNodeTypeUtil.register(SceneNodeType.AXIS_MINOR, "axis-minor");
        SceneNodeTypeUtil.register(SceneNodeType.AXIS_BACK, "axis-back");
        SceneNodeTypeUtil.register(SceneNodeType.LEGEND, "legend");
        SceneNodeTypeUtil.register(SceneNodeType.LEGEND_CONTENT, "legendContent");
        SceneNodeTypeUtil.register(SceneNodeType.LEGEND_ENTRY, "legendEntry");
        SceneNodeTypeUtil.register(SceneNodeType.TEXT, "text");
        SceneNodeTypeUtil.register(SceneNodeType.MULTI_TEXT, "multitext");
        SceneNodeTypeUtil.register(SceneNodeType.MULTI_TEXT_LINE, "linetext");
        SceneNodeTypeUtil.register(SceneNodeType.HIGHLIGHT, "highlight");
        SceneNodeTypeUtil.register(SceneNodeType.IMAGE_HIGHLIGHT, "imageHighlight");
        SceneNodeTypeUtil.register(SceneNodeType.TITLE, "title");
        SceneNodeTypeUtil.register(SceneNodeType.ELEMENT, "element");
        SceneNodeTypeUtil.register(SceneNodeType.FACET, "facet");
        SceneNodeTypeUtil.register(SceneNodeType.SCHEMA, "schema");
        SceneNodeTypeUtil.register(SceneNodeType.ROOT, "root");
        SceneNodeTypeUtil.register(SceneNodeType.SCENE, "scene");
    }
}

