/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.scenetree.provisional;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.LocalizationSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneTree {
    private CompositeSceneNode root = SceneNodeFactory.createGroupNode(null);
    private LocalizationSpec localization = null;
    private Dim sceneSize = new Dim(0.0, 0.0);
    private Map<String, SceneNode> idMap = null;

    public void copyInfoFrom(SceneTree sceneTree) {
        if (sceneTree == null || sceneTree == this) {
            return;
        }
        this.localization = sceneTree.localization;
        this.sceneSize = new Dim(sceneTree.sceneSize.getWidth(), sceneTree.sceneSize.getHeight());
        Affine affine = sceneTree.root.getTransform().getAffine();
        if (affine == null) {
            affine = Affine.identity();
        }
        ((TransformInfoImpl)this.root.getTransform()).setAffine(affine);
    }

    public final SceneTree finalizeTree() {
        this.root.finalizeTree(false, 0);
        return this;
    }

    public final CompositeSceneNode getRoot() {
        return this.root;
    }

    public final void setLocalization(LocalizationSpec localizationSpec) {
        this.localization = localizationSpec;
    }

    public final LocalizationSpec getLocalization() {
        return this.localization;
    }

    public final void setSize(Dim dim) {
        this.sceneSize = new Dim(dim.getWidth(), dim.getHeight());
    }

    public final Dim getSize() {
        return this.sceneSize;
    }

    public final Dim getScaledSize() {
        Dim dim = this.getSize();
        Point point = this.root.getScale();
        return new Dim(dim.getWidth() * point.getX(), dim.getHeight() * point.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SceneNode> getIDMap() {
        SceneTree sceneTree = this;
        synchronized (sceneTree) {
            if (this.idMap == null) {
                this.idMap = new HashMap<String, SceneNode>();
                this.buildIDMap(this.root);
            }
        }
        return this.idMap;
    }

    private void buildIDMap(SceneNode sceneNode) {
        if (sceneNode != null) {
            String string = sceneNode.getId();
            if (string != null) {
                this.idMap.put(string, sceneNode);
            }
            for (SceneNode sceneNode2 : sceneNode.getChildren()) {
                this.buildIDMap(sceneNode2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneNode findNode(String string) {
        SceneNode sceneNode;
        if (string == null) {
            return null;
        }
        SceneTree sceneTree = this;
        synchronized (sceneTree) {
            sceneNode = this.getIDMap().get(string);
        }
        return sceneNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeID(SceneNode sceneNode) {
        String string = sceneNode.getId();
        if (string != null) {
            SceneTree sceneTree = this;
            synchronized (sceneTree) {
                this.getIDMap().put(string, sceneNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeID(SceneNode sceneNode) {
        String string = sceneNode.getId();
        if (string != null) {
            SceneTree sceneTree = this;
            synchronized (sceneTree) {
                this.getIDMap().remove(string);
            }
        }
    }

    public Set<String> getAllNodeIDs() {
        return this.getIDMap().keySet();
    }
}

