/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.services;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.VisException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.services.internal.GetLayerNamesGeneratedImpl;
import com.ibm.vis.services.internal.GetLayerNamesUtilities;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/utilities")
public class GetLayerNames {
    public static final int OPTIONS_INCLUDE_SAMPLE_DATA_PROVIDERS = 1;
    public static final int OPTIONS_SUPPORT_SPEC_MIGRATION = 2;
    public static final int OPTIONS_SUPPORT_SPEC_VALIDATION = 4;
    public static final int OPTIONS_SUPPORT_TEMPLATES = 8;
    public static final int OPTIONS_SUPPORT_HIGH_CONTRAST = 16;
    public static final int OPTIONS_SUPPORT_INTERACTIVITY = 32;
    private final GetLayerNamesUtilities helper = new GetLayerNamesUtilities();
    private final GetLayerNamesGeneratedImpl impl = new GetLayerNamesGeneratedImpl(this.helper);
    private static final String[] NO_LAYERS = new String[0];

    public void dispose() {
        this.helper.dispose();
    }

    public void setSpecificationDefaultVersion(String string) {
        this.impl.setSpecificationDefaultVersion(string);
    }

    public String[] getRequiredLayers(JSONObject jSONObject, int n) throws VisException {
        if (jSONObject == null) {
            return NO_LAYERS;
        }
        Set<String> set = this.impl.getRequiredLayers(jSONObject, n);
        if (set.size() == 0) {
            return NO_LAYERS;
        }
        return this.helper.toArray(set);
    }

    public String[] getRequiredLayersFromArray(JSONObject[] jSONObjectArray, int n) throws VisException {
        if (jSONObjectArray == null || jSONObjectArray.length == 0) {
            return NO_LAYERS;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (JSONObject jSONObject : jSONObjectArray) {
            Set<String> set = this.impl.getRequiredLayers(jSONObject, n);
            hashSet.addAll(set);
        }
        if (hashSet.size() == 0) {
            return NO_LAYERS;
        }
        return this.helper.toArray(hashSet);
    }

    public String[] getRequiredLayersForSpec(String string, int n) throws VisException {
        Set<String> set;
        if (string == null) {
            return NO_LAYERS;
        }
        try {
            JSONObject jSONObject = BasicFactory.parse(string);
            set = this.impl.getRequiredLayers(jSONObject, n);
        }
        catch (IOException iOException) {
            throw new SpecException("Error parsing/analyzing VizJSON", ErrorCode.SPEC_PARSE_FAIL, string);
        }
        if (set.size() == 0) {
            return NO_LAYERS;
        }
        return this.helper.toArray(set);
    }

    public String[] getRequiredLayersFromSpecArray(String[] stringArray, int n) throws VisException {
        if (stringArray == null || stringArray.length == 0) {
            return NO_LAYERS;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            try {
                JSONObject jSONObject = BasicFactory.parse(string);
                Set<String> set = this.impl.getRequiredLayers(jSONObject, n);
                hashSet.addAll(set);
            }
            catch (IOException iOException) {
                throw new SpecException("Error parsing/analyzing VizJSON", ErrorCode.SPEC_PARSE_FAIL, string);
            }
        }
        return this.helper.toArray(hashSet);
    }
}

