/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.services;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.migration.spec.SpecMigration;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.VisException;
import com.ibm.vis.exceptions.internal.SchemaValidationException;
import com.ibm.vis.internal.json.Diagnostic;
import com.ibm.vis.internal.json.SchemaValidator;
import com.ibm.vis.internal.json.SpecValidator;
import java.io.IOException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/migrationLayer")
public final class MigrationService {
    public static JSONObject getMigratedSpecification(JSONObject jSONObject, boolean bl) throws IOException, VisException {
        JSONObject jSONObject2 = (JSONObject)BasicFactory.deepClone(jSONObject);
        boolean bl2 = false;
        if (bl) {
            bl2 = MigrationService.validateSpecification(jSONObject2);
        }
        if ((SpecMigration.getInstance().migrate((JSONArtifact)jSONObject2) || bl2) && bl) {
            MigrationService.validateSpecification(jSONObject2);
        }
        return jSONObject2;
    }

    public static JSONObject getMigratedSpecificationFromString(String string, boolean bl) throws IOException, VisException {
        return MigrationService.getMigratedSpecification(BasicFactory.parse(string), bl);
    }

    private static boolean validateSpecification(JSONObject jSONObject) throws VisException {
        boolean bl = false;
        Diagnostic diagnostic = SpecValidator.validate(jSONObject);
        if (diagnostic.getSeverity() == 1) {
            SchemaValidator.fixWarnings(diagnostic);
            bl = diagnostic.getCode() == 1001;
        } else if (diagnostic.getSeverity() == 2) {
            throw new SchemaValidationException(diagnostic.toString(), ErrorCode.SPEC_INVALID_VALUE, null, diagnostic);
        }
        return bl;
    }
}

