/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.services;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.configuration.IVisConfiguration;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.VisException;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.HitDetection;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionFilter;
import com.ibm.vis.internal.renderer.Renderer;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.services.internal.VisImageServicePDFUtils;
import com.ibm.vis.ui.awt.VisControl;
import com.ibm.vis.ui.awt.internal.render.AWTGraphicsRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisImageService {
    private static final String[] SUPPORTED_FORMATS = new String[]{"bmp", "gif", "jpeg", "jpg", "png"};

    public static String[] getSupportedImageFormats() {
        return Arrays.copyOf(SUPPORTED_FORMATS, SUPPORTED_FORMATS.length);
    }

    public static boolean isImageFormatSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        for (String string3 : SUPPORTED_FORMATS) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static Image makeImageWithoutAlpha(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image getImage(JSONObject jSONObject, String string, Color color, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.getImage(jSONObject, string, color, null, 1.0, iVisConfiguration);
    }

    public static Image getImage(JSONObject jSONObject, String string, Color color, Dim dim, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.getImage(jSONObject, string, color, dim, 1.0, iVisConfiguration);
    }

    public static Image getImage(JSONObject jSONObject, String string, Color color, double d, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.getImage(jSONObject, string, color, null, d, iVisConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(JSONObject jSONObject, String string, Color color, Dim dim, double d, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        VisControl visControl;
        VisImageService.checkArguments(jSONObject, string, dim, d);
        boolean bl = false;
        if (iVisConfiguration instanceof VisControl) {
            visControl = (VisControl)iVisConfiguration;
        } else {
            visControl = new VisControl(null, null);
            visControl.copyConfigurationFrom(iVisConfiguration);
            bl = true;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = VisImageService.makeImage(visControl, jSONObject, string, color, dim, d);
        }
        finally {
            if (bl) {
                visControl.dispose();
            }
        }
        return bufferedImage;
    }

    public static Image generateImage(JSONObject jSONObject, OutputStream outputStream, String string, Color color, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.generateImage(jSONObject, outputStream, string, color, null, 1.0, iVisConfiguration);
    }

    public static Image generateImage(JSONObject jSONObject, OutputStream outputStream, String string, Color color, Dim dim, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.generateImage(jSONObject, outputStream, string, color, dim, 1.0, iVisConfiguration);
    }

    public static Image generateImage(JSONObject jSONObject, OutputStream outputStream, String string, Color color, double d, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.generateImage(jSONObject, outputStream, string, color, null, d, iVisConfiguration);
    }

    public static Image generateImage(JSONObject jSONObject, OutputStream outputStream, String string, Color color, Dim dim, double d, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        BufferedImage bufferedImage = (BufferedImage)VisImageService.getImage(jSONObject, string, color, dim, d, iVisConfiguration);
        VisImageService.writeImage(bufferedImage, string, outputStream);
        return bufferedImage;
    }

    public static Image createPDF(JSONObject jSONObject, OutputStream outputStream, Color color, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.createPDF(jSONObject, outputStream, color, null, 1.0, iVisConfiguration);
    }

    public static Image createPDF(JSONObject jSONObject, OutputStream outputStream, Color color, Dim dim, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.createPDF(jSONObject, outputStream, color, dim, 1.0, iVisConfiguration);
    }

    public static Image createPDF(JSONObject jSONObject, OutputStream outputStream, Color color, double d, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.createPDF(jSONObject, outputStream, color, null, d, iVisConfiguration);
    }

    public static Image createPDF(JSONObject jSONObject, OutputStream outputStream, Color color, Dim dim, double d, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        BufferedImage bufferedImage = (BufferedImage)VisImageService.getImage(jSONObject, "png", color, dim, d, iVisConfiguration);
        if (outputStream != null) {
            VisImageServicePDFUtils.writePDFImage(outputStream, bufferedImage);
        }
        return bufferedImage;
    }

    public static SceneItem[] generateImageWithImageMap(JSONObject jSONObject, OutputStream outputStream, String string, Color color, String[] stringArray, String[] stringArray2, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.generateImageWithImageMap(jSONObject, outputStream, string, color, null, 1.0, stringArray, stringArray2, iVisConfiguration);
    }

    public static SceneItem[] generateImageWithImageMap(JSONObject jSONObject, OutputStream outputStream, String string, Color color, Dim dim, String[] stringArray, String[] stringArray2, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.generateImageWithImageMap(jSONObject, outputStream, string, color, dim, 1.0, stringArray, stringArray2, iVisConfiguration);
    }

    public static SceneItem[] generateImageWithImageMap(JSONObject jSONObject, OutputStream outputStream, String string, Color color, double d, String[] stringArray, String[] stringArray2, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        return VisImageService.generateImageWithImageMap(jSONObject, outputStream, string, color, null, d, stringArray, stringArray2, iVisConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SceneItem[] generateImageWithImageMap(JSONObject jSONObject, OutputStream outputStream, String string, Color color, Dim dim, double d, String[] stringArray, String[] stringArray2, IVisConfiguration iVisConfiguration) throws IOException, VisException {
        VisControl visControl;
        VisImageService.checkArguments(jSONObject, string, dim, d);
        boolean bl = false;
        if (iVisConfiguration instanceof VisControl) {
            visControl = (VisControl)iVisConfiguration;
        } else {
            visControl = new VisControl(null, null);
            visControl.copyConfigurationFrom(iVisConfiguration);
            bl = true;
        }
        SceneItem[] sceneItemArray = null;
        try {
            BufferedImage bufferedImage = VisImageService.makeImage(visControl, jSONObject, string, color, dim, d);
            VisImageService.writeImage(bufferedImage, string.toLowerCase(), outputStream);
            sceneItemArray = VisImageService.getSceneItemsForImageMap(visControl, stringArray, stringArray2);
        }
        finally {
            if (bl) {
                visControl.dispose();
            }
        }
        return sceneItemArray;
    }

    private static void checkArguments(JSONObject jSONObject, String string, Dim dim, double d) throws VisException {
        if (jSONObject == null) {
            throw new EngineException("The specification passed to VisImageService was null", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (string == null) {
            throw new EngineException("The image format passed to VisImageService was null", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (!VisImageService.isImageFormatSupported(string)) {
            throw new EngineException("The image format '" + string + "' is not supported by VisImageService", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (dim != null && (dim.getWidth() <= 0.0 || dim.getHeight() <= 0.0)) {
            throw new EngineException("The size passed to VisImageService was illegal (both width and height must be positive)", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (d <= 0.0) {
            throw new EngineException("The zoom passed to VisImageService was illegal (must be positive)", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage makeImage(VisControl visControl, JSONObject jSONObject, String string, Color color, Dim dim, double d) throws IOException, VisException {
        int n;
        int n2;
        Object object;
        Object object2;
        SceneTree sceneTree2;
        JSONObject jSONObject2 = jSONObject;
        if (dim != null) {
            jSONObject2 = new JSONObject();
            for (SceneTree sceneTree2 : jSONObject.keySet()) {
                jSONObject2.put((Object)sceneTree2, jSONObject.get((Object)sceneTree2));
            }
            object2 = new JSONObject();
            object2.put((Object)"width", (Object)new Double(dim.getWidth()));
            object2.put((Object)"height", (Object)new Double(dim.getHeight()));
            jSONObject2.put((Object)"size", object2);
        }
        object2 = visControl.getVis().setSpecification(jSONObject2);
        sceneTree2 = visControl.getVis().makeSceneTree(dim, (VisState)object2).getSceneTree();
        visControl.setScene(sceneTree2);
        if (d != 1.0) {
            object = (TransformInfoImpl)sceneTree2.getRoot().getTransform();
            Affine affine = ((TransformInfoImpl)object).getAffine();
            affine = affine == null ? new Affine(d, 0.0, 0.0, 0.0, d, 0.0) : affine.scale(d);
            ((TransformInfoImpl)object).setAffine(affine);
        }
        if ((n2 = (int)((Dim)(object = sceneTree2.getScaledSize())).getWidth()) <= 0) {
            n2 = 1;
        }
        if ((n = (int)((Dim)object).getHeight()) <= 0) {
            n = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n2, n);
        } else if (!VisImageService.formatSupportsTransparency(string)) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n2, n);
        }
        AWTGraphicsRenderer aWTGraphicsRenderer = new AWTGraphicsRenderer(graphics2D, n2, n, false);
        try {
            Renderer.render(aWTGraphicsRenderer, sceneTree2, null);
        }
        catch (VisException visException) {
            throw visException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            aWTGraphicsRenderer.dispose();
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private static boolean formatSupportsTransparency(String string) {
        return "png".equals(string.toLowerCase());
    }

    private static void writeImage(BufferedImage bufferedImage, String string, OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            BufferedImage bufferedImage2 = bufferedImage;
            String string2 = string.toLowerCase();
            if (string2.equals("bmp") || string2.equals("jpeg") || string2.equals("jpg")) {
                bufferedImage2 = (BufferedImage)VisImageService.makeImageWithoutAlpha(bufferedImage);
            }
            ImageIO.write((RenderedImage)bufferedImage2, string2, outputStream);
        }
    }

    private static SceneItem[] getSceneItemsForImageMap(VisControl visControl, String[] stringArray, String[] stringArray2) {
        SceneItem[] sceneItemArray;
        Vis vis = visControl.getVis();
        HitDetection hitDetection = new HitDetection(vis, visControl.getSceneTree());
        for (SceneItem sceneItem : sceneItemArray = hitDetection.getFilteredItems(new ImageMapFilter(stringArray, stringArray2))) {
            ((SceneItemImpl)sceneItem).decorateItem(vis, 0.0, 0.0);
        }
        ArrayList<SceneItem> arrayList = new ArrayList<SceneItem>();
        ArrayList<SceneItem> arrayList2 = new ArrayList<SceneItem>();
        ArrayList<SceneItem> arrayList3 = new ArrayList<SceneItem>();
        for (SceneItem sceneItem : sceneItemArray) {
            SceneItemImpl sceneItemImpl = (SceneItemImpl)sceneItem;
            VisImageService.addSceneItemToLists((SceneItemImpl)sceneItem, arrayList, arrayList2, arrayList3);
            if (sceneItemImpl.getHitChildren() == null) continue;
            for (SceneItem sceneItem2 : sceneItem.getHitChildren()) {
                VisImageService.addSceneItemToLists((SceneItemImpl)sceneItem2, arrayList, arrayList2, arrayList3);
            }
        }
        ArrayList<SceneItem> arrayList4 = new ArrayList<SceneItem>();
        arrayList4.addAll(arrayList);
        arrayList4.addAll(arrayList2);
        arrayList4.addAll(arrayList3);
        return arrayList4.toArray(new SceneItem[arrayList4.size()]);
    }

    private static void addSceneItemToLists(SceneItemImpl sceneItemImpl, ArrayList<SceneItem> arrayList, ArrayList<SceneItem> arrayList2, ArrayList<SceneItem> arrayList3) {
        String string = sceneItemImpl.getID();
        if (string == null) {
            return;
        }
        Shape shape = (Shape)sceneItemImpl.getSceneNode().getShape();
        if (shape == null || shape instanceof Schema) {
            return;
        }
        if (SceneIdUtil.isFaceted(string)) {
            arrayList.add(sceneItemImpl);
        } else if (SceneIdUtil.isAxisID(string)) {
            arrayList2.add(sceneItemImpl);
        } else {
            arrayList3.add(sceneItemImpl);
        }
    }

    private static class ImageMapFilter
    implements HitDetectionFilter {
        private final String[] types;
        private final String[] subtypes;

        ImageMapFilter(String[] stringArray, String[] stringArray2) {
            this.types = stringArray;
            this.subtypes = stringArray2;
        }

        @Override
        public boolean matches(SceneNode sceneNode) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneNode;
            String string = sceneNodeImpl.getId();
            if (string == null || SceneIdUtil.isBackId(string) || SceneIdUtil.isCoordsId(string) || SceneIdUtil.isOutId(string) || SceneIdUtil.isStrokeId(string)) {
                return false;
            }
            if (this.types == null || this.types.length == 0) {
                return true;
            }
            String string2 = SceneItemImpl.getSceneType(string);
            boolean bl = false;
            for (int i = 0; !bl && i < this.types.length; ++i) {
                if (!string2.equals(this.types[i])) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            if (this.subtypes == null || this.subtypes.length == 0) {
                return true;
            }
            String string3 = SceneItemImpl.getSceneSubType(string, sceneNodeImpl);
            bl = false;
            for (int i = 0; !bl && i < this.subtypes.length; ++i) {
                if (!string3.equals(this.subtypes[i])) continue;
                bl = true;
            }
            return bl;
        }
    }
}

