/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.services;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.util.SceneTreeUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.internal.renderer.Renderer;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.SizeSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import com.ibm.vis.ui.awt.AreaShape;
import com.ibm.vis.ui.awt.RaveMainType;
import com.ibm.vis.ui.awt.RaveSubType;
import com.ibm.vis.ui.awt.VisControl;
import com.ibm.vis.ui.awt.internal.ImageMap;
import com.ibm.vis.ui.awt.internal.render.AWTGraphicsRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

@Deprecated
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisService {
    private static final List<String> formats = new ArrayList<String>();
    private static final String JPEG = VisService.createImageFormat("jpeg");
    private static final String JPG = VisService.createImageFormat("jpg");
    private static final String PNG = VisService.createImageFormat("png");
    private static final String GIF = VisService.createImageFormat("gif");
    private static final String BMP = VisService.createImageFormat("bmp");
    private static List<String> supportedFormats = null;
    private static Color DEFAULT_BACK_COLOR = Color.WHITE;

    @Deprecated
    public static void generateImage(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, Dim dim, Color color) throws IOException {
        VisService.generateImage(visJSONSpec, outputStream, string, dim, color, null);
    }

    public static void generateImage(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, Dim dim, Color color, VisControl visControl) throws IOException {
        Vis vis;
        VisService.validateInputs(visJSONSpec, outputStream, string, "Error in VisService.generateImage(VisJSONSpec, OutputStream, ImageFormat, ImageSize, Color, VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, dim, vis);
        VisService.generateImageFromSceneTree(outputStream, string, color, sceneTree);
        if (bl) {
            vis.dispose();
        }
    }

    @Deprecated
    public static void generateImage(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, Color color) throws IOException {
        VisService.generateImage(visJSONSpec, outputStream, string, color, null);
    }

    public static void generateImage(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, Color color, VisControl visControl) throws IOException {
        VisService.validateInputs(visJSONSpec, outputStream, string, "Error in VisService.generateImage(VisJSONSpec, OutputStream, ImageFormat, Color, VisControl) api");
        VisService.generateImage(visJSONSpec, outputStream, string, null, color, visControl);
    }

    @Deprecated
    public static void generateImage(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, double d, Color color) throws IOException {
        VisService.generateImage(visJSONSpec, outputStream, string, d, color, null);
    }

    public static void generateImage(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, double d, Color color, VisControl visControl) throws IOException {
        Vis vis;
        VisService.validateInputs(visJSONSpec, outputStream, string, "Error in VisService.generateImage(VisJSONSpec, OutputStream, ImageFormat, zoom, Color, VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, null, vis);
        SceneTreeUtil.scaleBy(sceneTree, d);
        VisService.generateImageFromSceneTree(outputStream, string, color, sceneTree);
        if (bl) {
            vis.dispose();
        }
    }

    @Deprecated
    public static RenderedImage getImage(VisJSONSpec visJSONSpec, String string, Dim dim, Color color) {
        return VisService.getImage(visJSONSpec, string, dim, color, null);
    }

    public static RenderedImage getImage(VisJSONSpec visJSONSpec, String string, Dim dim, Color color, VisControl visControl) {
        Vis vis;
        VisService.validateInputs(visJSONSpec, string, "Error in VisService.getImage(VisJSONSpec, imageFormat, imageSize, Color, VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, dim, vis);
        BufferedImage bufferedImage = VisService.createBufferedImage(string, color, sceneTree);
        VisService.drawScene(sceneTree, bufferedImage);
        if (bl) {
            vis.dispose();
        }
        return bufferedImage;
    }

    @Deprecated
    public static RenderedImage getImage(VisJSONSpec visJSONSpec, String string, Color color) {
        return VisService.getImage(visJSONSpec, string, null, color, null);
    }

    public static RenderedImage getImage(VisJSONSpec visJSONSpec, String string, Color color, VisControl visControl) {
        VisService.validateInputs(visJSONSpec, string, "Error in VisService.getImage(VisJSONSpec, imageFormat, Color, VisControl) api");
        return VisService.getImage(visJSONSpec, string, null, color, visControl);
    }

    @Deprecated
    public static RenderedImage getImage(VisJSONSpec visJSONSpec, String string, double d, Color color) {
        return VisService.getImage(visJSONSpec, string, d, color, null);
    }

    public static RenderedImage getImage(VisJSONSpec visJSONSpec, String string, double d, Color color, VisControl visControl) {
        Vis vis;
        VisService.validateInputs(visJSONSpec, string, "Error in VisService.getImage(VisJSONSpec, imageFormat, zoom, Color, VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, null, vis);
        SceneTreeUtil.scaleBy(sceneTree, d);
        BufferedImage bufferedImage = VisService.createBufferedImage(string, color, sceneTree);
        VisService.drawScene(sceneTree, bufferedImage);
        if (bl) {
            vis.dispose();
        }
        return bufferedImage;
    }

    public static boolean isImageFormatSupported(String string) {
        if (string == null) {
            return false;
        }
        return VisService.getSupportedFormats().contains(string.toLowerCase());
    }

    public static final List<String> getSupportedFormats() {
        if (supportedFormats == null) {
            supportedFormats = VisService.buildSupportedFormats();
        }
        return supportedFormats;
    }

    @Deprecated
    public static void createPDF(VisJSONSpec visJSONSpec, ByteArrayOutputStream byteArrayOutputStream, double d, Color color) throws IOException {
        VisService.createPDF(visJSONSpec, byteArrayOutputStream, d, color, null);
    }

    public static void createPDF(VisJSONSpec visJSONSpec, ByteArrayOutputStream byteArrayOutputStream, double d, Color color, VisControl visControl) throws IOException {
        VisService.validateInputs(visJSONSpec, byteArrayOutputStream, "png", "Error in VisService.createPDF(VisJSONSpec, OutputStream, zoom, Color, VisControl) api");
        BufferedImage bufferedImage = (BufferedImage)VisService.getImage(visJSONSpec, "png", d, color, visControl);
        VisService.internalCreatePDF(bufferedImage, byteArrayOutputStream);
    }

    @Deprecated
    public static void createPDF(VisJSONSpec visJSONSpec, ByteArrayOutputStream byteArrayOutputStream, Dim dim, Color color) throws IOException {
        VisService.createPDF(visJSONSpec, byteArrayOutputStream, dim, color, null);
    }

    public static void createPDF(VisJSONSpec visJSONSpec, ByteArrayOutputStream byteArrayOutputStream, Dim dim, Color color, VisControl visControl) throws IOException {
        VisService.validateInputs(visJSONSpec, byteArrayOutputStream, "png", "Error in VisService.createPDF(VisJSONSpec, ByteArrayOutputStream, ImageSize, Color, VisControl) api");
        BufferedImage bufferedImage = (BufferedImage)VisService.getImage(visJSONSpec, "png", dim, color, visControl);
        VisService.internalCreatePDF(bufferedImage, byteArrayOutputStream);
    }

    @Deprecated
    public static void createPDF(VisJSONSpec visJSONSpec, ByteArrayOutputStream byteArrayOutputStream, Color color) throws IOException {
        VisService.createPDF(visJSONSpec, byteArrayOutputStream, color, null);
    }

    public static void createPDF(VisJSONSpec visJSONSpec, ByteArrayOutputStream byteArrayOutputStream, Color color, VisControl visControl) throws IOException {
        VisService.validateInputs(visJSONSpec, byteArrayOutputStream, "png", "Error in VisService.createPDF(VisJSONSpec, ByteArrayOutputStream, Color, VisControl) api");
        BufferedImage bufferedImage = (BufferedImage)VisService.getImage(visJSONSpec, "png", null, color, visControl);
        VisService.internalCreatePDF(bufferedImage, byteArrayOutputStream);
    }

    @Deprecated
    public static List<AreaShape> generateImageWithImageMap(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, Dim dim, Color color, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray) throws IOException {
        return VisService.generateImageWithImageMap(visJSONSpec, outputStream, string, dim, color, raveMainTypeArray, raveSubTypeArray, null);
    }

    public static List<AreaShape> generateImageWithImageMap(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, Dim dim, Color color, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray, VisControl visControl) throws IOException {
        Vis vis;
        VisService.validateInputs(visJSONSpec, outputStream, string, "Error in VisService.generateImageWithImageMap(VisJSONSpec,OutputStream,ImageFormat,ImageSize, backgroundColor, RaveMainType[], RaveSubType[], VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, dim, vis);
        VisService.generateImageFromSceneTree(outputStream, string, color, sceneTree);
        List<AreaShape> list = VisService.getImageMapParameters(raveMainTypeArray, raveSubTypeArray, sceneTree, vis);
        if (bl) {
            vis.dispose();
        }
        return list;
    }

    @Deprecated
    public static List<AreaShape> generateImageWithImageMap(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, double d, Color color, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray) throws IOException {
        return VisService.generateImageWithImageMap(visJSONSpec, outputStream, string, d, color, raveMainTypeArray, raveSubTypeArray, null);
    }

    public static List<AreaShape> generateImageWithImageMap(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, double d, Color color, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray, VisControl visControl) throws IOException {
        Vis vis;
        VisService.validateInputs(visJSONSpec, outputStream, string, "Error in VisService.generateImageWithImageMap(VisJSONSpec,OutputStream,ImageFormat,Zoom, backgroundColor, RaveMainType[], RaveSubType[], VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, null, vis);
        SceneTreeUtil.scaleBy(sceneTree, d);
        VisService.generateImageFromSceneTree(outputStream, string, color, sceneTree);
        List<AreaShape> list = VisService.getImageMapParameters(raveMainTypeArray, raveSubTypeArray, sceneTree, vis);
        if (bl) {
            vis.dispose();
        }
        return list;
    }

    @Deprecated
    public static RenderedImage getImageWithImageMap(VisJSONSpec visJSONSpec, String string, Dim dim, Color color, List<AreaShape> list, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray) {
        return VisService.getImageWithImageMap(visJSONSpec, string, dim, color, list, raveMainTypeArray, raveSubTypeArray, null);
    }

    public static RenderedImage getImageWithImageMap(VisJSONSpec visJSONSpec, String string, Dim dim, Color color, List<AreaShape> list, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray, VisControl visControl) {
        Vis vis;
        VisService.validateInputs(visJSONSpec, string, "Error in VisService.getImage(VisJSONSpec, imageFormat, imageSize, Color,List<AreaShape>, RaveMainType[], RaveSubType[], VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, dim, vis);
        BufferedImage bufferedImage = VisService.createBufferedImage(string, color, sceneTree);
        VisService.drawScene(sceneTree, bufferedImage);
        if (list != null) {
            List<AreaShape> list2 = VisService.getImageMapParameters(raveMainTypeArray, raveSubTypeArray, sceneTree, vis);
            list.addAll(list2);
        }
        if (bl) {
            vis.dispose();
        }
        return bufferedImage;
    }

    @Deprecated
    public static RenderedImage getImageWithImageMap(VisJSONSpec visJSONSpec, String string, double d, Color color, List<AreaShape> list, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray) {
        return VisService.getImageWithImageMap(visJSONSpec, string, d, color, list, raveMainTypeArray, raveSubTypeArray, null);
    }

    public static RenderedImage getImageWithImageMap(VisJSONSpec visJSONSpec, String string, double d, Color color, List<AreaShape> list, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray, VisControl visControl) {
        Vis vis;
        VisService.validateInputs(visJSONSpec, string, "Error in VisService.getImageWithImageMap(VisJSONSpec, imageFormat, zoom, Color, List<AreaShape>, RaveMainType[], RaveSubType[], VisControl) api");
        boolean bl = false;
        if (visControl == null) {
            vis = new Vis("VisService");
            bl = true;
        } else {
            vis = visControl.getVis();
        }
        SceneTree sceneTree = VisService.createSceneTree(visJSONSpec, null, vis);
        SceneTreeUtil.scaleBy(sceneTree, d);
        BufferedImage bufferedImage = VisService.createBufferedImage(string, color, sceneTree);
        VisService.drawScene(sceneTree, bufferedImage);
        if (list != null) {
            List<AreaShape> list2 = VisService.getImageMapParameters(raveMainTypeArray, raveSubTypeArray, sceneTree, vis);
            list.addAll(list2);
        }
        if (bl) {
            vis.dispose();
        }
        return bufferedImage;
    }

    private static void generateImageFromSceneTree(OutputStream outputStream, String string, Color color, SceneTree sceneTree) throws IOException {
        BufferedImage bufferedImage = VisService.createBufferedImage(string, color, sceneTree);
        VisService.drawScene(sceneTree, bufferedImage);
        ImageIO.write((RenderedImage)bufferedImage, string.toLowerCase(), outputStream);
    }

    private static void validateInputs(VisJSONSpec visJSONSpec, OutputStream outputStream, String string, String string2) throws EngineException {
        if (outputStream == null) {
            throw new EngineException("Invalid argument : imageStream cannot be null", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, string2);
        }
        VisService.validateInputs(visJSONSpec, string, string2);
    }

    private static void validateInputs(VisJSONSpec visJSONSpec, String string, String string2) throws EngineException {
        if (visJSONSpec == null) {
            throw new EngineException("Invalid argument : spec cannot be null", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, string2);
        }
        if (string == null) {
            throw new EngineException("Invalid argument : imageFormat cannot be null", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, string2);
        }
        if (!VisService.isImageFormatSupported(string)) {
            throw new EngineException("Invalid argument : imageFormat not supported. It cannot be '" + string + "'", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, string2);
        }
    }

    private static String createImageFormat(String string) {
        formats.add(string);
        return string;
    }

    private static List<String> buildSupportedFormats() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!formats.contains(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawScene(SceneTree sceneTree, BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AWTGraphicsRenderer aWTGraphicsRenderer = new AWTGraphicsRenderer(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        try {
            try {
                Renderer.render(aWTGraphicsRenderer, sceneTree, null);
            }
            finally {
                aWTGraphicsRenderer.dispose();
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    private static BufferedImage createBufferedImage(String string, Color color, SceneTree sceneTree) {
        Dim dim = sceneTree.getScaledSize();
        BufferedImage bufferedImage = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 6);
        Color color2 = null;
        String string2 = string.toLowerCase();
        if (BMP.equals(string2) || JPG.equals(string2) || JPEG.equals(string2) || GIF.equals(string2)) {
            color2 = color != null ? color : DEFAULT_BACK_COLOR;
        } else if (PNG.equals(string2)) {
            color2 = color;
        }
        bufferedImage = VisService.fillTransparentPixels(bufferedImage, color2);
        return bufferedImage;
    }

    private static SceneTree createSceneTree(VisJSONSpec visJSONSpec, Dim dim, Vis vis) {
        if (dim != null) {
            if (visJSONSpec.size == null) {
                visJSONSpec.size = new SizeSpec();
            }
            visJSONSpec.size.width = dim.getWidth();
            visJSONSpec.size.height = dim.getHeight();
        }
        VisState visState = vis.setTypedSpecification(visJSONSpec);
        return vis.makeSceneTree(dim, visState).getSceneTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage fillTransparentPixels(BufferedImage bufferedImage, Color color) {
        if (color != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            try {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawRenderedImage(bufferedImage, null);
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage2;
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalCreatePDF(BufferedImage bufferedImage, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        PDDocument pDDocument = null;
        try {
            pDDocument = new PDDocument();
            PDRectangle pDRectangle = new PDRectangle((float)bufferedImage.getWidth(), (float)bufferedImage.getHeight());
            PDPage pDPage = new PDPage(pDRectangle);
            pDDocument.addPage(pDPage);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream2);
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedImage = ImageIO.read(byteArrayInputStream);
            PDImageXObject pDImageXObject = LosslessFactory.createFromImage((PDDocument)pDDocument, (BufferedImage)bufferedImage);
            PDPageContentStream pDPageContentStream = null;
            try {
                pDPageContentStream = new PDPageContentStream(pDDocument, pDPage);
                pDPageContentStream.drawImage(pDImageXObject, 0.0f, 0.0f);
            }
            finally {
                if (pDPageContentStream != null) {
                    pDPageContentStream.close();
                }
            }
            pDDocument.save((OutputStream)byteArrayOutputStream);
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
    }

    private static List<AreaShape> getImageMapParameters(RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray, SceneTree sceneTree, Vis vis) {
        ImageMap imageMap = new ImageMap(vis, raveMainTypeArray, raveSubTypeArray);
        List<AreaShape> list = imageMap.createShapes(sceneTree);
        return list;
    }
}

