/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.services.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;
import java.util.HashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/utilities")
public class GetLayerNamesUtilities {
    public static final String MIGRATE_VALIDATE_LAYER = "com/ibm/vis/layers/migrationLayer.js";
    public static final String TEMPLATES_LAYER = "com/ibm/vis/layers/templateLayer.js";
    public static final String SAMPLE_DATA_PROVIDER_LAYER = "com/ibm/vis/layers/sampleDataProviderLayer.js";
    public static final String INTERACTION_LAYER = "com/ibm/vis/layers/interactionLayer.js";
    private static final String VERSION = "version";
    private Vis vis;

    public void dispose() {
        if (this.vis != null) {
            this.vis.dispose();
        }
    }

    public void setSpecificationDefaultVersion(String string) {
        if (string == null || string.isEmpty()) {
            this.getVis().setSpecificationDefaultVersion(null);
        } else {
            this.getVis().setSpecificationDefaultVersion(Version.parseVersion(string));
        }
    }

    public boolean findKeywordSequence(JSONObject jSONObject, String[] stringArray, int n) {
        if (jSONObject == null) {
            return false;
        }
        if (stringArray.length - 1 == n) {
            return BasicFactory.containsKey(jSONObject, stringArray[n]);
        }
        Object object = BasicFactory.getItem(jSONObject, stringArray[n]);
        ++n;
        if (BasicFactory.isArray(object)) {
            boolean bl = false;
            JSONArray jSONArray = (JSONArray)object;
            int n2 = BasicFactory.size(jSONArray);
            for (int i = 0; i < n2 && !bl; ++i) {
                jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
                bl = this.findKeywordSequence(jSONObject, stringArray, n);
            }
            return bl;
        }
        return this.findKeywordSequence((JSONObject)object, stringArray, n);
    }

    public boolean hasNonSimpleLegends(JSONObject jSONObject) {
        boolean bl = false;
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONObject, "legends");
        if (jSONArray == null) {
            return bl;
        }
        int n = BasicFactory.size(jSONArray);
        for (int i = 0; i < n; ++i) {
            String string;
            JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            if (jSONObject2 == null || (string = (String)BasicFactory.getItem(jSONObject2, "method")) == null || "simple".equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void configureLayersWithOptions(int n, HashSet<String> hashSet) {
        if (n != 0) {
            if ((n & 0x18) > 0) {
                hashSet.add(TEMPLATES_LAYER);
            }
            if ((n & 6) > 0) {
                hashSet.add(MIGRATE_VALIDATE_LAYER);
            }
            if ((n & 1) > 0) {
                hashSet.add(SAMPLE_DATA_PROVIDER_LAYER);
            }
            if ((n & 0x20) > 0) {
                hashSet.add(INTERACTION_LAYER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject migrateSpecIfNeeded(JSONObject jSONObject, HashSet<String> hashSet) {
        if (!BasicFactory.containsKey(jSONObject, VERSION)) {
            hashSet.add(MIGRATE_VALIDATE_LAYER);
            this.getVis().setSpecificationValidation(true);
        }
        try {
            Version version = Version.parseVersion((String)BasicFactory.getItem(jSONObject, VERSION));
            if (!Vis.CURRENT_VERSION.equals(version)) {
                jSONObject = this.getVis().migrateAndValidateSpec(jSONObject);
                hashSet.add(MIGRATE_VALIDATE_LAYER);
            }
        }
        finally {
            this.getVis().setSpecificationValidation(false);
        }
        return jSONObject;
    }

    private Vis getVis() {
        if (this.vis == null) {
            this.vis = new Vis(null);
            this.vis.setSpecificationValidation(false);
        }
        return this.vis;
    }

    public String[] toArray(Set<String> set) {
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            stringArray[n++] = string;
        }
        return stringArray;
    }
}

