/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.services.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisImageServicePDFUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePDFImage(OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        PDDocument pDDocument = null;
        try {
            pDDocument = new PDDocument();
            PDRectangle pDRectangle = new PDRectangle((float)bufferedImage.getWidth(), (float)bufferedImage.getHeight());
            PDPage pDPage = new PDPage(pDRectangle);
            pDDocument.addPage(pDPage);
            PDImageXObject pDImageXObject = LosslessFactory.createFromImage((PDDocument)pDDocument, (BufferedImage)bufferedImage);
            PDPageContentStream pDPageContentStream = null;
            try {
                pDPageContentStream = new PDPageContentStream(pDDocument, pDPage);
                pDPageContentStream.drawImage(pDImageXObject, 0.0f, 0.0f);
            }
            finally {
                if (pDPageContentStream != null) {
                    pDPageContentStream.close();
                }
            }
            pDDocument.save(outputStream);
        }
        finally {
            pDDocument.close();
        }
    }
}

