/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.PaletteParameter;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.RaveColor;
import java.util.ArrayList;
import java.util.List;

public class ColorPaletteParameter
extends PaletteParameter {
    private List<RaveColor> raveColorList = new ArrayList<RaveColor>();

    public ColorPaletteParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.COLOR_PALETTE;
    }

    public List<RaveColor> getColorPalette() {
        return this.raveColorList;
    }

    public void addColor(RaveColor raveColor) {
        TemplateUtils.validateForNotNullValue(raveColor, ErrorCode.PARAMETER_INVALID_VALUE, "Null color value in Color Palette is not supported.");
        this.raveColorList.add(raveColor);
    }

    public void insertColor(RaveColor raveColor, int n) {
        this.insertPaletteItem(raveColor, n);
    }

    public void setColorPalette(List<RaveColor> list) {
        this.setPalette(list);
    }

    public RaveColor getColorAtIndex(int n) {
        return (RaveColor)this.getItemAtIndex(n);
    }

    @Override
    protected void setValueUsingJSONArray(JSONArray jSONArray) {
        int n = BasicFactory.getJSONArraySize(jSONArray);
        this.raveColorList = new ArrayList<RaveColor>();
        for (int i = 0; i < n; ++i) {
            Object object = BasicFactory.getArrayItem(jSONArray, i);
            RaveColor raveColor = new RaveColor();
            raveColor.setValue(object);
            this.addColor(raveColor);
        }
    }

    @Override
    protected List getPaletteList() {
        return this.getColorPalette();
    }
}

