/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.RaveColor;
import java.util.List;

public class ColorParameter
extends Parameter {
    private Object colorValue;
    private final String NULL_ERROR_MSG = "Null value is not supported in ColorParameter";

    public ColorParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.COLOR;
    }

    @Override
    public boolean hasValue() {
        return this.colorValue != null;
    }

    @Override
    public Object getValue() {
        return this.colorValue;
    }

    @Override
    public void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Null value is not supported in ColorParameter");
        RaveColor raveColor = new RaveColor();
        raveColor.setValue(object);
        this.colorValue = raveColor.getValue();
    }

    public void setColorValue(RaveColor raveColor) {
        TemplateUtils.validateForNotNullValue(raveColor, ErrorCode.PARAMETER_INVALID_VALUE, "Null value is not supported in ColorParameter");
        TemplateUtils.validateForNotNullValue(raveColor.getValue(), ErrorCode.PARAMETER_INVALID_VALUE, "Null value is not supported in ColorParameter");
        this.colorValue = raveColor.getValue();
    }
}

