/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class CompositeParameter
extends Parameter {
    protected final List<Parameter> parameters = new ArrayList<Parameter>();
    protected final Map<String, Object> extraParams = new HashMap<String, Object>();
    protected Object compositeValue = null;

    public CompositeParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public Object getValue() {
        return this.compositeValue;
    }

    @Override
    public boolean hasValue() {
        return this.compositeValue != null;
    }

    protected Object resolveParameters() {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        for (Parameter object : this.parameters) {
            Object object2 = object.getValue();
            String string = object.getLabel();
            BasicFactory.put(jSONObject, string, object2);
        }
        for (String string : this.extraParams.keySet()) {
            BasicFactory.put(jSONObject, string, this.extraParams.get(string));
        }
        return jSONObject;
    }

    @Override
    public final void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Parameter value can not be null");
        if (BasicFactory.isObject(object)) {
            this.initParameters(object);
            this.compositeValue = this.resolveParameters();
        } else {
            this.reportTypeMismatch(object);
        }
    }

    protected void initParameters(Object object) {
        String[] stringArray = BasicFactory.keySet(object);
        Parameter parameter = null;
        for (String string : stringArray) {
            parameter = null;
            parameter = this.createParameter(string, BasicFactory.getItem(object, string));
            if (parameter != null) {
                this.parameters.add(parameter);
                continue;
            }
            Object object2 = BasicFactory.getItem(object, string);
            this.extraParams.put(string, object2);
        }
    }

    protected abstract Parameter createParameter(String var1, Object var2);
}

