/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.internal.json.JSONTreeNode;
import com.ibm.vis.template.CompositeParameter;
import com.ibm.vis.template.LengthParameter;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.StringParameter;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import java.util.List;

public class FontParameter
extends CompositeParameter {
    private static final String WEIGHT = "weight";
    private static final String FAMILY = "family";
    private static final String STYLE = "style";
    private static final String SIZE = "size";
    protected static final String BOLD = "bold";
    protected static final String NORMAL = "normal";
    protected static final String REGULAR = "regular";
    protected static final String ITALIC = "italic";

    public FontParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.FONT;
    }

    @Override
    protected Parameter createParameter(String string, Object object) {
        Parameter parameter = null;
        if (SIZE.equals(string)) {
            parameter = this.createFontSizeParameter(object);
        } else if (STYLE.equals(string)) {
            parameter = this.createFontStyleParameter(object);
        } else if (FAMILY.equals(string)) {
            parameter = this.createFontFamilyParameter(object);
        } else if (WEIGHT.equals(string)) {
            parameter = this.createFontWeightParameter(object);
        }
        return parameter;
    }

    public void setFontFamily(String string) {
        this.parameters.add(this.createFontFamilyParameter(string));
        this.compositeValue = this.resolveParameters();
    }

    public void setFontSize(Object object) {
        this.parameters.add(this.createFontSizeParameter(object));
        this.compositeValue = this.resolveParameters();
    }

    public void setFontStyle(String string) {
        this.parameters.add(this.createFontStyleParameter(string));
        this.compositeValue = this.resolveParameters();
    }

    public void setFontWeight(String string) {
        this.parameters.add(this.createFontWeightParameter(string));
        this.compositeValue = this.resolveParameters();
    }

    private Parameter createFontFamilyParameter(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Font Family value should not be null");
        StringParameter stringParameter = new StringParameter(this.getId(), FAMILY, this.getDescription(), this.isRequired(), null, null, this.getResolveOrder());
        stringParameter.setValue(object);
        return stringParameter;
    }

    private Parameter createFontSizeParameter(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Font size value should not be null");
        LengthParameter lengthParameter = new LengthParameter(this.getId(), SIZE, this.getDescription(), this.isRequired(), null, null, this.getResolveOrder());
        lengthParameter.setValue(object);
        return lengthParameter;
    }

    private Parameter createFontStyleParameter(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Font style value should not be null");
        StringParameter stringParameter = new StringParameter(this.getId(), STYLE, this.getDescription(), this.isRequired(), null, null, this.getResolveOrder());
        stringParameter.setValue(object);
        return stringParameter;
    }

    private Parameter createFontWeightParameter(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Font weight value should not be null");
        StringParameter stringParameter = new StringParameter(this.getId(), WEIGHT, this.getDescription(), this.isRequired(), null, null, this.getResolveOrder());
        stringParameter.setValue(object);
        return stringParameter;
    }

    @Override
    protected void setValueInNode(JSONTreeNode jSONTreeNode, Object object) {
        if (BasicFactory.isObject(object)) {
            String[] stringArray;
            for (String string : stringArray = BasicFactory.keySet(object)) {
                Object object2 = BasicFactory.getItem(object, string);
                JSONTreeNode jSONTreeNode2 = new JSONTreeNode(object2, jSONTreeNode, string);
                jSONTreeNode.addChild(jSONTreeNode2);
            }
        } else {
            super.setValueInNode(jSONTreeNode, object);
        }
    }
}

