/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.template.internal.JSONSerializationKeyComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JSONSerialization {
    private int verbosity = 1;
    public static final int VERBOSITY_COMPACT = 0;
    public static final int VERBOSITY_REGULAR = 1;
    public static final int VERBOSITY_VERBOSE = 2;
    private int lineWidth = 80;
    private int order = 2;
    public static final int ORDER_LEXICAL = 0;
    public static final int ORDER_VIZJSON = 1;
    public static final int ORDER_SCENETREE = 2;
    private String serialization = "";
    private int level;
    private int lastNewlineIndex;
    private Comparator<String> propertyComparator;
    private Set<String> verboseProperties;
    private static final Comparator<String> VIZJSON_COMPARATOR;
    private static final Comparator<String> SCENETREE_COMPARATOR;
    private static final Comparator<String> LEXICAL_COMPARATOR;
    private static final Set<String> VIZJSON_VERBOSE_PROPERTIES;

    public static Object deserialize(String string) throws Exception {
        return BasicFactory.parseObjectOrArray(string);
    }

    public JSONSerialization() {
        this.setOrderingProperties();
    }

    public static JSONSerialization forVizJSONDisplay(int n) {
        JSONSerialization jSONSerialization = new JSONSerialization();
        jSONSerialization.setOrdering(1);
        jSONSerialization.setVerbosity(1);
        jSONSerialization.setLineWidth(n);
        return jSONSerialization;
    }

    public static JSONSerialization forSceneTreeDisplay(int n) {
        JSONSerialization jSONSerialization = new JSONSerialization();
        jSONSerialization.setOrdering(2);
        jSONSerialization.setVerbosity(1);
        jSONSerialization.setLineWidth(n);
        return jSONSerialization;
    }

    public static JSONSerialization forSceneTreeComparison() {
        JSONSerialization jSONSerialization = new JSONSerialization();
        jSONSerialization.setOrdering(2);
        jSONSerialization.setVerbosity(2);
        jSONSerialization.setLineWidth(0);
        return jSONSerialization;
    }

    public static JSONSerialization forJSONComparison() {
        JSONSerialization jSONSerialization = new JSONSerialization();
        jSONSerialization.setOrdering(0);
        jSONSerialization.setVerbosity(0);
        jSONSerialization.setLineWidth(0);
        return jSONSerialization;
    }

    public final void clear() {
        this.serialization = "";
    }

    public String toString() {
        return this.serialization;
    }

    public final void setOrdering(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.order = n;
            this.setOrderingProperties();
        }
    }

    public final int getOrdering() {
        return this.order;
    }

    public final void setVerbosity(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.verbosity = n;
        }
    }

    public final int getVerbosity() {
        return this.verbosity;
    }

    public final void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public final int getLineWidth() {
        return this.lineWidth;
    }

    public String serialize(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        this.level = 0;
        this.lastNewlineIndex = 0;
        if (object != null) {
            this.serializeValue(stringBuilder, object, false);
        }
        stringBuilder.append("\n");
        this.serialization = stringBuilder.toString();
        return this.serialization;
    }

    void serializeValue(StringBuilder stringBuilder, Object object, boolean bl) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (BasicFactory.isBoolean(object)) {
            stringBuilder.append((Boolean)object != false ? "true" : "false");
        } else if (BasicFactory.isNumber(object)) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(BasicFactory.unformattedNumber((Number)object));
            }
        } else if (BasicFactory.isString(object)) {
            this.serializeString(stringBuilder, (String)object);
        } else if (BasicFactory.isArray(object)) {
            this.serializeArray(stringBuilder, (JSONArray)object, bl);
        } else if (BasicFactory.isObject(object)) {
            this.serializeObject(stringBuilder, (JSONObject)object, bl);
        }
    }

    private void serializeString(StringBuilder stringBuilder, String string) {
        stringBuilder.append("\"");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("\"");
    }

    void serializeArray(StringBuilder stringBuilder, JSONArray jSONArray, boolean bl) {
        int n = BasicFactory.size(jSONArray);
        if (n == 0) {
            stringBuilder.append("[]");
        } else if (bl || this.verbosity != 1 || !this.serializeArraySingleLine(stringBuilder, jSONArray, n)) {
            this.serializeArrayMultipleLines(stringBuilder, jSONArray, n);
        }
    }

    boolean serializeArraySingleLine(StringBuilder stringBuilder, JSONArray jSONArray, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            if (JSONSerialization.isPrimitive(BasicFactory.getArrayItem(jSONArray, n2))) continue;
            return false;
        }
        n2 = stringBuilder.length() - this.lastNewlineIndex;
        if (this.lineWidth > 0 && n2 > this.lineWidth) {
            return false;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("[ ");
        for (int i = 0; i < n; ++i) {
            this.serializeValue(stringBuilder2, BasicFactory.getArrayItem(jSONArray, i), false);
            if (i < n - 1) {
                stringBuilder2.append(", ");
            }
            if (this.lineWidth <= 3 || n2 + stringBuilder2.length() <= this.lineWidth - 3) continue;
            return false;
        }
        stringBuilder2.append(" ]");
        stringBuilder.append(stringBuilder2.toString());
        return true;
    }

    void serializeArrayMultipleLines(StringBuilder stringBuilder, JSONArray jSONArray, int n) {
        stringBuilder.append("[");
        ++this.level;
        this.addLineSeparator(stringBuilder);
        for (int i = 0; i < n; ++i) {
            this.serializeValue(stringBuilder, BasicFactory.getArrayItem(jSONArray, i), false);
            if (i >= n - 1) continue;
            stringBuilder.append(",");
            this.addLineSeparator(stringBuilder);
        }
        --this.level;
        this.addLineSeparator(stringBuilder);
        stringBuilder.append("]");
    }

    void serializeObject(StringBuilder stringBuilder, JSONObject jSONObject, boolean bl) {
        String[] stringArray = this.getKeySet(jSONObject);
        if (stringArray == null) {
            stringBuilder.append("{}");
        } else if (bl || this.verbosity != 1 || !this.serializeObjectSingleLine(stringBuilder, jSONObject, stringArray)) {
            this.serializeObjectMultipleLines(stringBuilder, jSONObject, stringArray);
        }
    }

    boolean serializeObjectSingleLine(StringBuilder stringBuilder, JSONObject jSONObject, String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            if (JSONSerialization.isPrimitive(BasicFactory.getItem(jSONObject, stringArray[n]))) continue;
            return false;
        }
        n = stringBuilder.length() - this.lastNewlineIndex;
        if (this.lineWidth > 0 && n > this.lineWidth) {
            return false;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("{ ");
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            this.serializeString(stringBuilder2, string);
            stringBuilder2.append(": ");
            this.serializeValue(stringBuilder2, BasicFactory.getItem(jSONObject, string), false);
            if (i < n2 - 1) {
                stringBuilder2.append(", ");
            }
            if (this.lineWidth <= 0 || stringBuilder2.length() + n <= this.lineWidth - 3) continue;
            return false;
        }
        stringBuilder2.append(" }");
        stringBuilder.append(stringBuilder2.toString());
        return true;
    }

    void serializeObjectMultipleLines(StringBuilder stringBuilder, JSONObject jSONObject, String[] stringArray) {
        int n = stringArray.length;
        stringBuilder.append("{");
        ++this.level;
        this.addLineSeparator(stringBuilder);
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            this.serializeString(stringBuilder, string);
            stringBuilder.append(":");
            if (this.verbosity != 0) {
                stringBuilder.append(" ");
            }
            this.serializeValue(stringBuilder, BasicFactory.getItem(jSONObject, string), this.verboseProperties != null && this.verboseProperties.contains(string));
            if (i >= n - 1) continue;
            stringBuilder.append(",");
            this.addLineSeparator(stringBuilder);
        }
        --this.level;
        this.addLineSeparator(stringBuilder);
        stringBuilder.append("}");
    }

    String[] getKeySet(JSONObject jSONObject) {
        String[] stringArray = BasicFactory.keySet(jSONObject);
        if (stringArray.length == 0) {
            return null;
        }
        Arrays.sort(stringArray, this.propertyComparator);
        return stringArray;
    }

    private void setOrderingProperties() {
        if (this.order == 1) {
            this.propertyComparator = VIZJSON_COMPARATOR;
            this.verboseProperties = VIZJSON_VERBOSE_PROPERTIES;
        } else if (this.order == 2) {
            this.propertyComparator = SCENETREE_COMPARATOR;
            this.verboseProperties = null;
        } else {
            this.propertyComparator = LEXICAL_COMPARATOR;
            this.verboseProperties = null;
        }
    }

    private void addLineSeparator(StringBuilder stringBuilder) {
        if (this.verbosity != 0) {
            stringBuilder.append("\n");
            this.lastNewlineIndex = stringBuilder.length();
            for (int i = 0; i < this.level; ++i) {
                stringBuilder.append("  ");
            }
        }
    }

    private static boolean isPrimitive(Object object) {
        return object == null || BasicFactory.isNumber(object) || BasicFactory.isString(object) || BasicFactory.isBoolean(object);
    }

    static {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        hashMap.put("id", 0);
        hashMap.put("type", 1);
        hashMap.put("method", 2);
        VIZJSON_COMPARATOR = new JSONSerializationKeyComparator(hashMap);
        hashMap = new HashMap();
        hashMap.put("id", 0);
        hashMap.put("type", 1);
        hashMap.put("shape", 2);
        hashMap.put("children", 3);
        SCENETREE_COMPARATOR = new JSONSerializationKeyComparator(hashMap);
        LEXICAL_COMPARATOR = new JSONSerializationKeyComparator(null);
        VIZJSON_VERBOSE_PROPERTIES = new HashSet<String>();
        VIZJSON_VERBOSE_PROPERTIES.add("coordinates");
        VIZJSON_VERBOSE_PROPERTIES.add("dimensions");
        VIZJSON_VERBOSE_PROPERTIES.add("elements");
        VIZJSON_VERBOSE_PROPERTIES.add("fields");
    }
}

