/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.RaveLength;
import java.util.List;

public class LengthParameter
extends Parameter {
    private final String NULL_ERROR_MSG = "Null value is not supported in LengthParameter";
    private Object lengthValue;

    public LengthParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.LENGTH;
    }

    @Override
    public boolean hasValue() {
        return this.lengthValue != null;
    }

    @Override
    public Object getValue() {
        return this.lengthValue;
    }

    @Override
    public void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Null value is not supported in LengthParameter");
        RaveLength raveLength = new RaveLength();
        raveLength.setValue(object);
        this.lengthValue = raveLength.getValue();
    }

    public void setLengthValue(RaveLength raveLength) {
        TemplateUtils.validateForNotNullValue(raveLength, ErrorCode.PARAMETER_INVALID_VALUE, "Null value is not supported in LengthParameter");
        TemplateUtils.validateForNotNullValue(raveLength.getValue(), ErrorCode.PARAMETER_INVALID_VALUE, "Null value is not supported in LengthParameter");
        this.lengthValue = raveLength.getValue();
    }
}

