/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.AbstractDataType;
import java.util.List;

public abstract class PaletteParameter
extends Parameter {
    public PaletteParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public boolean hasValue() {
        return this.getPaletteList() != null && this.getPaletteList().size() > 0;
    }

    @Override
    public Object getValue() {
        return this.getUpdatedValue();
    }

    private JSONArray getUpdatedValue() {
        JSONArray jSONArray = null;
        if (this.hasValue()) {
            jSONArray = BasicFactory.createJSONArray();
            List list = this.getPaletteList();
            for (Object e : list) {
                BasicFactory.add(jSONArray, ((AbstractDataType)e).getValue());
            }
        }
        return jSONArray;
    }

    @Override
    public void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Null item in Palette is not supported.");
        if (BasicFactory.isArray(object)) {
            JSONArray jSONArray = (JSONArray)object;
            int n = BasicFactory.getJSONArraySize(jSONArray);
            TemplateUtils.validate(n >= 0, ErrorCode.PARAMETER_INVALID_VALUE, "Empty palette list cannot be added.");
            this.setValueUsingJSONArray(jSONArray);
        } else {
            this.reportTypeMismatch(object);
        }
    }

    protected abstract void setValueUsingJSONArray(JSONArray var1);

    public void addPaletteItem(AbstractDataType abstractDataType) {
        TemplateUtils.validateForNotNullValue(abstractDataType, ErrorCode.PARAMETER_INVALID_VALUE, "Insertion of null value is not supported in palette.");
        this.getPaletteList().add(abstractDataType);
    }

    protected void insertPaletteItem(AbstractDataType abstractDataType, int n) {
        TemplateUtils.validateForNotNullValue(abstractDataType, ErrorCode.PARAMETER_INVALID_VALUE, "Insertion of null value is not supported in palette.");
        TemplateUtils.validateForNotNullValue(abstractDataType.getValue(), ErrorCode.PARAMETER_INVALID_VALUE, "Insertion of empty object is not supported in palette");
        TemplateUtils.validate(n >= 0, ErrorCode.TEMPLATE_INVALID_ARGUMENT, "Insertion at negative index values is not supported.");
        TemplateUtils.validate(this.getPaletteList().size() >= n, ErrorCode.TEMPLATE_INVALID_ARGUMENT, "Index for insertion is greater then size for the palette array.");
        this.getPaletteList().add(n, abstractDataType);
    }

    protected abstract List getPaletteList();

    protected void setPalette(List list) {
        TemplateUtils.validateForNotNullValue(list, ErrorCode.PARAMETER_INVALID_VALUE, "Null Palette list is not supported.");
        TemplateUtils.validate(list.size() > 0, ErrorCode.PARAMETER_INVALID_VALUE, "Empty palette cannot be added.");
        for (Object e : list) {
            TemplateUtils.validateForNotNullValue(((AbstractDataType)e).getValue(), ErrorCode.PARAMETER_INVALID_VALUE, "Null item in Palette is not supported.");
        }
        this.getPaletteList().clear();
        this.getPaletteList().addAll(list);
    }

    protected Object getItemAtIndex(int n) {
        TemplateUtils.validate(n >= 0, ErrorCode.TEMPLATE_INVALID_ARGUMENT, "Negative index values are not supported.");
        TemplateUtils.validate(this.getPaletteList().size() > n, ErrorCode.TEMPLATE_INVALID_ARGUMENT, "Index for insertion is greater then size for the palette array.");
        return this.getPaletteList().get(n);
    }
}

