/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.internal.json.JSONTreeNode;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.ResolutionMethodType;
import com.ibm.vis.template.parser.JSONPathParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Parameter {
    private final String id;
    private final String label;
    private final String description;
    private final boolean required;
    private final List<ResolutionItem> resolution;
    private final List<ResolutionCase> resolutionCases;
    private final Integer resolveOrder;
    private Integer index;

    public Parameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        this.id = string;
        this.label = string2;
        this.description = string3;
        this.required = bl;
        this.resolution = list;
        this.resolutionCases = list2;
        this.resolveOrder = n;
    }

    public final String getId() {
        return this.id;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Integer getIndex() {
        return this.index;
    }

    public final void setIndex(Integer n) {
        this.index = n;
    }

    public final Integer getResolveOrder() {
        return this.resolveOrder;
    }

    public abstract ParameterType getType();

    public final boolean isRequired() {
        return this.required;
    }

    public abstract boolean hasValue();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    void resolve(JSONPathParser jSONPathParser, Map<String, Parameter> map) {
        if (this.hasValue() && (this.getType() != ParameterType.BOOLEAN || ((Boolean)this.getValue()).booleanValue())) {
            this.resolveResolutions(this.resolution, jSONPathParser, map);
        }
        this.resolveResolutionCases(this.resolutionCases, jSONPathParser, map);
    }

    private void resolveResolutions(List<ResolutionItem> list, JSONPathParser jSONPathParser, Map<String, Parameter> map) {
        if (list != null) {
            for (ResolutionItem resolutionItem : list) {
                List<JSONTreeNode> list2;
                if (resolutionItem.getMethod() == ResolutionMethodType.SET || resolutionItem.getMethod() == ResolutionMethodType.CREATE_OR_SET) {
                    list2 = Parameter.resolveParameterValue(map, resolutionItem, jSONPathParser);
                    if (list2 == null) continue;
                    boolean bl = resolutionItem.getMethod() != ResolutionMethodType.SET;
                    List<JSONTreeNode> list3 = jSONPathParser.parseExpression(resolutionItem.getTarget(), bl);
                    for (JSONTreeNode jSONTreeNode : list3) {
                        this.setValueInNode(jSONTreeNode, list2);
                    }
                    continue;
                }
                if (resolutionItem.getMethod() != ResolutionMethodType.REMOVE) continue;
                list2 = jSONPathParser.parseExpression(resolutionItem.getTarget(), false);
                for (JSONTreeNode jSONTreeNode : list2) {
                    jSONTreeNode.remove();
                }
            }
        }
    }

    protected void setValueInNode(JSONTreeNode jSONTreeNode, Object object) {
        jSONTreeNode.replaceValue(object);
    }

    private void resolveResolutionCases(List<ResolutionCase> list, JSONPathParser jSONPathParser, Map<String, Parameter> map) {
        if (list != null) {
            boolean bl = false;
            ArrayList<ResolutionCase> arrayList = new ArrayList<ResolutionCase>();
            for (ResolutionCase resolutionCase : list) {
                Object object = resolutionCase.getCaseStatement();
                if (object == null) {
                    arrayList.add(resolutionCase);
                    continue;
                }
                if (!this.hasValue() || !this.getValue().equals(object)) continue;
                this.resolveResolutions(resolutionCase.getResolutionItems(), jSONPathParser, map);
                bl = true;
            }
            if (!bl) {
                for (ResolutionCase resolutionCase : arrayList) {
                    this.resolveResolutions(resolutionCase.getResolutionItems(), jSONPathParser, map);
                }
            }
        }
    }

    private static Object resolveParameterValue(Map<String, Parameter> map, ResolutionItem resolutionItem, JSONPathParser jSONPathParser) {
        List<JSONTreeNode> list;
        Object object = null;
        if (resolutionItem.getSourceParameter() != null) {
            Parameter parameter = map.get(resolutionItem.getSourceParameter());
            object = parameter.getValue();
        } else if (resolutionItem.getSourceValue() != null) {
            object = resolutionItem.getSourceValue();
        } else if (resolutionItem.getSourcePath() != null && (list = jSONPathParser.parseExpression(resolutionItem.getSourcePath().toString(), false)) != null && list.size() > 0) {
            object = list.get(0).getJSONObject();
        }
        return object;
    }

    void reportTypeMismatch(Object object) {
        String string = this.getId();
        if (this.getLabel() != null) {
            string = string + "(" + this.getLabel() + ")";
        }
        if (object != null) {
            string = string + ":" + object.toString();
        }
        throw new EngineException(null, ErrorCode.PARAMETER_VALUE_TYPE_MISMATCH, string);
    }
}

