/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.PaletteParameter;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.RaveStyle;
import java.util.ArrayList;
import java.util.List;

public class StyleByPaletteParameter
extends PaletteParameter {
    private List<RaveStyle> raveStyleList = new ArrayList<RaveStyle>();

    public StyleByPaletteParameter(String string, String string2, String string3, boolean bl, List<ResolutionItem> list, List<ResolutionCase> list2, Integer n) {
        super(string, string2, string3, bl, list, list2, n);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.STYLEBY_PALETTE;
    }

    public void addStyle(RaveStyle raveStyle) {
        TemplateUtils.validateForNotNullValue(raveStyle, ErrorCode.PARAMETER_INVALID_VALUE, "Null style value in StyleBy Palette is not supported.");
        this.raveStyleList.add(raveStyle);
    }

    public void insertStyle(RaveStyle raveStyle, int n) {
        this.insertPaletteItem(raveStyle, n);
    }

    public RaveStyle getStyleAtIndex(int n) {
        return (RaveStyle)this.getItemAtIndex(n);
    }

    public void setStylePalette(List<RaveStyle> list) {
        this.setPalette(list);
    }

    public List<RaveStyle> getStylePalette() {
        return this.raveStyleList;
    }

    @Override
    protected void setValueUsingJSONArray(JSONArray jSONArray) {
        int n = BasicFactory.getJSONArraySize(jSONArray);
        this.raveStyleList = new ArrayList<RaveStyle>();
        for (int i = 0; i < n; ++i) {
            Object object = BasicFactory.getArrayItem(jSONArray, i);
            RaveStyle raveStyle = new RaveStyle();
            raveStyle.setValue(object);
            this.addStyle(raveStyle);
        }
    }

    @Override
    protected List getPaletteList() {
        return this.getStylePalette();
    }
}

